/**
 * Copyright (c) 2017 CA, All rights reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.filemaster.dsnlists.handlers;
/**
 * @author galpe02
 *
 */
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.dsnlists.wizards.CreateUpdateDSNListWizard;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class Properties extends AbstractHandler {
static final String cacopyright = "Copyright (c) 2017 CA"; //$NON-NLS-1$
private FMServerTreeModel model=FMServerTreeModel.getInstance();
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		CreateUpdateDSNListWizard wizard = new CreateUpdateDSNListWizard(false);
		IWorkbenchWindow window = HandlerUtil
				.getActiveWorkbenchWindowChecked(event);
		IWorkbench workbench = window.getWorkbench();
		ISelection selection = HandlerUtil.getCurrentSelection(event);
		if(model.getServers().length>0){
		if (!(selection instanceof IStructuredSelection))
			selection = null;
		wizard.init(workbench, (IStructuredSelection) selection);
		Shell shell = window.getShell();
		TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell,
				wizard);
		dialog.create();
		dialog.open();
	}else{
		TT_ErrorDialog.openError(null,"Server Not Defined", "There is no server defined in the Directory List view.",
				new Throwable(
				" Server must be defined the in Directory List View before completing this task."));
	}

		return null;
	}
}




















