/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.utils.CharacterStringValidator;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.DataTypeUtils;
import com.ca.db2.editor.ui.utils.DateValidator;
import com.ca.db2.editor.ui.utils.NumericValidator;
import com.ca.db2.editor.ui.utils.TimeStampValidator;
import com.ca.db2.editor.ui.utils.TimeValidator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class ExploreEditDialog
extends InputDialog {
    private ObjectIdentity identity;
    private ColumnModel columnModel;
    private boolean editable;

    public ExploreEditDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
    }

    public ExploreEditDialog(ObjectIdentity identity, ColumnModel columnModel, String initialValue, boolean editable) {
        this(null, columnModel.getName(), columnModel.getSuffix(), initialValue, ExploreEditDialog.getValidator(identity, columnModel));
        this.identity = identity;
        this.columnModel = columnModel;
        this.editable = editable;
        if (this.isMultiLineEditRequired()) {
            this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        }
    }

    private boolean isMultiLineEditRequired() {
        DataType dataType = DataType.value(this.columnModel.getColType().trim());
        if (dataType != null) {
            switch (dataType) {
                case VARCHAR: 
                case CLOB: 
                case GRAPHIC: 
                case VARGRAPHIC: 
                case DBCLOB: 
                case BINARY: 
                case VARBINARY: 
                case BLOB: {
                    return true;
                }
            }
        }
        return false;
    }

    protected int getInputTextStyle() {
        if (this.isMultiLineEditRequired()) {
            return 2882;
        }
        return super.getInputTextStyle();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.modifyGridDataofLabel(composite);
        if (this.isMultiLineEditRequired()) {
            GridData gridData = (GridData)this.getText().getLayoutData();
            gridData.heightHint = this.convertVerticalDLUsToPixels(100);
            gridData.grabExcessVerticalSpace = true;
            gridData.verticalAlignment = 4;
        }
        if (!this.editable) {
            this.getText().setEditable(false);
            this.getText().setBackground(Display.getCurrent().getSystemColor(1));
        }
        return composite;
    }

    private void modifyGridDataofLabel(Composite composite) {
        Label label = (Label)composite.getChildren()[0];
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (!this.editable) {
            this.getButton(0).setEnabled(false);
            this.getButton(1).setFocus();
            this.getText().setSelection(this.getText().getText() != null ? this.getText().getText().length() : 0);
        }
    }

    private static IInputValidator getValidator(ObjectIdentity identity, ColumnModel model) {
        DataType dataType = DataType.value(model.getColType().trim());
        if (DataTypeUtils.isNumericDataType(dataType)) {
            return new NumericValidator(model, dataType);
        }
        if (DataTypeUtils.isCharacterStringDataType(dataType)) {
            return new CharacterStringValidator(model, dataType);
        }
        if (dataType == DataType.DATE) {
            String format = CommonUtils.getDateFormat(identity.getSsid());
            return new DateValidator(model, dataType, format);
        }
        if (dataType == DataType.TIME) {
            String format = CommonUtils.getTimeFormat(identity.getSsid());
            return new TimeValidator(model, dataType, format);
        }
        if (dataType == DataType.TIMESTMP || dataType == DataType.TIMESTZ) {
            return new TimeStampValidator(model, dataType, null);
        }
        return null;
    }
}

