/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.service.DataSourceHandlerFactory;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.model.TableModel;
import com.ca.db2.editor.ui.utils.DWUtils;
import com.ca.db2.editor.ui.utils.Grid;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.ui.widgets.DataWindowContextMenu;
import com.ca.db2.editor.ui.widgets.IDataWindowBuilder;
import com.ca.db2.editor.views.DWView;
import java.util.ArrayList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class DataWindowBuilder
implements IDataWindowBuilder {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private DataWindow dataWindow;
    private ObjectIdentity identity;
    private IDataSourceHandler dataSourceHandler = DataSourceHandlerFactory.getDataSourceHandler();

    public DataWindowBuilder(CTabFolder parent, ObjectIdentity identity) {
        this.dataWindow = new DataWindow((Composite)parent, 0);
        this.dataWindow.setDataSourceHandler(this.dataSourceHandler);
        this.identity = identity;
    }

    @Override
    public void buildMessagePanel(TableModel tableModel) {
        Composite composite = new Composite((Composite)this.dataWindow, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 0, 0));
        GridData gridData = new GridData(4, 4, true, false, 0, 0);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        CLabel label = new CLabel(composite, 64);
        FontData[] fontData = label.getFont().getFontData();
        fontData[0].setHeight(10);
        label.setFont(new Font(null, fontData[0]));
        this.dataWindow.setMessageBar(label);
        label.setLayoutData((Object)gridData);
        Composite btnComposite = new Composite(composite, 0);
        btnComposite.setLayout((Layout)new FillLayout(256));
        Button goToFirstRowBtn = new Button(btnComposite, 8);
        goToFirstRowBtn.setImage(Images.UP.createImage());
        goToFirstRowBtn.setToolTipText("Go To First Row");
        goToFirstRowBtn.setEnabled(!tableModel.getRowModels().isEmpty());
        goToFirstRowBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DataWindowBuilder.this.dataWindow.gotToFirstRow();
                    }
                });
            }
        });
        Button goToLastRowBtn = new Button(btnComposite, 8);
        goToLastRowBtn.setImage(Images.DOWN.createImage());
        goToLastRowBtn.setToolTipText("Go To Last Row");
        goToLastRowBtn.setEnabled(!tableModel.getRowModels().isEmpty());
        goToLastRowBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DataWindowBuilder.this.dataWindow.goToLastRow();
                    }
                });
            }
        });
    }

    @Override
    public void buildFilterBar() {
        final Text filterText = new Text((Composite)this.dataWindow, 2052);
        filterText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        filterText.setText(DWBundle.FILTER_INITIAL_TEXT);
        final Font initialTextFont = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.dialogfont");
        filterText.setFont(initialTextFont);
        filterText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (filterText.getText().isEmpty()) {
                    filterText.setFont(initialTextFont);
                    filterText.setText(DWBundle.FILTER_INITIAL_TEXT);
                }
            }

            public void focusGained(FocusEvent e) {
                if (filterText.getText().equals(DWBundle.FILTER_INITIAL_TEXT)) {
                    filterText.setFont(null);
                    filterText.setText("");
                }
            }
        });
        filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                DataWindowBuilder.this.dataWindow.getResultSetGrid().getFilter().setSearchText(filterText.getText());
                DataWindowBuilder.this.dataWindow.getResultSetGrid().refreshUI();
            }
        });
        this.dataWindow.setFilterText(filterText);
    }

    @Override
    public void buildGrid(TableModel tableModel) {
        Grid grid = new Grid(this.dataWindow, this.identity, tableModel);
        this.dataWindow.setGrid(grid);
        this.createContextMenu(grid);
    }

    @Override
    public void buildStatusBar() {
        Label statusBar = new Label((Composite)this.dataWindow, 0);
        statusBar.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.dataWindow.setStatusBar(statusBar);
    }

    @Override
    public void buildPaginationBar() {
    }

    @Override
    public DataWindow getDataWindow() {
        return this.dataWindow;
    }

    private void createContextMenu(Grid grid) {
        ArrayList<BaseAction> baseActions = new ArrayList<BaseAction>();
        baseActions.add(DWUtils.getView().getAction(DWView.ACTION.REFRESH.toString()));
        baseActions.add(DWUtils.getView().getAction(DWView.ACTION.EDIT_MODE.toString()));
        baseActions.add(DWUtils.getView().getAction(DWView.ACTION.SET_NULL.toString()));
        baseActions.add(DWUtils.getView().getAction(DWView.ACTION.DELETE.toString()));
        baseActions.add(DWUtils.getView().getAction(DWView.ACTION.COLUMN_PROPERTIES.toString()));
        baseActions.add(DWUtils.getView().getAction(DWView.ACTION.ADD_ROWS.toString()));
        baseActions.add(DWUtils.getView().getAction(DWView.ACTION.COPY_ROWS.toString()));
        Menu contextMenu = new DataWindowContextMenu((Composite)grid.getViewer().getTable(), baseActions.toArray(new BaseAction[baseActions.size()])).getMenu();
        grid.getViewer().getTable().setMenu(contextMenu);
    }

    @Override
    public DataWindow buildDataWindow(TableModel tableModel) {
        this.buildMessagePanel(tableModel);
        this.buildFilterBar();
        this.buildGrid(tableModel);
        return this.getDataWindow();
    }
}

