/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class Context
implements Serializable {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final long serialVersionUID = 1871507028578896615L;
    private static final Map<Object, Object> SESSION_CACHE = new WeakHashMap<Object, Object>();
    private static Context context = new Context();
    private static final Map<String, Map<String, Object>> DECP_PROPS_CACHE = new HashMap<String, Map<String, Object>>();
    private final Map<Object, String> SQLID_REGISTRY = new HashMap<Object, String>();
    private String lpar;
    private String SSID;
    private String system;
    private String userId;
    private String password;
    private static final String DEFAULT_SQLID = "DEFAULT";
    public static final String DSE = "DSE";
    public static final String ACTIVE_SQLID = "ACTIVE_UPDATED";
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    private Context() {
    }

    public static Context getInstance() {
        return context;
    }

    public String getSQLID(Object key) {
        String sqlId = this.SQLID_REGISTRY.get(key);
        return sqlId == null ? this.getDefaultSQLID() : sqlId;
    }

    public String getDefaultSQLID() {
        return this.SQLID_REGISTRY.get(DEFAULT_SQLID);
    }

    public void setSQLID(Object key, String SQLID) {
        this.SQLID_REGISTRY.put(key, SQLID);
    }

    public void setDefaultSQLID(String SQLID) {
        this.SQLID_REGISTRY.put(DEFAULT_SQLID, SQLID);
    }

    public void setActiveSQLID(String SQLID) {
        this.SQLID_REGISTRY.put(ACTIVE_SQLID, SQLID);
    }

    public String getActiveSQLID() {
        return this.getSQLID(ACTIVE_SQLID);
    }

    public void setLpar(String lpar) {
        this.lpar = lpar;
    }

    public String getLpar() {
        return this.lpar;
    }

    public String getSSID() {
        return this.SSID;
    }

    public void setSSID(String SSID) {
        this.SSID = SSID;
    }

    public String getSystem() {
        return this.system;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "ssid : " + this.SSID + " system : " + this.system + " userId : " + this.userId + " password : " + this.password;
    }

    public static Map<String, Map<String, Object>> getDECPPropertiesCache() {
        return DECP_PROPS_CACHE;
    }

    public static void put(Keys key, Object value) {
        SESSION_CACHE.put((Object)key, value);
    }

    public static Object get(Keys key) {
        return SESSION_CACHE.get((Object)key);
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public void clear() {
        SESSION_CACHE.clear();
        DECP_PROPS_CACHE.clear();
        this.SQLID_REGISTRY.clear();
    }

    public static enum Keys {
        SQLID,
        PAGINATION_COUNT,
        DSE_PER_GRP_FETCH_LIMIT,
        SELECTED_SUBSYSTEMS,
        ACTIVE_SUBSYSTEMS,
        XNET_AGENT,
        OFA_AGENT,
        CASE_INSENSITIVE;

    }
}

