/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.views;

import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.actions.DWAddRowsAction;
import com.ca.db2.editor.ui.actions.DWColumnPropertiesAction;
import com.ca.db2.editor.ui.actions.DWCommitAction;
import com.ca.db2.editor.ui.actions.DWCopyRowsAction;
import com.ca.db2.editor.ui.actions.DWDeleteRowAction;
import com.ca.db2.editor.ui.actions.DWEditAction;
import com.ca.db2.editor.ui.actions.DWFindAction;
import com.ca.db2.editor.ui.actions.DWModifyFilterAction;
import com.ca.db2.editor.ui.actions.DWRefreshAction;
import com.ca.db2.editor.ui.actions.DWRollbackAction;
import com.ca.db2.editor.ui.actions.DWSetNullAction;
import com.ca.db2.editor.ui.model.ChangeEntrySet;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.ui.widgets.DataWindowManager;
import com.ca.db2.editor.views.comm.ViewCommUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class DWView
extends ViewPart {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    public static final String ID = "com.ca.db2.editor.views.DWView";
    private static final Logger logger = Logger.getLogger(DWView.class);
    private List<BaseAction> actions = new ArrayList<BaseAction>(10);
    private EventHandler eventHandler = null;
    private String cmTopic = "changemanager/ui";
    private BaseAction editAction;
    private BaseAction commitAction;
    private BaseAction rollbackAction;
    private BaseAction refreshAction;
    private BaseAction deleteRowAction;
    private BaseAction columnPropertiesAction;
    private BaseAction addRowsAction;
    private BaseAction copyRowsAction;
    private BaseAction setNullAction;
    private BaseAction findAction;
    private BaseAction modifyFilterAction;
    private DataWindowManager manager;

    public void createPartControl(Composite parent) {
        this.manager = new DataWindowManager(parent, this);
        this.createActions();
        this.addToolbarActions();
        this.disableAllActions();
        this.attachEvents(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.manager.getTabFolder(), "com.ca.db2.editor.datawindow");
        logger.debug((Object)"Data Window View created");
    }

    public void setFocus() {
        if (this.manager.getTabFolder() != null) {
            this.manager.getTabFolder().setFocus();
        }
    }

    public DataWindowManager getManager() {
        return this.manager;
    }

    private void addToolbarActions() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.editAction);
        mgr.add((IAction)this.addRowsAction);
        mgr.add((IAction)this.commitAction);
        mgr.add((IAction)this.rollbackAction);
        mgr.add((IAction)this.refreshAction);
        mgr.add((IAction)this.modifyFilterAction);
    }

    private void addMenuBarActions() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
    }

    public BaseAction getAction(String id) {
        for (BaseAction action : this.actions) {
            if (!action.getId().equals(id)) continue;
            return action;
        }
        return null;
    }

    public void disableAllActions() {
        for (BaseAction action : this.actions) {
            action.setEnabled(false);
            action.setChecked(true);
        }
    }

    public void triggerUpdateforActions() {
        for (BaseAction action : this.actions) {
            action.updateUI();
        }
    }

    private void attachEvents(final Composite parent) {
        this.eventHandler = new EventHandler(){
            boolean isRollbackDone = false;

            public void handleEvent(final Event event) {
                try {
                    if (parent.isDisposed()) {
                        logger.debug((Object)"Widget Disposed during View communication");
                        return;
                    }
                    if (parent.getDisplay().getThread() == Thread.currentThread()) {
                        Map eventEntries = (Map)event.getProperty(DWView.this.cmTopic);
                        this.isRollbackDone = DWView.this.rollbackChanges(eventEntries);
                    } else {
                        parent.getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Map eventEntries = (Map)event.getProperty(DWView.this.cmTopic);
                                isRollbackDone = DWView.this.rollbackChanges(eventEntries);
                            }
                        });
                    }
                    if (!this.isRollbackDone) {
                        logger.error((Object)"Rollback Failed");
                    } else {
                        DWView.this.triggerUpdateforActions();
                        logger.info((Object)"Rollback Successful");
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Rollback Failed", (Throwable)e);
                }
            }
        };
        ViewCommUtil viewCommUtil = new ViewCommUtil();
        Hashtable<String, String> eventProps = new Hashtable<String, String>();
        viewCommUtil.registerSubscriberService(((Object)((Object)this)).getClass(), this.eventHandler, this.cmTopic, eventProps);
    }

    private boolean rollbackChanges(Map<ObjectIdentity, List<ChangeEntrySet>> eventEntries) {
        ObjectIdentity identity = eventEntries.entrySet().iterator().next().getKey();
        DataWindow dataWindow = this.manager.getDataWindow(identity);
        return dataWindow.rollbackChanges(eventEntries);
    }

    public void onLogout() {
        this.disableAllActions();
    }

    public boolean canLogout() {
        boolean canLogout = this.manager.canUserLogout();
        if (canLogout) {
            this.onLogout();
        }
        return canLogout;
    }

    private void createActions() {
        this.editAction = new DWEditAction(this.manager);
        this.actions.add(this.editAction);
        this.commitAction = new DWCommitAction(this.manager);
        this.actions.add(this.commitAction);
        this.rollbackAction = new DWRollbackAction(this.manager);
        this.actions.add(this.rollbackAction);
        this.refreshAction = new DWRefreshAction(this.manager);
        this.actions.add(this.refreshAction);
        this.modifyFilterAction = new DWModifyFilterAction(this.manager);
        this.actions.add(this.modifyFilterAction);
        this.deleteRowAction = new DWDeleteRowAction(this.manager);
        this.actions.add(this.deleteRowAction);
        this.columnPropertiesAction = new DWColumnPropertiesAction(this.manager);
        this.actions.add(this.columnPropertiesAction);
        this.addRowsAction = new DWAddRowsAction(this.manager);
        this.actions.add(this.addRowsAction);
        this.copyRowsAction = new DWCopyRowsAction(this.manager);
        this.actions.add(this.copyRowsAction);
        this.setNullAction = new DWSetNullAction(this.manager);
        this.actions.add(this.setNullAction);
        this.findAction = new DWFindAction(this.manager);
        this.actions.add(this.findAction);
    }

    public static enum ACTION {
        EDIT_MODE,
        COMMIT,
        ROLLBACK,
        CREATE_LAYOUT,
        REFRESH,
        DELETE,
        SET_NULL,
        COLUMN_PROPERTIES,
        ADD_ROWS,
        COPY_ROWS,
        FIND,
        MODIFY_FILTER;

    }
}

