/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.service.DSEUtils;
import com.ca.db2.editor.ui.i18n.DSEBundle;
import com.ca.db2.editor.ui.model.GroupNode;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.utils.DBObjectType;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DSELoadObjectsDialog
extends TitleAreaDialog {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private Text nameTxtField;
    private Text creatorTxtfield;
    private List objectTypes;
    private ITreeNode selectedNode;
    private static final String LIKE = "LIKE";
    private String searchCondition;
    private ArrayList<DBObjectType> selectedObjectTypes;
    private String creator;

    public DSELoadObjectsDialog(Shell parentShell, ITreeNode selectedNode) {
        super(parentShell);
        this.setHelpAvailable(false);
        DSELoadObjectsDialog.setDialogHelpAvailable((boolean)false);
        this.selectedNode = selectedNode;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DSEBundle.LOADOBJECTS_DIALOG_SHELL_TITLE);
    }

    public void create() {
        super.create();
        this.setTitle(DSEBundle.LOADOBJECTS_DIALOG_TITLE);
        this.setMessage(DSEBundle.LOADOBJECTS_DIALOG_MSG, 1);
        this.setSearchCondition(null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite comp = new Composite(container, 0);
        comp.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        comp.setLayout((Layout)layout);
        Label nameLabelField = new Label(comp, 1);
        nameLabelField.setText(DSEBundle.LOADOBJECTS_DIALOG_NAME);
        this.nameTxtField = new Text(comp, 2048);
        this.nameTxtField.setLayoutData((Object)this.createGridData());
        Label creatorLabelField = new Label(comp, 0);
        creatorLabelField.setText(DSEBundle.LOADOBJECTS_DIALOG_CREATOR);
        this.creatorTxtfield = new Text(comp, 2048);
        this.creatorTxtfield.setLayoutData((Object)this.createGridData());
        if (DSEUtils.isCreator(this.selectedNode)) {
            this.creatorTxtfield.setText(this.selectedNode.getName());
        }
        Label objectTypesLabel = new Label(comp, 0);
        objectTypesLabel.setText(DSEBundle.LOADOBJECT_DIAGLOG_OBJECT_TYPES);
        this.objectTypes = new List(comp, 2050);
        this.objectTypes.setItems(this.getSupportedObjectTypes());
        this.objectTypes.selectAll();
        this.objectTypes.setLayoutData((Object)this.createGridData());
        if (DSEUtils.isGroup(this.selectedNode)) {
            this.creatorTxtfield.setText(this.selectedNode.getParent().getName());
            this.objectTypes.setSelection(this.indexOf(((GroupNode)this.selectedNode).getType()));
        }
        this.nameTxtField.setFocus();
        comp.pack();
        container.pack();
        return comp;
    }

    protected boolean isResizable() {
        return false;
    }

    private void generateSearchCondition() {
        StringBuilder builder = new StringBuilder();
        String name = this.nameTxtField.getText();
        String creator = this.creatorTxtfield.getText();
        if (!name.isEmpty()) {
            builder.append(" NAME ");
            if (this.isWildCardSearch(name)) {
                name = name.replace('*', '%');
                builder.append(this.like(name));
            } else {
                builder.append(this.is(name));
            }
        }
        if (!creator.isEmpty()) {
            builder.append(name.isEmpty() ? "" : " AND ");
            if (this.isWildCardSearch(creator)) {
                builder.append("(CREATOR ").append(this.like(creator.toUpperCase()));
                builder.append(" OR CREATOR ").append(this.like(creator.toLowerCase())).append(")");
            } else {
                builder.append("CREATOR IN ('").append(creator.toUpperCase());
                builder.append("','").append(creator.toLowerCase()).append("')");
            }
        }
        this.setSearchCondition(builder.toString());
        this.setSelectedObjectTypes();
    }

    private boolean isWildCardSearch(String inputText) {
        return inputText.indexOf("%") != -1 || inputText.indexOf("_") != -1 || inputText.indexOf("*") != -1;
    }

    private String like(String s) {
        return "LIKE '" + s + "'";
    }

    private String is(String s) {
        return "= '" + s + "'";
    }

    protected void okPressed() {
        if (this.nameTxtField.getText().trim().isEmpty() && this.creatorTxtfield.getText().trim().isEmpty()) {
            this.setErrorMessage(DSEBundle.LOADOBJECTS_DIALOG_ERRORMSG);
            this.nameTxtField.setFocus();
        } else if (this.objectTypes.getSelectionCount() < 1) {
            this.setErrorMessage(DSEBundle.LOADOBJECTS_DIALOG_OBJTYPES_ERRORMSG);
        } else {
            this.creator = this.creatorTxtfield.getText().trim();
            this.generateSearchCondition();
            super.okPressed();
        }
    }

    private GridData createGridData() {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        return gridData;
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected Point getInitialSize() {
        return new Point(350, 300);
    }

    public void setSearchCondition(String searchCondition) {
        this.searchCondition = searchCondition;
    }

    public String getSearchCondition() {
        return this.searchCondition;
    }

    public String[] getSupportedObjectTypes() {
        return new String[]{DSEBundle.LABEL_TABLE, DSEBundle.LABEL_VIEW, DSEBundle.LABEL_ALIAS};
    }

    public ArrayList<DBObjectType> getSelectedObjectTypes() {
        return this.selectedObjectTypes;
    }

    public void setSelectedObjectTypes() {
        int[] selectedIndices = this.objectTypes.getSelectionIndices();
        this.selectedObjectTypes = new ArrayList();
        int[] nArray = selectedIndices;
        int n = selectedIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            switch (i) {
                case 0: {
                    this.selectedObjectTypes.add(DBObjectType.TABLE);
                    break;
                }
                case 1: {
                    this.selectedObjectTypes.add(DBObjectType.VIEW);
                    break;
                }
                case 2: {
                    this.selectedObjectTypes.add(DBObjectType.ALIAS);
                    break;
                }
                case 3: {
                    this.selectedObjectTypes.add(DBObjectType.SYNONYM);
                }
            }
            ++n2;
        }
    }

    private int indexOf(DBObjectType type) {
        switch (type) {
            case TABLE: {
                return 0;
            }
            case VIEW: {
                return 1;
            }
            case ALIAS: {
                return 2;
            }
            case SYNONYM: {
                return 3;
            }
        }
        return 0;
    }

    public String getCreator() {
        return this.creator;
    }
}

