/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.widgets;

import com.ca.db2.editor.service.DataSourceHandlerFactory;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.actions.CMCollapseAllAction;
import com.ca.db2.editor.ui.actions.CMCommitAction;
import com.ca.db2.editor.ui.actions.CMRollbackAction;
import com.ca.db2.editor.ui.i18n.CMBundle;
import com.ca.db2.editor.ui.model.CMInput;
import com.ca.db2.editor.ui.model.ChangeEntry;
import com.ca.db2.editor.ui.model.ChangeEntrySet;
import com.ca.db2.editor.ui.model.ChangeSet;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.model.RowModel;
import com.ca.db2.editor.ui.utils.CMColumnsHandler;
import com.ca.db2.editor.ui.utils.CMContentProvider;
import com.ca.db2.editor.ui.utils.CMUtils;
import com.ca.db2.editor.ui.utils.DWUtils;
import com.ca.db2.editor.ui.utils.SQLGenerator;
import com.ca.db2.editor.ui.widgets.CMContextMenu;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import com.ca.db2.editor.views.CMView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ChangeManager {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(ChangeManager.class);
    private CMView view;
    private TreeViewer viewer;
    private CMContextMenu contextMenu;
    private IDataSourceHandler dataSourceHandler = DataSourceHandlerFactory.getDataSourceHandler();
    private CMInput root;
    private Tree tree = null;
    private BaseAction cmCommitAction;
    private BaseAction cmRollbackAction;

    public ChangeManager(CMView view) {
        this.view = view;
        this.tree = this.createTree(view.getParent());
        this.createColumns();
        this.createContextMenu();
        this.initializeToolbar();
        this.attachListeners();
    }

    protected Tree createTree(Composite parent) {
        Tree tree = new Tree(parent, 68354);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new CMContentProvider());
        this.root = new CMInput();
        this.viewer.setInput((Object)this.root);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer);
        return tree;
    }

    public IWorkbenchSiteProgressService getProgressService() {
        IWorkbenchSiteProgressService service = null;
        Object siteService = this.view.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            service = (IWorkbenchSiteProgressService)siteService;
        }
        return service;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void addEntry(ObjectIdentity identity, RowModel rowModel, ChangeEntry entry) {
        ChangeEntrySet entrySet = null;
        entry.setIdentity(identity);
        ChangeSet set = CMUtils.getChangeSet(identity, this.getData());
        if (set == null) {
            set = new ChangeSet(identity);
            entrySet = new ChangeEntrySet(identity, rowModel);
            entrySet.getEntries().add(entry);
            set.getChangeEntrySets().add(entrySet);
            this.getData().add(set);
        } else {
            entrySet = CMUtils.getChangeEntrySet(rowModel.getRowKey(), set.getChangeEntrySets());
            if (entrySet == null) {
                entrySet = new ChangeEntrySet(identity, rowModel);
                entrySet.getEntries().add(entry);
                set.getChangeEntrySets().add(entrySet);
            } else {
                ChangeEntry o = CMUtils.getChangeEntry(entrySet, entry);
                if (o == null) {
                    entrySet.getEntries().add(entry);
                } else {
                    o.setModifiedValue(entry.getModifiedValue());
                }
            }
        }
        this.refresh();
        this.viewer.expandToLevel((Object)set, 1);
        this.viewer.expandToLevel((Object)entrySet, 1);
    }

    public void addEntrySet(ObjectIdentity identity, ChangeEntrySet entrySet) {
        ChangeSet set = CMUtils.getChangeSet(identity, this.getData());
        if (set == null) {
            set = new ChangeSet(identity);
            this.getData().add(set);
        }
        set.getChangeEntrySets().add(entrySet);
        this.refresh();
    }

    public CMView getParent() {
        return this.view;
    }

    private void createColumns() {
        new CMColumnsHandler(this).createColumns();
    }

    private void createContextMenu() {
        this.contextMenu = new CMContextMenu(this);
        this.getViewer().getControl().setMenu(this.contextMenu.createContextMenu(this.getViewer().getControl()));
    }

    public List<ChangeSet> getData() {
        return ((CMInput)this.viewer.getInput()).getChangeSets();
    }

    public Object[] getSelectedItems() {
        return ((TreeSelection)this.viewer.getSelection()).toArray();
    }

    public Map<ObjectIdentity, Map<Integer, List<ChangeEntry>>> getSelectedItemsMap() {
        return null;
    }

    public void refresh() {
        this.viewer.refresh();
    }

    private void attachListeners() {
        this.viewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChangeManager.this.cmCommitAction.updateUI();
                ChangeManager.this.cmRollbackAction.updateUI();
            }
        });
        this.viewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TreeSelection selection = (TreeSelection)ChangeManager.this.viewer.getSelection();
                ChangeManager.this.linkWithDataWindow(selection.getFirstElement());
            }
        });
        this.viewer.getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    TreeSelection selection = (TreeSelection)ChangeManager.this.viewer.getSelection();
                    ChangeManager.this.linkWithDataWindow(selection.getFirstElement());
                }
            }
        });
    }

    private void linkWithDataWindow(Object o) {
        if (o instanceof ChangeEntrySet) {
            ObjectIdentity identity = ((ChangeEntrySet)o).getIdentity();
            DWUtils.highlightRow(identity, ((ChangeEntrySet)o).getRowKey());
        }
    }

    public boolean removeAllEntries() {
        try {
            this.getData().clear();
            this.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean removeEntries(ObjectIdentity identity) {
        try {
            ChangeSet set = CMUtils.getChangeSet(identity, this.getData());
            this.getData().remove(set);
            this.refresh();
            logger.info((Object)("Rollback successful for:" + identity));
        }
        catch (Exception e) {
            logger.error((Object)"Rollback failed:", (Throwable)e);
            return false;
        }
        return true;
    }

    public void removeEntries(ObjectIdentity identity, Integer[] rowKeys) {
        ChangeSet set = CMUtils.getChangeSetByIdentity(identity, this.getData());
        if (set != null) {
            Iterator<ChangeEntrySet> iterator = set.getChangeEntrySets().iterator();
            block0: while (iterator.hasNext()) {
                Integer rowKey = iterator.next().getRowKey();
                int index = 0;
                while (index < rowKeys.length) {
                    if (rowKeys[index].equals(rowKey)) {
                        iterator.remove();
                        continue block0;
                    }
                    ++index;
                }
            }
            if (set.getChangeEntrySets().isEmpty()) {
                this.getData().remove(set);
            }
            this.refresh();
        }
    }

    public void removeEntries(ObjectIdentity identity, List<ChangeEntrySet> changeEntrySets) {
        Integer[] rowKeys = new Integer[changeEntrySets.size()];
        int index = 0;
        while (index < changeEntrySets.size()) {
            rowKeys[index] = changeEntrySets.get(index).getRowKey();
            ++index;
        }
        this.removeEntries(identity, rowKeys);
    }

    public void removeEntries(Map<ObjectIdentity, List<ChangeEntrySet>> identityChangeEntrySets) {
        for (Map.Entry<ObjectIdentity, List<ChangeEntrySet>> entry : identityChangeEntrySets.entrySet()) {
            this.removeEntries(entry.getKey(), entry.getValue());
        }
    }

    private void postCommit(ObjectIdentity identity, int rowIndex, boolean commitfailed) {
        ChangeSet set = CMUtils.getChangeSetByIdentity(identity, this.getData());
        Iterator<ChangeEntrySet> iterator = set.getChangeEntrySets().iterator();
        while (iterator.hasNext()) {
            ChangeEntrySet entrySet = iterator.next();
            if (entrySet.getRowKey() != rowIndex) continue;
            if (commitfailed) {
                entrySet.setStatus(ChangeEntrySet.Status.FAILED);
                break;
            }
            iterator.remove();
            break;
        }
        if (set.getChangeEntrySets().isEmpty()) {
            this.getData().remove(set);
        }
        this.refresh();
    }

    public boolean commitChanges(ObjectIdentity identity) {
        return this.commitChanges(identity, CMUtils.generateSQLs(identity));
    }

    public boolean commitChanges(List<ChangeEntrySet> entrySets) {
        ObjectIdentity identity = entrySets.get(0).getIdentity();
        return this.commitChanges(identity, CMUtils.generateSQLs(identity, entrySets));
    }

    private boolean commitChanges(ObjectIdentity identity, Map<Integer, String> map) {
        boolean isCommitted = true;
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            try {
                if (SQLGenerator.isInsertQuery(entry.getValue())) {
                    Map<String, Integer> generatedKeys = this.dataSourceHandler.insert(identity, entry.getValue());
                    if (DWUtils.hasAutoGeneratedIdentityColumn(identity)) {
                        this.postInsert(identity, entry.getKey(), generatedKeys);
                    }
                } else {
                    this.dataSourceHandler.update(identity, entry.getValue());
                }
                this.postCommit(identity, entry.getKey(), false);
                logger.info((Object)("Commit successful for : " + identity));
            }
            catch (Exception e) {
                isCommitted = false;
                this.postCommit(identity, entry.getKey(), true);
                MsgDialog.showErrorDialogWithDetails(String.valueOf(CMBundle.COMMIT_FAILED_TITLE) + entry.getValue(), CMBundle.COMMIT_FAILED_MSG, e);
            }
        }
        this.refresh();
        return isCommitted;
    }

    private void postInsert(ObjectIdentity identity, int rowKey, Map<String, Integer> generatedKeys) {
        DWUtils.updateCellValue(identity, rowKey, generatedKeys);
    }

    private void initializeToolbar() {
        IToolBarManager toolbarManager = this.view.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)new CMCollapseAllAction(this));
        this.cmCommitAction = new CMCommitAction(this);
        toolbarManager.add((IAction)this.cmCommitAction);
        this.cmRollbackAction = new CMRollbackAction(this);
        toolbarManager.add((IAction)this.cmRollbackAction);
        this.cmCommitAction.setEnabled(false);
        this.cmRollbackAction.setEnabled(false);
    }

    public void collapseAll() {
        this.viewer.collapseAll();
    }

    public Map<ObjectIdentity, List<ChangeEntrySet>> getSelectedChangeEntrySets() {
        Object[] items = this.getSelectedItems();
        if (items != null) {
            LinkedHashMap<ObjectIdentity, List<ChangeEntrySet>> map = new LinkedHashMap<ObjectIdentity, List<ChangeEntrySet>>();
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (o instanceof ChangeEntrySet) {
                    ChangeEntrySet e = (ChangeEntrySet)o;
                    ArrayList<ChangeEntrySet> entrySets = (ArrayList<ChangeEntrySet>)map.get(e.getIdentity());
                    if (entrySets == null) {
                        entrySets = new ArrayList<ChangeEntrySet>();
                        map.put(e.getIdentity(), entrySets);
                    }
                    entrySets.add(e);
                }
                ++n2;
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public boolean enableContextMenuActions() {
        boolean enable = true;
        if (this.getData().isEmpty()) {
            return !enable;
        }
        Object[] items = this.getSelectedItems();
        if (items.length == 0) {
            return !enable;
        }
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            boolean bl = enable = enable && o instanceof ChangeEntrySet;
            if (!enable) {
                return enable;
            }
            ++n2;
        }
        return enable;
    }

    public void releaseResources() {
        try {
            this.root = null;
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred while releasing resource in ChangeManager");
        }
    }

    public void dispose() {
        try {
            this.contextMenu.dispose();
            this.tree.dispose();
        }
        catch (Exception e) {
            logger.error((Object)"Exception occurred while disposing in ChangeManager");
        }
    }
}

