/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.RowModel;
import com.ca.db2.editor.ui.utils.AbstractCellEditor;
import com.ca.db2.editor.ui.utils.CellEditorFactory;
import com.ca.db2.editor.ui.utils.Grid;
import com.ca.db2.editor.ui.widgets.ExploreEditDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ColumnEditingSupport
extends EditingSupport {
    private TableViewer viewer;
    private int columnIndex = -1;
    private ColumnModel columnModel;
    private AbstractCellEditor cellEditor;
    private Grid resultSetGrid;

    public ColumnEditingSupport(Grid resultSetGrid, ColumnModel columnModel, int columnIndex) {
        super((ColumnViewer)resultSetGrid.getViewer());
        this.viewer = resultSetGrid.getViewer();
        this.columnModel = columnModel;
        this.columnIndex = columnIndex;
        this.resultSetGrid = resultSetGrid;
        this.cellEditor = CellEditorFactory.getCellEditor((Composite)this.viewer.getTable(), resultSetGrid.getIdentity(), columnModel);
        this.cellEditor.getControl().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ColumnEditingSupport.this.showExplodeEdit((String)ColumnEditingSupport.this.cellEditor.getValue(), ColumnEditingSupport.this.isColumnEditable());
            }
        });
        this.cellEditor.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean isCtrlEnter;
                super.keyPressed(e);
                boolean bl = isCtrlEnter = e.stateMask == 262144 && e.keyCode == 13;
                if (isCtrlEnter) {
                    ColumnEditingSupport.this.showExplodeEdit((String)ColumnEditingSupport.this.cellEditor.getValue(), ColumnEditingSupport.this.isColumnEditable());
                }
            }
        });
    }

    protected CellEditor getCellEditor(Object element) {
        return this.cellEditor;
    }

    protected boolean canEdit(Object element) {
        return this.resultSetGrid.isEditable() && !((RowModel)element).isAddableRow() && this.isColumnEditable();
    }

    private boolean isColumnEditable() {
        if (!this.columnModel.isUpdatable()) {
            return false;
        }
        String _default = this.columnModel.getDefault().trim();
        return !_default.equals("A") && !_default.equals("E") && !_default.equals("I");
    }

    protected Object getValue(Object element) {
        return ((RowModel)element).getData()[this.columnIndex];
    }

    protected void setValue(Object element, Object value) {
        if (this.cellEditor.isDirty()) {
            if (this.cellEditor.isValueValid()) {
                this.updateViewer(element, value);
            } else {
                this.showExplodeEdit(((Text)this.cellEditor.getControl()).getText(), this.isColumnEditable());
                this.resultSetGrid.getViewer().getTable().setFocus();
            }
        }
    }

    private void showExplodeEdit(String initialValue, boolean editable) {
        ExploreEditDialog dialog = new ExploreEditDialog(this.resultSetGrid.getIdentity(), this.columnModel, initialValue, editable);
        if (dialog.open() == 0 && !dialog.getValue().equals(initialValue)) {
            Object element = ((StructuredSelection)this.getViewer().getSelection()).getFirstElement();
            this.updateViewer(element, dialog.getValue());
        }
        this.cellEditor.postExplodeEdit();
        this.resultSetGrid.getViewer().getTable().setFocus();
    }

    private void updateViewer(Object element, Object newValue) {
        if (this.cellEditor instanceof AbstractCellEditor) {
            newValue = this.cellEditor.formatValue(newValue);
        }
        if (this.isValueModified(((RowModel)element).getData()[this.columnIndex], newValue)) {
            this.resultSetGrid.updateCellValue((RowModel)element, this.columnModel, this.columnIndex, newValue);
        }
    }

    private boolean isValueModified(Object o1, Object o2) {
        if (o1 != null) {
            return !o1.toString().equals(o2);
        }
        return o2 != null;
    }

    public Grid getResultSetGrid() {
        return this.resultSetGrid;
    }
}

