/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.model;

import com.ca.db2.editor.ui.i18n.DSEBundle;
import com.ca.db2.editor.ui.model.BaseModel;
import com.ca.db2.editor.ui.model.CreatorNode;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.model.LparNode;
import com.ca.db2.editor.ui.utils.DBObjectType;
import com.ca.db2.editor.ui.utils.Images;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class SubsystemNode
extends BaseModel
implements ITreeNode,
Comparable<SubsystemNode> {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final long serialVersionUID = 1781167234749201184L;
    private final Image SUBSYSTEM = Images.SUBSYSTEM.createImage();
    private final List<CreatorNode> creatorNodes = new ArrayList<CreatorNode>(50);
    private LparNode lpar;

    private SubsystemNode() {
    }

    public SubsystemNode(String name, LparNode lpar) {
        this();
        this.lpar = lpar;
        this.setName(name);
        this.setTooltip(DSEBundle.bind((String)DSEBundle.TOOLTIP_SSID, (Object)this.getName()));
    }

    @Override
    public int compareTo(SubsystemNode o) {
        return this.getName().compareTo(o.getName());
    }

    @Override
    public boolean hasChildren() {
        return !this.creatorNodes.isEmpty();
    }

    @Override
    public Image getImage() {
        return this.SUBSYSTEM;
    }

    @Override
    public DBObjectType getObjectType() {
        return DBObjectType.SUBSYSTEM;
    }

    @Override
    public int getSortingCategory() {
        return 0;
    }

    @Override
    public boolean isLeafNode() {
        return false;
    }

    public LparNode getLpar() {
        return this.lpar;
    }

    public void setLpar(LparNode lpar) {
        this.lpar = lpar;
    }

    public String toString() {
        return "SUBSYSTEM : " + this.getName();
    }

    @Override
    public boolean removeChild(ITreeNode node) {
        return this.creatorNodes.remove(node);
    }

    @Override
    public ITreeNode getParent() {
        return this.lpar;
    }

    @Override
    public void removeChildren() {
        this.creatorNodes.clear();
    }

    public List<CreatorNode> getChildren() {
        Iterator<CreatorNode> iterator = this.creatorNodes.iterator();
        while (iterator.hasNext()) {
            CreatorNode node = iterator.next();
            if (node.hasChildren()) continue;
            iterator.remove();
        }
        return this.creatorNodes;
    }

    @Override
    public void addChildren(List<? extends ITreeNode> nodes) {
        for (ITreeNode iTreeNode : nodes) {
            this.addChild(iTreeNode);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return result *= 31;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public <U extends ITreeNode> void addChild(U node) {
        this.creatorNodes.add((CreatorNode)node);
    }

    @Override
    public String getPath() {
        return String.valueOf(this.getParent().getPath()) + "." + this.getName();
    }
}

