/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.i18n.MsgDialogBundle;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.DataWindowManager;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import com.ca.db2.editor.views.DWView;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.BusyIndicator;

public class DWRefreshAction
extends BaseAction {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(DWRefreshAction.class);
    private String commandId = "com.ca.db2.editor.ui.actions.DWRefreshAction";
    DataWindowManager dwManager;

    public DWRefreshAction(DataWindowManager manager) {
        super(DWBundle.LABEL_REFRESH, 1);
        this.setId(DWView.ACTION.REFRESH.toString());
        this.setToolTipText(DWBundle.LABEL_REFRESH);
        this.setImageDescriptor(Images.DW_REFRESH);
        this.dwManager = manager;
        this.registerKeyBinding(this.commandId, 65608);
    }

    @Override
    public void execute() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    DWRefreshAction.this.dwManager.refreshDataWindow();
                }
                catch (FMDB2Exception e) {
                    MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
                }
            }
        });
    }

    @Override
    public void updateUI() {
        this.setEnabled(true);
        this.setChecked(false);
    }

    @Override
    protected boolean checkPreConditions() {
        return this.dwManager.getSelectedDataWindow().canBeClosedOrRefreshed();
    }
}

