/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.i18n.MsgDialogBundle;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.widgets.DataWindow;
import com.ca.db2.editor.ui.widgets.DataWindowManager;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import com.ca.db2.editor.views.DWView;
import com.ca.db2.editor.views.PropertiesView;
import org.apache.log4j.Logger;

public class DWColumnPropertiesAction
extends BaseAction {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static final Logger logger = Logger.getLogger(DWColumnPropertiesAction.class);
    private DataWindowManager manager;

    public DWColumnPropertiesAction(DataWindowManager manager) {
        super(DWBundle.COLUMN_PROPERTIES, 1);
        this.manager = manager;
        this.setId(DWView.ACTION.COLUMN_PROPERTIES.toString());
    }

    @Override
    public void execute() {
        try {
            ObjectIdentity identity = this.getDataWindow().getIdentity();
            String columnName = this.getDataWindow().getResultSetGrid().getRightMouseClickedColumn();
            columnName = CommonUtils.removeNulls(columnName);
            PropertiesView view = (PropertiesView)CommonUtils.getView(PropertiesView.ID);
            view.showPropertiesTab(identity, columnName);
            logger.info((Object)("Column properties view opened for column:" + columnName));
        }
        catch (FMDB2Exception e) {
            CommonUtils.hideView(PropertiesView.ID);
            MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
        }
        catch (Exception e) {
            logger.error((Object)"Problem while viewing Column properties", (Throwable)e);
        }
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.getDataWindow().getResultSetGrid().getRightMouseClickedColumn() != null);
    }

    private DataWindow getDataWindow() {
        return this.manager.getSelectedDataWindow();
    }
}

