/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DSEBundle;
import com.ca.db2.editor.ui.i18n.MsgDialogBundle;
import com.ca.db2.editor.ui.model.DBObject;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.DSEContextMenu;
import com.ca.db2.editor.ui.widgets.DataSourceExplorer;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import com.ca.db2.editor.views.PropertiesView;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.BusyIndicator;

class DSEPropertiesAction
extends BaseAction {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private static Logger logger = Logger.getLogger(DSEPropertiesAction.class);
    private DataSourceExplorer explorer;
    private String commandId = "com.ca.db2.editor.ui.actions.DSEPropertiesAction";

    public DSEPropertiesAction(DataSourceExplorer explorer) {
        super(DSEBundle.PROPERTIES);
        this.setId(DSEContextMenu.ACTION.PROPERTIES.toString());
        this.setImageDescriptor(Images.PROPERTIES);
        this.explorer = explorer;
        this.registerKeyBinding(this.commandId, 65607);
    }

    @Override
    public void execute() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PropertiesView view = (PropertiesView)CommonUtils.getView(PropertiesView.ID);
                    view.showPropertiesTab((DBObject)((Object)DSEPropertiesAction.this.explorer.getSelectedObject()));
                    logger.info((Object)("Properties displayed for " + DSEPropertiesAction.this.explorer.getSelectedObject()));
                }
                catch (FMDB2Exception e) {
                    CommonUtils.hideView(PropertiesView.ID);
                    MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
                }
            }
        });
    }

    @Override
    public void updateUI() {
        this.setEnabled(this.checkPreConditions());
    }

    @Override
    public boolean checkPreConditions() {
        boolean isEmpty = this.explorer.getRoot().getLparNodes().isEmpty();
        return !isEmpty && this.explorer.getSelectedObject().isLeafNode();
    }
}

