/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DSEBundle;
import com.ca.db2.editor.ui.model.DBObject;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.DWUtils;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.DSEContextMenu;
import com.ca.db2.editor.ui.widgets.DataSourceExplorer;
import org.eclipse.swt.custom.BusyIndicator;

class DSEFilterBrowseAction
extends BaseAction {
    static final String cacopyright = "Copyright \ufffd 2016 CA";
    private DataSourceExplorer explorer;

    public DSEFilterBrowseAction(DataSourceExplorer explorer) {
        super(DSEBundle.FILTER_BROWSE);
        this.setImageDescriptor(Images.BROWSE);
        this.setId(DSEContextMenu.ACTION.FILTER_BROWSE.toString());
        this.explorer = explorer;
    }

    @Override
    public void execute() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                long startTime = System.currentTimeMillis();
                DBObject dbObject = (DBObject)((Object)DSEFilterBrowseAction.this.explorer.getSelectedObject());
                DWUtils.getView().getManager().openObject(dbObject.getIdentity(), true);
                CommonUtils.printExecutionTime(dbObject.getIdentity() + " : Filter & Browse : ", System.currentTimeMillis() - startTime);
            }
        });
    }

    @Override
    public void updateUI() {
        ITreeNode dbObject = this.explorer.getSelectedObject();
        boolean isEmpty = this.explorer.getRoot().getLparNodes().isEmpty();
        this.setEnabled(!isEmpty && dbObject.isLeafNode());
    }
}

