/**
 * Copyright (c) 2016 CA, All rights reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.filemaster.dsnlists.handlers;
/**
 * 
 * @author polra04
 */
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

import com.ca.filemaster.common.FMDSNListTreeModel;
import com.ca.filemaster.dsnlists.view.DSNListView;
import com.ca.testingtools.core.TT_TreeItem;

public class MoveDSNListDownHandler extends AbstractHandler {
	static final String cacopyright = "Copyright (c) 2016 CA"; //$NON-NLS-1$
	/*
	 * These fields are used to set up logging
	 */
	Logger log = Logger.getLogger(MoveDSNListDownHandler.class.getName());
	Level baseLevel = log.getLevel();

	/* end of logging setup */
	private static final int MOVEDOWN = 1;

	/*
	 * These fields are used to set up logging
	 */
	private FMDSNListTreeModel model = FMDSNListTreeModel.getInstance();
	
	public Object execute(ExecutionEvent event) throws ExecutionException {
		ISelection sel = HandlerUtil.getCurrentSelection(event);
		if (!(sel instanceof IStructuredSelection))
			return null;
		IWorkbenchPart part = HandlerUtil.getActivePart(event);
		if (!(part instanceof DSNListView))
			return null;

		IStructuredSelection selection = (IStructuredSelection) sel;
		if (((TT_TreeItem) (((IStructuredSelection) selection)
				.getFirstElement())).getParent() != null) {
			if (((TT_TreeItem) (((IStructuredSelection) selection)
					.getFirstElement())).getParent().getParent() != null) {
			}
		}
		
		Iterator<?> it = selection.iterator();
		TT_TreeItem selItem = null;
		if (it.hasNext()) {
			Object selitem = it.next();

			selItem = model.reposition(selitem, MOVEDOWN);

		}
		IWorkbenchWindow window = HandlerUtil
				.getActiveWorkbenchWindowChecked(event);
		Shell shell = window.getShell();
		shell.setMinimized(false);
		shell.forceActive();
		shell.forceFocus();
		try {
			final IWorkbenchPage page = window.getActivePage();
			IViewPart view = page.showView(DSNListView.ID);
			if (view instanceof DSNListView) {
				TreeViewer viewer = ((DSNListView) view).getViewer();
				Object [] expandedElements = viewer.getExpandedElements();
				viewer.refresh();
				viewer.setSelection(null);
				viewer.setInput(model.getDatasets());
				viewer.setExpandedElements(expandedElements);
				
				viewer.setSelection(new StructuredSelection(selItem), true);
				view.setFocus();
			}

		} catch (final PartInitException e) {
		}

		return null;
	}
}
