/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizards;

import java.util.HashMap;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.w3c.dom.Element;

import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.model.ManagePrefsRequest;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.ManagePrefsResponseType;
import com.ca.fmp.ims.model.generated.ManagePrefsType;
import com.ca.fmp.ims.model.generated.PrefsActionType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.wizardpages.ConfigureMFSettingsWizardPage;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.core.TT_TreeItem;

public class ConfigureMFSettingsWizard extends Wizard implements INewWizard {
	
	private ConfigureMFSettingsWizardPage page;	
	private FileMasterServer fileMasterServer;
	private FMServerTreeModel model = FMServerTreeModel.getInstance();	
	
	public ConfigureMFSettingsWizard() {
		super();
		setWindowTitle("Configure Mainframe Settings");		
	}

	public void addPages() {
		page = new ConfigureMFSettingsWizardPage("ConfigureMFSettingsWizardPage", fileMasterServer);
		addPage((IWizardPage)page);
	}
	
	@Override
	public boolean performFinish() {
		return page.doFinish();
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		setWindowTitle("Configure Mainframe Settings");
		
		if(selection.getFirstElement()!=null){
			TT_TreeItem treeItem= ((TT_TreeItem)(((IStructuredSelection)selection).getFirstElement()));
			if (treeItem.getParent() == null) {
				fileMasterServer = (FileMasterServer) treeItem.getValue();
			}
		}
        				
		// Load mainframe preferences if they are not loaded		
		boolean preferenceIsSet = 
		((TT_TreeItem)(((IStructuredSelection)selection).getFirstElement())).getElement().getAttribute("PreferenceIsSet").equalsIgnoreCase("N") ? false : true;
		
								
		if (fileMasterServer.getStatusText().equalsIgnoreCase("active") && !preferenceIsSet){								
			ManagePrefsType managePrefsType= new ManagePrefsType();		
			managePrefsType.setAction(PrefsActionType.G);
		
			XMLDocument xmlDocument = null;
			try {
				xmlDocument = new XMLDocument(new ManagePrefsRequest(fileMasterServer, managePrefsType).createXml());
				int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
	    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
	    		if(uuid.equalsIgnoreCase("\""))
	    			throw new TTException();
			} catch (TTException e) {
				e.printStackTrace();
			}				
												
			HashMap<String, Object> map = new HashMap<String, Object>();
			SendRequestToMainframe req = new SendRequestToMainframe(fileMasterServer, map, "opendb", true, xmlDocument);
			
			if(req.getResult() == Status.CANCEL_STATUS){
				return;
			}
			
			// Extract needed element
			GUIResponseType response = req.getGuiResponseType();
			if (response == null) {
				return;
			}
			
			ManagePrefsResponseType  managePrefsResponse = response.getManagePrefsResponse();				
			if (managePrefsResponse == null) {
				return;
			}				
							 				
			Element serverElement = model.updatePrefs(fileMasterServer.getElement(),
					managePrefsResponse.getPrefsParmFiles().getDsnLists(),
					managePrefsResponse.getPrefsParmFiles().getSelCriteria(),
					managePrefsResponse.getPrefsParmFiles().getCustRecLay(),
					managePrefsResponse.getPrefsParmFiles().getSegmentXref(),
					managePrefsResponse.getPrefsParmFiles().getEnvirons());
					
			model.updateModelPrefs(serverElement, (FileMasterServer) fileMasterServer);													
			model.updateserver(fileMasterServer.getElement(), fileMasterServer, "Y");
			model.save();									
		} 			
	}	
}