/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

/**
 * @author polra04
 *
 */
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import com.ca.fmp.ims.view.wizardpages.CRLClass;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.view.wizardpages.GenericSelectionBox;

//import com.ca.filemaster.common.FileMasterServer;

public class SelWithLayout extends Wizard implements INewWizard {
	static final String cacopyright = "Copyright  2016 CA";
	private SelWithLayoutPage page;
	private CRLClass crl;
	private int selectedIndex;
	private String title = "Custom Layout Rules";
	private String layoutInfo = "";
	private String [] SelConds;
	private GenericSelectionBox genericSelCrit;
	private FileMasterServer server;
	
	public SelWithLayout(String pageName, String title, CRLClass crl, int selectedIndex, String layoutInfo, String [] SelConds,
			 FileMasterServer server){
		this.crl = crl;
		this.selectedIndex = selectedIndex;
		setWindowTitle("Selection Criteria - Conditions"); //$NON-NLS-1$	
		this.title = title;
		this.layoutInfo = layoutInfo;
		this.SelConds = SelConds;
		this.genericSelCrit = genericSelCrit;
		this.server =server;
	}
	
	public SelWithLayout(CRLClass crl, int selectedIndex){
		this.crl = crl;
		this.selectedIndex = selectedIndex;
		setWindowTitle("Selection Criteria - Conditions"); //$NON-NLS-1$		
	}
	
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
	}

	public void addPages() {
		TrayDialog.setDialogHelpAvailable(true);
		page = new SelWithLayoutPage("Create Selection Criteria", title, crl, selectedIndex, server,layoutInfo, SelConds,
				genericSelCrit);
		addPage(page);
	}

	@Override
	public boolean canFinish() {
		return page.isPageComplete();
	}

	@Override
	public boolean performFinish() {
		return page.doFinish();
	}
}
