/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.FMHistory;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.validator.Validator;
import com.ca.fmp.ims.model.IMSDatabase;
import com.ca.fmp.ims.model.OpenDatabaseRequestType;
import com.ca.fmp.ims.model.ValidateDSNRequestType;
import com.ca.fmp.ims.model.WCMemberRequestType;
import com.ca.fmp.ims.model.generated.DataSetInfoType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.IMSENVInfoType;
import com.ca.fmp.ims.model.generated.IMSENVTypeType;
import com.ca.fmp.ims.model.generated.MessagesType;
import com.ca.fmp.ims.model.generated.OpenDBActionType;
import com.ca.fmp.ims.model.generated.WCMemberTypeType;
import com.ca.fmp.ims.model.generated.WildCardMemberResponseType;
import com.ca.fmp.ims.model.generated.WildCardMemberType;
import com.ca.fmp.ims.model.generated.YorNType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.Common;
import com.ca.fmp.ims.view.Messages;
import com.ca.fmp.ims.view.dialogs.RestoreArchiveDatasetsDialog;
import com.ca.fmp.ims.view.dialogs.WildCardMemberDialog;
import com.ca.fmp.ims.view.wizards.OpenDatabaseWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;

/**
 * This is the first page of the OpenDatabase Wizard class. For now, all the
 * parameters in the first page is hard coded.
 * 
 * @author carel06
 */
public class OpenDatabaseWizardPageServer extends WizardPage {
    
	private static final String BUTTON_SELECT_NAME = "&Select...";
	private Text serverText;
	private Text imsenv_dsn;
	private Combo imsEnvironmentCombo;
	private Button imsEnvironmentSelectButton;
	private FileMasterServer fileMasterServer;
	private Logger log = Logger.getLogger(OpenDatabaseWizardPageServer.class.getName());
	
	private boolean changeLog;
	private boolean changeLogForce;
	private IMSENVTypeType imsEnvType;
	
	ArrayList<String> shortText = new ArrayList<String>();
	ArrayList<String> messageID = new ArrayList<String>();
	List<String> messageText = new ArrayList<String>();
	String messageIDFinal="";
	String messageTextFinal= "";
	String title = "";
	
	public boolean pageContentValidated = false;
	
	public String getServer() {
		return fileMasterServer.getText();
	}

	public String getImsEnvDSN() {
		return imsenv_dsn.getText();
	}

	/**
	 * Create the wizard.
	 */
	public OpenDatabaseWizardPageServer(FileMasterServer server) {
		super(Messages.OpenDatabaseWizard_Page_Server);
		setTitle(Messages.OpenDatabaseServer_1);
		this.fileMasterServer = server;
	}

	/**
	 * Create contents of the wizard.
	 * 
	 * @param parent
	 */
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);

		setControl(container);
		container.setLayout(new GridLayout(3, false));

		Label lblNewLabel = new Label(container, SWT.NONE);
		lblNewLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false,
				false, 1, 1));
		lblNewLabel.setText(Messages.OpenDatabaseServer_3);

		serverText = new Text(container, SWT.READ_ONLY);
		serverText.setText(fileMasterServer.getText());
		serverText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(container, SWT.None);

		Label lblNewLabel_1 = new Label(container, SWT.NONE);
		lblNewLabel_1.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setText(Messages.OpenDatabaseWizardPageServer_lblNewLabel_1_text_1);

		imsenv_dsn = new Text(container, SWT.READ_ONLY);
		imsenv_dsn.setText(fileMasterServer.getFmpPreferences().getEnvirons());
		imsenv_dsn.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(container, SWT.None);

		Label lblNewLabel_2 = new Label(container, SWT.NONE);
		lblNewLabel_2.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_2.setText(Messages.OpenDatabaseWizardPageServer_lblNewLabel_2_text);

		imsEnvironmentCombo = new Combo(container, SWT.BORDER);
		imsEnvironmentCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		imsEnvironmentCombo.setTextLimit(8);
		imsEnvironmentCombo.addModifyListener(new ModifyListener() {
			@Override
			public void modifyText(ModifyEvent e) {
//                changed = true;
//                setPageComplete(isPageComplete());
				pageContentValidated = false;
				if(getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD) != null){
					OpenDatabaseWizardPageDBD openDatabaseWizardPageDBD 
							= (OpenDatabaseWizardPageDBD) getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD);
					openDatabaseWizardPageDBD.pageContentValidated = false;
					openDatabaseWizardPageDBD.isDBDDSNPageRequired = false;
//					openDatabaseWizardPageDBD.resetOpenMode();
				}
                
                String imsEnvironment = imsEnvironmentCombo.getText().trim();
                String error = "";
                switch(Validator.member(imsEnvironment, true)) {
                case Validator.MEM_WILDCARD:               
                	log.log(Level.INFO, "MEM_WILDCARE");
                	error = error + Validator.errorMsg[Validator.MEM_WILDCARD] + "\n";
                	setErrorMessage(error);
                	imsEnvironmentSelectButton.setEnabled(true);
                	setPageComplete(false);
                	break;
                case Validator.MEM_INVALID:                	
                	log.log(Level.INFO, "MEM_INVALID");
                	error = error + Validator.errorMsg[Validator.member(imsEnvironment, true)] + "\n ";
                	setErrorMessage(error);
                	imsEnvironmentSelectButton.setEnabled(false);
                	setPageComplete(false);
                	break;
                case Validator.MEM_MISSING:                	
                	log.log(Level.INFO, "MEM_MISSING");
                	error = error + Validator.errorMsg[Validator.member(imsEnvironment, true)] + "\n ";
                	setErrorMessage(error);
                	imsEnvironmentSelectButton.setEnabled(true);
                	setPageComplete(false);
                	break;
                case Validator.NO_ERROR:
                	log.log(Level.INFO, "NO_ERROR");
                	setErrorMessage(null);
                	imsEnvironmentSelectButton.setEnabled(false);
                	setPageComplete(true);
                	break;
                }
			}
		});
        imsEnvironmentCombo.addVerifyListener(new verifytoUpperCase());
		
		imsEnvironmentSelectButton = new Button(container, SWT.NONE);
		imsEnvironmentSelectButton.setText(BUTTON_SELECT_NAME);
		imsEnvironmentSelectButton.setEnabled(false);
		imsEnvironmentSelectButton.addSelectionListener(new SelectionListener() {			
			@Override
			public void widgetSelected(SelectionEvent e) {
				
                WildCardMemberType wildCardMemberType = new WildCardMemberType();
                wildCardMemberType.setDsname(getImsEnvDSN());
                String imsEnvironment = imsEnvironmentCombo.getText().trim();
                if(imsEnvironment == null || imsEnvironment.equals("")) {
                	imsEnvironment = "*";
                }
                wildCardMemberType.setWCMemberName(imsEnvironment);
                wildCardMemberType.setWCMemberType(WCMemberTypeType.IMSENV);
                
                try {
					XMLDocument xmlDocument = new XMLDocument(new WCMemberRequestType(fileMasterServer, wildCardMemberType).createXml());
                    final HashMap<String, Object> map = new HashMap<String, Object>();
    				SendRequestToMainframe response=new SendRequestToMainframe(fileMasterServer, map, "opendb", true, xmlDocument);
    				if(response.getResult() == Status.CANCEL_STATUS) {
                        // TODO need to figure out how to notify the user of an error
    					// when sending the request
    					// there was an error after sending a request to mainframe.
    					log.log(Level.WARNING, "Error when sending mainframe request");
    					return;
    				}     
    				    
    				GUIResponseType guiResponseType = response.getGuiResponseType();
    				if(guiResponseType.getMessages()!= null){    					
    					Common.displayErrorDialogs(guiResponseType.getMessages());
    				} else {
    					WildCardMemberResponseType wildCardMemberResponseType = guiResponseType.getWildCardMemberResponse();
    					ArrayList<IMSENVInfoType> imsEnvInfos = (ArrayList<IMSENVInfoType>) wildCardMemberResponseType.getIMSENVInfoList().getIMSENVInfo();    				
    					WildCardMemberDialog wildCardMemberDialog = new WildCardMemberDialog(getShell(), getImsEnvDSN(), imsEnvInfos, imsEnvironmentCombo);
    					wildCardMemberDialog.create();
    					wildCardMemberDialog.open();    					
    				}    				    			
				} catch (TTException e1) {
                    log.log(Level.WARNING, "Error TTException" + e1.getErrorMessage());
                    e1.printStackTrace();
                    return;
				}
			}			
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				widgetSelected(e);		
			}
		});		
		
		// need to set the text after adding most of the widgets to 
		// prevent NPE issues with the ModifyListener event
		imsEnvironmentCombo.setText("");
		FMHistory.intializeComboBoxes(imsEnvironmentCombo,"envNameCombo");
		imsEnvironmentCombo.select(0);
		PlatformUI.getWorkbench().getHelpSystem().setHelp(container, OpenDatabaseWizard.CONTEXT_HELP_ID);
		
		
		//invisible check box from DBD page for identical horizontal indentation
		Button useSecondaryIndex = new Button(container, SWT.CHECK);
		useSecondaryIndex.setText("&Use secondary index");
		useSecondaryIndex.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		useSecondaryIndex.setEnabled(false);
		useSecondaryIndex.setVisible(false);
		new Label(container, SWT.NONE).setVisible(false);
		new Label(container, SWT.NONE).setVisible(false);
		
		//invisible table from 3rd page for computing default size of wizard
		TableViewer tableViewer = new TableViewer(container, SWT.BORDER);
		tableViewer.getTable().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
		TableViewerColumn tableColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		tableColumn.getColumn().setWidth(675);
		tableViewer.getTable().setVisible(false);
		
		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);
	}

	public String getImsEnvironment() {
        // carel06 Defect 3167
		return imsEnvironmentCombo.getText().trim();
	}
	
	public Combo getEnvNameCombo(){
		return imsEnvironmentCombo;
	}
	
	@Override
	public IWizardPage getNextPage() {
		OpenDatabaseWizard openDatabaseWizard = ((OpenDatabaseWizard)this.getWizard());		
												
		if(openDatabaseWizard==null){
			return null;	
		}	
		
		// Is IMS Environment data set archived? If yes, then alow user to continue only when restoration takes place succesfully.
		XMLDocument xmlDocument = null;
		ArrayList<String> datasets = new ArrayList<String>();
		try {
			xmlDocument = new XMLDocument(new ValidateDSNRequestType(openDatabaseWizard.getFileMasterServer(), fileMasterServer.getFmpPreferences().getEnvirons()).createXml());
			int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
			String uuid = xmlDocument.toString().substring(begOfGUISession, begOfGUISession+1);
			if(uuid.equalsIgnoreCase("\""))
				throw new TTException();
		} catch (TTException e) {
			e.printStackTrace();
			return null;
		}
		HashMap<String, Object> map = new HashMap<String, Object>();

		// carel06
		// instead of a using the SendRequestToMainframeJob, I 
		// changed it to SendRequestToMainframe.
		// we are waiting for the results anyways so no need to put this in a separate thread.
		SendRequestToMainframe req = new SendRequestToMainframe(openDatabaseWizard.getFileMasterServer(), map, "opendb", true, xmlDocument);
		if(req.getResult() == Status.CANCEL_STATUS){
			return null;
		}
		// ParseResponse
		GUIResponseType response = req.getGuiResponseType();
		if (response == null) {
			return null;
		}
		// navri01- i added this to fix defect 3078. we need to show Error when DSN does not exist.
		if(response.getFunctionRC()!=0 || response.getReturnCode()!=0){
			((OpenDatabaseWizard)this.getWizard()).showError(req);
			setPageComplete(false);
		}
	
		if (response.getValidateDSNResponse().getDataSetInfo() == null) {
			return null;
		}	
	
		DataSetInfoType dsInfo = response.getValidateDSNResponse().getDataSetInfo();
		if(dsInfo.getVolumeSerial()!=null)
		{
			if (dsInfo.getVolumeSerial().equalsIgnoreCase("ARCIVE")) {
				datasets.add(dsInfo.getDsname());
				RestoreArchiveDatasetsDialog radd = new RestoreArchiveDatasetsDialog(
						getShell(), datasets, openDatabaseWizard.getFileMasterServer());
				radd.create();
				radd.open();
				if(radd.getReturnCode() != 0)
					return null;										
			}
		}				
	    // Restoration code end		
								
		boolean canFlip = sendRequest();
		if(canFlip){
			OpenDatabaseWizardPageDBD page = this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD) != null ?
					((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)) : new OpenDatabaseWizardPageDBD(changeLog, changeLogForce);

			if(this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD) == null){
				openDatabaseWizard.addPage(page);
			}
			page.setValues(changeLog, changeLogForce, imsEnvType, getImsEnvironment());

			openDatabaseWizard.addPage(page);
			pageContentValidated = true;
			return page;
		}			
				
		return null;
	}

	@Override
	public boolean canFlipToNextPage() {
		return isPageComplete();
	}
	
	private boolean sendRequest(){
		XMLDocument xmlDocument = null;
		String uuid = "";
		IMSDatabase imsDb = new IMSDatabase();
		
		OpenDatabaseWizard oDBWizard = ((OpenDatabaseWizard)this.getWizard());
		imsDb.setIMSEmvironmentPDS(getImsEnvDSN().trim());
		imsDb.setIMSEnvironment(getImsEnvironment().trim());
		
		try {
			OpenDatabaseRequestType oDRT = new OpenDatabaseRequestType(oDBWizard.getFileMasterServer(),imsDb,"",new ArrayList<String>(), OpenDBActionType.NEXT);
			xmlDocument = new XMLDocument(oDRT.createXml());
			if(oDRT.getUUID()==null || oDRT.getUUID().isEmpty()){
				throw new TTException();
			}
			uuid = oDRT.getUUID();
		} catch (TTException e) {
			e.printStackTrace();
			return false;
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req=new SendRequestToMainframe(oDBWizard.getFileMasterServer(), map, "opendb", true, xmlDocument);
		if(req.getGuiResponseType() != null){
			parseResponse(req.getGuiResponseType());
			if(req.getGuiResponseType().getMessages() != null
					&& !req.getGuiResponseType().getMessages().getMessage().isEmpty()){
				return false;
			} else {
				return true;
			}
		}
		return false;
	}

	private void parseResponse(GUIResponseType guiResponseType) {

		if(guiResponseType.getFunctionRC() != 0 || guiResponseType.getReturnCode() != 0){
			showError(guiResponseType);
			setPageComplete(false);
		}
		if(guiResponseType.getEditResponse().getOpenDatabaseResponse().getIMSEnvODInfo() != null){
			changeLog = guiResponseType.getEditResponse().getOpenDatabaseResponse().getIMSEnvODInfo().getChangeLog() == YorNType.Y ? true : false;
			changeLogForce = guiResponseType.getEditResponse().getOpenDatabaseResponse().getIMSEnvODInfo().getChangeLogForce() == YorNType.Y ? true : false;
			imsEnvType = guiResponseType.getEditResponse().getOpenDatabaseResponse().getIMSEnvODInfo().getType();
			((OpenDatabaseWizard)getWizard()).imsEnvType = imsEnvType;
		}
	}
	
	/*
	 * Defect 3150 carel06
	 * While working on Defect 3151, when a database is already open
	 * and you try to open another database, the response from MF
	 * does not include a MessageType.  I have corrected the NPE issue.
	 * On Story B-63152, we will tackle opening multiple database more 
	 * thoroughly.
	 */
	private void showError(GUIResponseType guiResponseType) {
		shortText = new ArrayList<String>();
		messageID = new ArrayList<String>();
		messageText = new ArrayList<String>();
		messageIDFinal = new String();
		messageTextFinal = new String();
		MessagesType messagesType = guiResponseType.getMessages();
		if(messagesType != null) {
			for(int i=0;i<messagesType.getMessage().size();i++){
				shortText.add(guiResponseType.getMessages().getMessage().get(i).getShortText());
				messageID.add(guiResponseType.getMessages().getMessage().get(i).getMessageId());
				if(guiResponseType.getMessages().getMessage().get(i).getMessageText()!=null)
					messageText.add(guiResponseType.getMessages().getMessage().get(i).getMessageText()+ "\n");
				else 
					messageText.add("");
			}
			for(int i=0;i<messageID.size();i++){
				messageIDFinal+= messageID.get(i)+" : " + shortText.get(i) + "\n" ; 
				title = "Error";
				messageTextFinal+= messageText.get(i).substring(1, messageText.get(i).length()-2) + "\n";	
			}			
		} else {
			// TODO 
			// Defect 3150 carel06
			// not sure what to put here if we don't get a response from mainframe
			// leaving it blank for now.
			title = "Error";
			messageIDFinal = "";
			messageTextFinal = "";
		}
		TT_ErrorDialog.openError(null, title, messageIDFinal, new Throwable(messageTextFinal));	
	}
	
}
