/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.DBDInfo;
import com.ca.fmp.ims.common.FMHistory;
import com.ca.fmp.ims.common.FileMasterDataset;
import com.ca.fmp.ims.common.FileMasterMember;
import com.ca.fmp.ims.common.validator.Validator;
import com.ca.fmp.ims.model.IMSDatabase;
import com.ca.fmp.ims.model.OpenDatabaseRequestType;
import com.ca.fmp.ims.model.WCMemberRequestType;
import com.ca.fmp.ims.model.generated.EditModeType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.IMSENVTypeType;
import com.ca.fmp.ims.model.generated.OpenDBActionType;
import com.ca.fmp.ims.model.generated.PCBInfoListType;
import com.ca.fmp.ims.model.generated.SIXInfoListType;
import com.ca.fmp.ims.model.generated.WCMemberTypeType;
import com.ca.fmp.ims.model.generated.WildCardMemberType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.Common;
import com.ca.fmp.ims.view.Messages;
import com.ca.fmp.ims.view.wizards.MemberWizard;
import com.ca.fmp.ims.view.wizards.OpenDatabaseWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class OpenDatabaseWizardPageDBD extends WizardPage implements ModifyListener {
	private Button btnSelectDbd;
	private Button btnSelectPSBorACB;
	private Logger log = Logger.getLogger(OpenDatabaseWizardPageDBD.class.getName());
	private GUIResponseType response;
	private TestingToolsWizardDialog dialog =null;
	private Text text;
	private Text text_1;
	private Text text_2;
    private OpenDatabaseWizard openDatabaseWizard;
	private Combo comboDbd;
	private Combo comboPSBorACB;
	private Button editOption;
	private Button browseOption;
	private Button useSecondaryIndex;	
	public ArrayList<DBDInfo> dbdinfoList;
	public PCBInfoListType pcbInfoList;
	public SIXInfoListType sixInfoList;	
	ArrayList<String> shortText = new ArrayList<String>();
	ArrayList<String> messageID = new ArrayList<String>();
	List<String> messageText = new ArrayList<String>();
	String messageIDFinal="";
	String messageTextFinal= "";
	String title = "";
	
	private boolean changeLog;
//	private boolean changeLogForce;
//	private IMSENVTypeType imsEnvType;
	
	public boolean isDBDDSNPageRequired = false;
	public boolean isPSBPageRequired = false;
	public boolean isSIXPageRequired = false;	
	public boolean pageContentValidated = false;
	
	public OpenDatabaseWizardPageDBD(boolean changeLog, boolean changeLogForce) {
		super(Messages.OpenDatabaseWizard_Page_DBD);
		setTitle("Database Specification");
        this.openDatabaseWizard = (OpenDatabaseWizard) this.getWizard();
        
        this.changeLog = changeLog;
//        this.changeLogForce = changeLogForce;
	}

	@Override
	public void createControl(Composite parent) {
		openDatabaseWizard = (OpenDatabaseWizard) this.getWizard();
		Composite container = new Composite(parent, SWT.NULL);
		container.setLayout(new GridLayout(3, false));
		setControl(container);
		
		setControl(container);
		
		Label lblServer = new Label(container, SWT.NONE);
		lblServer.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblServer.setText(Messages.OpenDatabaseServer_3);
		
		text = new Text(container, SWT.READ_ONLY);
		text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		text.setText(openDatabaseWizard.getFileMasterServer().getText());
		new Label(container, SWT.NONE);
		
		Label lblImsenvDsn = new Label(container, SWT.NONE);
		lblImsenvDsn.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblImsenvDsn.setText(Messages.OpenDatabaseWizardPageServer_lblNewLabel_1_text_1);
		
		text_1 = new Text(container, SWT.READ_ONLY);
		text_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));			
		text_1.setText(openDatabaseWizard.getFileMasterServer().getFmpPreferences().getEnvirons());
		new Label(container, SWT.NONE);
		
		Label lblImsEnvironment = new Label(container, SWT.NONE);
		lblImsEnvironment.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblImsEnvironment.setText(Messages.OpenDatabaseWizardPageServer_lblNewLabel_2_text);
		
		text_2 = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		text_2.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		text_2.setText(openDatabaseWizard.getOpenDatabaseWizardPageServer().getImsEnvironment());
		new Label(container, SWT.NONE);
		
		Label lblDbd = new Label(container, SWT.NONE);
		lblDbd.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblDbd.setText(Messages.OpenDatabaseWizardPageDBD_DBDLabel_text);
		
		comboDbd = new Combo(container, SWT.NONE);
		comboDbd.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		FMHistory.intializeComboBoxes(comboDbd,"DBDCombo");
		comboDbd.setTextLimit(8);
		comboDbd.addModifyListener(this);
		comboDbd.addVerifyListener(new verifytoUpperCase());
		
		btnSelectDbd = new Button(container, SWT.NONE);
		btnSelectDbd.setText("&Select...");
        btnSelectDbd.setEnabled(false);
        btnSelectDbd.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				boolean connection=selectButtonRequest(WCMemberTypeType.DBDLIB);

				if(connection){

					if (response != null && response.getFunctionRC() == 0 && response.getReturnCode() == 0) {
						String title="";
						if(response.getWildCardMemberResponse().getDBDLIBInfoList()!=null){
							title = "Select a DBD";
						} else if(response.getWildCardMemberResponse().getPSBLIBInfoList()!=null){
							title = "Select a PSB or ACB";
						} else {
							// if it doesn't match, just use a generic title
							title = "Select Member";
						}
						MemberWizard wizard = new MemberWizard(title, "DBD Name:", comboDbd.getText(), response, openDatabaseWizard.getFileMasterServer(), "com.ca.fmp.ims.help.selectDBD");
						dialog = new TestingToolsWizardDialog(getShell(), wizard);
						dialog.create();
						MemberWizardPage.okMemberButton.addSelectionListener(new SelectionListener() {

							@Override
							public void widgetSelected(SelectionEvent e) {
								FileMasterMember member = MemberWizardPage.getSelectedMember();
								comboDbd.setText(member.getName());
							}

							@Override
							public void widgetDefaultSelected(SelectionEvent e) {
								// TODO Auto-generated method stub
							}
						});
						dialog.open();

					} else {
						if(response.getMessages()!=null){			
							Common.displayErrorDialogs(response.getMessages());
						}
					}
				}
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				widgetSelected(e);
			}
		});
   		
		Label lblPsbOrAcb = new Label(container, SWT.NONE);
		lblPsbOrAcb.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1));
		lblPsbOrAcb.setText(Messages.OpenDatabaseWizardPageDBD_PSBLabel_text/*"&PSB or ACB Name:"*/);
		
		comboPSBorACB = new Combo(container, SWT.NONE);
		comboPSBorACB.setEnabled(true);
		comboPSBorACB.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		FMHistory.intializeComboBoxes(comboPSBorACB,"PSBorACBCombo");
		comboPSBorACB.setTextLimit(8);
		comboPSBorACB.addModifyListener(this);
		comboPSBorACB.addVerifyListener(new verifytoUpperCase());		
		
		btnSelectPSBorACB = new Button(container, SWT.NONE);
		btnSelectPSBorACB.setEnabled(true);
		btnSelectPSBorACB.setText("S&elect...");
		btnSelectPSBorACB.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {											
				boolean connection=selectButtonRequest(WCMemberTypeType.PSBLIB);
				
				if(connection){
					if (response != null && response.getFunctionRC() == 0 && response.getReturnCode() == 0) {
						title = "Select a PSB or ACB";								
						MemberWizard wizard = new MemberWizard(title, Messages.OpenDatabaseWizardPageDBD_PSBLabel_text, getPSBorACB(), response, openDatabaseWizard.getFileMasterServer(), "com.ca.fmp.ims.help.selectPSBorACB");
						dialog = new TestingToolsWizardDialog(getShell(), wizard);
						dialog.create();
						MemberWizardPage.okMemberButton.addSelectionListener(new SelectionListener() {

							@Override
							public void widgetSelected(SelectionEvent e) {
								FileMasterMember member = MemberWizardPage.getSelectedMember();
								comboPSBorACB.setText(member.getName());
							}

							@Override
							public void widgetDefaultSelected(SelectionEvent e) {
								// TODO Auto-generated method stub
							}
						});
						dialog.open();

					} else {
						if(response.getMessages()!=null){			
							Common.displayErrorDialogs(response.getMessages());
						}
					}
				}
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				widgetSelected(e);
			}
		});		
		
		comboDbd.select(0);
		
		Group grpOptionMode = new Group(container, SWT.NONE);
		grpOptionMode.setLayout(new GridLayout(2, false));
		grpOptionMode.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 3, 1));
		grpOptionMode.setText("Open mode");

		editOption = new Button(grpOptionMode, SWT.RADIO);
		editOption.setText("Edi&t");

		browseOption = new Button(grpOptionMode, SWT.RADIO);
		browseOption.setText("B&rowse");
		
		if(FMHistory.getBoolean(Messages.OpenWizardHistoryEditMode)){
			editOption.setSelection(true);
			browseOption.setSelection(false);
		} else {
			editOption.setSelection(false);
			browseOption.setSelection(true);
		}
		
		if(changeLog == true){
			editOption.setEnabled(false);
			setMessage(Messages.OpenDatabaseWizardPageDBD_Warning_Change_Log_text, WARNING);
		} else {
			editOption.setEnabled(true);
			setMessage(null, WARNING);
		}

		useSecondaryIndex = new Button(container, SWT.CHECK);
		useSecondaryIndex.setText("&Use secondary index");				
		useSecondaryIndex.addSelectionListener(new SelectionListener() {
			@Override
			public void widgetSelected(SelectionEvent e) {
               if (((Button)e.getSource()).getSelection()==true){
            	   comboPSBorACB.setEnabled(false);            	     
                   btnSelectPSBorACB.setEnabled(false);    
               }            	   
               else{
            	   comboPSBorACB.setEnabled(true); 
            	   comboPSBorACB.setText(comboPSBorACB.getText()); // Takes care of enabling/disabling of the "Select..." button.   	               	   
               }
       		   setPageComplete(isPageComplete());
			}	
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});			
					
		PlatformUI.getWorkbench().getHelpSystem().setHelp(container, OpenDatabaseWizard.CONTEXT_HELP_ID);
	}
	
	@Override
	public void modifyText(ModifyEvent e) {
		// TODO Auto-generated method stub
		pageContentValidated = false;
		isDBDDSNPageRequired = false;
		setPageComplete(isPageComplete());
	}
	
	@Override
	public boolean canFlipToNextPage() {
		return isPageComplete();
	}
	
	@Override
	public boolean isPageComplete() {
		String dbdMemberString = getDbd();
		String PSBorACBString = getPSBorACB();
		String error = "";
		String warning = ""; 

		switch (Validator.member(dbdMemberString, true)) {
			case Validator.MEM_WILDCARD:
				log.log(Level.INFO, "MEM_WILDCARD");
				error = error + Validator.errorMsg[Validator.MEM_WILDCARD] + "\n";
				btnSelectDbd.setEnabled(true);
				break;
			case Validator.MEM_INVALID:
				log.log(Level.INFO, "MEM_INVALID");
				error = error
						+ Validator.errorMsg[Validator
						                     .member(dbdMemberString, true)] + "\n ";
				btnSelectDbd.setEnabled(false);
				break;
			case Validator.MEM_MISSING:
				log.log(Level.INFO, "MEM_MISSING");
				error = error
						+ Validator.errorMsg[Validator
						                     .member(dbdMemberString, true)] + "\n ";
				btnSelectDbd.setEnabled(true);
				break;
			case Validator.NO_ERROR:
				log.log(Level.INFO, "NO_ERROR");
				btnSelectDbd.setEnabled(false);
				error = "";
				break;
		}
        
		if (useSecondaryIndex!=null){
			if (useSecondaryIndex.getSelection()==false){				
				switch (Validator.member(PSBorACBString, true)) {
					case Validator.MEM_WILDCARD:
						log.log(Level.INFO, "MEM_WILDCARD");
						error = error + Validator.errorMsg[Validator.MEM_WILDCARD] + "\n";
						btnSelectPSBorACB.setEnabled(true);
						warning = warning + (changeLog == true ? Messages.OpenDatabaseWizardPageDBD_Warning_Change_Log_text : "");														   
						break;
					case Validator.MEM_INVALID:
						log.log(Level.INFO, "MEM_INVALID");
						error = error
								+ Validator.errorMsg[Validator
					                     .member(PSBorACBString, true)] + "\n ";
						btnSelectPSBorACB.setEnabled(false);
						warning = warning + (changeLog == true ? Messages.OpenDatabaseWizardPageDBD_Warning_Change_Log_text : "");					   
						break;
					case Validator.MEM_MISSING:
						log.log(Level.INFO, "MEM_MISSING");
						if (comboPSBorACB.isEnabled()){
							btnSelectPSBorACB.setEnabled(true);
						}
						warning = warning + (changeLog == true ? Messages.OpenDatabaseWizardPageDBD_Warning_Change_Log_text : ""); 						
						break;
					case Validator.NO_ERROR:
						log.log(Level.INFO, "NO_ERROR");
						btnSelectPSBorACB.setEnabled(false);
						
						if (dbdMemberString.length()==0){
							error = "";
						}
						
						warning = warning + (changeLog == true ? Messages.OpenDatabaseWizardPageDBD_Warning_Change_Log_text : "");
						break;
				}
			}
			else {
				setErrorMessage(null);				
                if (comboPSBorACB.getText().trim().length()!=0){
				   warning = warning + Messages.OpenDatabaseWizardPageDBD_Warning_PSBorACB_text + 
             			     (changeLog == true ? "\n " + Messages.OpenDatabaseWizardPageDBD_Warning_Change_Log_text : "");	   
                }
                else {
 				    warning = warning +
 				    		(changeLog == true ? Messages.OpenDatabaseWizardPageDBD_Warning_Change_Log_text : "");
                }							
			}
		}

		if (error.length() > 0) {
			setErrorMessage(error);
			return false;
		}
		else {
			setErrorMessage(null);			
		}
		
		if (warning.length()>0){
			setMessage(warning, WARNING);			
		}
		else{
			setMessage(null, WARNING);
		}

		return true;
	}
	public boolean selectButtonRequest(WCMemberTypeType memberType) {
		WildCardMemberType wildCardMemberType = new WildCardMemberType();
		// The sequence of the requests is not the issue.  The XML error is because 
		// you are sending the wildcard value in the ENV name, in the failed requests.  
		// Also, but not related to the error, some of your requests include both 
		// an Environment name and a DS name.  Functionally, the two are mutually 
		// exclusive; each request type requires only one; the other is ignored.  
		// As I said, this does not cause the error, but I expect the code will be 
		// a lot more clear if you send only the necessary attributes.  Also, this 
		// error will not occur because you wont be sending the Environment name 
		// at all.
		// wildCardMemberType.setDsname(getImsEnvDSN());
		wildCardMemberType.setEnvname(openDatabaseWizard.getOpenDatabaseWizardPageServer().getImsEnvironment());
		wildCardMemberType.setWCMemberType(memberType /* WCMemberTypeType.DBDLIB */);
						
		String memberName="";		
		if (memberType == WCMemberTypeType.DBDLIB){  
			memberName = comboDbd.getText().trim();
		}
		else {
			memberName = getPSBorACB();
		}
				
		if(memberName == null || memberName.equals("")) {
			memberName = "*";
		}
		wildCardMemberType.setWCMemberName(memberName);
		
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new WCMemberRequestType(openDatabaseWizard.getFileMasterServer(), wildCardMemberType).createXml());
			int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
			String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
			if(uuid.equalsIgnoreCase("\"")) {
				throw new TTException();				
			}
		} catch (TTException e) {
            log.log(Level.WARNING, "TTException occurred");
			e.printStackTrace();
			return false;
		}

		final HashMap<String, Object> map = new HashMap<String, Object>();

		
		SendRequestToMainframe req = new SendRequestToMainframe(openDatabaseWizard.getFileMasterServer(), map, "opendb", true, xmlDocument);
		if(req.getResult()==Status.CANCEL_STATUS){
			return false;
		}

		response = req.getGuiResponseType();

		if (response == null) {
			return false;
		}

		return true;
	}
	

	public String getDbd() {
		// carel06 Defect 3167
		return comboDbd.getText().trim();
	}
	
	public Combo getDBDCombo(){
		return comboDbd;
	}
	
	public String getPSBorACB(){
        // carel06 Defect 3167
        if (getUseSecondaryIndex()){
        	return "";
        }
		return comboPSBorACB.getText().trim();
	}	
	
	public Combo getPSBorACBCombo(){
		return comboPSBorACB;
	}
	
	public boolean getUseSecondaryIndex(){
		if (useSecondaryIndex!=null){
			return useSecondaryIndex.getSelection();
		} 
		return false;		
	}		
	
	@Override
	public IWizardPage getNextPage() {
		boolean canFlip = sendRequest();
		if(canFlip){			
			if (isPSBPageRequired){
				OpenDatabaseWizardPagePCB page = this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_PCB) !=null ? ((OpenDatabaseWizardPagePCB)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_PCB)) : new OpenDatabaseWizardPagePCB();				
				if(this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_PCB) == null){
					((OpenDatabaseWizard)this.getWizard()).addPage(page);
					pageContentValidated = true;
				}				
				if(pageContentValidated == false){
					page.setTableInput();
					pageContentValidated = true;
				}								
			    return page;				
			}			
			else if (isSIXPageRequired){                                             
				OpenDatabaseWizardPageSIX page = this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_SIX) !=null ? ((OpenDatabaseWizardPageSIX)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_SIX)) : new OpenDatabaseWizardPageSIX();				
				if(this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_SIX) == null){
					((OpenDatabaseWizard)this.getWizard()).addPage(page);
					pageContentValidated = true;
				}		
				if(pageContentValidated == false){
					page.setTableInput();
					pageContentValidated = true;
				}				
			    return page;	
			}						
			else if(isDBDDSNPageRequired){
				OpenDatabaseWizardPageDBDDSN page = this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBDDSN) !=null ? ((OpenDatabaseWizardPageDBDDSN)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBDDSN)) : new OpenDatabaseWizardPageDBDDSN();
				if(this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBDDSN) == null){
					((OpenDatabaseWizard)this.getWizard()).addPage(page);
				}
				if(pageContentValidated == false){
					// The following call is needed to update the table based on the mainframe response.
					page.setTableInput();
					pageContentValidated = true;
				}
				return page;
			} else {
				OptionsWizardPage page = openDatabaseWizard.getPage(Messages.OpenDatabaseWizard_Page_Options) != null ?
						((OptionsWizardPage)openDatabaseWizard.getPage(Messages.OpenDatabaseWizard_Page_Options)) : new OptionsWizardPage(openDatabaseWizard.getFileMasterServer());
				((OpenDatabaseWizard)openDatabaseWizard).addPage(page);
				pageContentValidated = true;
				return page;
			}
		}
		return null;
	}
	
	private boolean sendRequest(){
		XMLDocument xmlDocument = null;
		String uuid = "";
		IMSDatabase imsDb = new IMSDatabase();
		OpenDatabaseWizardPageServer oDBWizardPageServer = (OpenDatabaseWizardPageServer) openDatabaseWizard.getPage(Messages.OpenDatabaseWizard_Page_Server);
		imsDb.setIMSEmvironmentPDS(oDBWizardPageServer.getImsEnvDSN().trim());
		imsDb.setIMSEnvironment(oDBWizardPageServer.getImsEnvironment().trim());
		imsDb.setDBDName(getDbd());			
		imsDb.setPSBName(getPSBorACB());            	
                     				        
        imsDb.setSecondaryIndex(useSecondaryIndex.getSelection());
        imsDb.setSecondaryIndex(getUseSecondaryIndex());         

		try {
			OpenDatabaseRequestType oDRT = new OpenDatabaseRequestType(openDatabaseWizard.getFileMasterServer(),imsDb,"",new ArrayList<String>(),OpenDBActionType.NEXT);
			xmlDocument = new XMLDocument(oDRT.createXml());
			if(oDRT.getUUID()==null || oDRT.getUUID().isEmpty()){
				throw new TTException();
			}
			uuid = oDRT.getUUID();
		} catch (TTException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req=new SendRequestToMainframe(openDatabaseWizard.getFileMasterServer(), map, "opendb", true, xmlDocument);	
		if(req.getGuiResponseType()!=null){		
			parseResponse(req.getGuiResponseType());
			if(req.getGuiResponseType().getMessages()!=null&&!req.getGuiResponseType().getMessages().getMessage().isEmpty())
				return false;
			else
				return true;
		}
		return false;

	}

	private void parseResponse(GUIResponseType guiResponseType) {
		if(guiResponseType.getFunctionRC()!=0 || guiResponseType.getReturnCode()!=0){
			showError(guiResponseType);
			setPageComplete(false);
		}
		
		isPSBPageRequired = false;
		isSIXPageRequired = false;
		isDBDDSNPageRequired = false;
		
		if(guiResponseType.getEditResponse().getOpenDatabaseResponse()!=null){
			
			if(guiResponseType.getEditResponse().getOpenDatabaseResponse().getSIXInfoList()!= null){
			    sixInfoList = guiResponseType.getEditResponse().getOpenDatabaseResponse().getSIXInfoList();
			    pcbInfoList = null;
			    isSIXPageRequired = true;											
			}			
			else if(guiResponseType.getEditResponse().getOpenDatabaseResponse().getPCBInfoList()!= null){
			    pcbInfoList = guiResponseType.getEditResponse().getOpenDatabaseResponse().getPCBInfoList();
			    sixInfoList = null;
			    isPSBPageRequired = true;											
			}													
			else if(guiResponseType.getEditResponse().getOpenDatabaseResponse().getDLIFileList() != null){
				isDBDDSNPageRequired = true;
				String dbdName = "";
				String ddName = "";
				FileMasterDataset fmdataset = new FileMasterDataset(null);
				dbdinfoList = new ArrayList<DBDInfo>();
				for(int i = 0; i<guiResponseType.getEditResponse().getOpenDatabaseResponse().getDLIFileList().getDLIFileEntry().size();i++){
					dbdName =(guiResponseType.getEditResponse().getOpenDatabaseResponse().getDLIFileList().getDLIFileEntry().get(i).getDbdname());		
					ddName = (guiResponseType.getEditResponse().getOpenDatabaseResponse().getDLIFileList().getDLIFileEntry().get(i).getDdname());
					DBDInfo dbdinfo = new DBDInfo(dbdName, ddName, fmdataset);
					dbdinfo.setDBDName(dbdName);
					dbdinfo.setDDName(ddName);
					dbdinfo.setFmdataset(null);
					dbdinfoList.add(dbdinfo);
				}
			} 
		}
	}
	
	private void showError(GUIResponseType guiResponseType) {
		shortText = new ArrayList<String>();
		messageID = new ArrayList<String>();
		messageText = new ArrayList<String>();
		messageIDFinal = new String();
		messageTextFinal = new String();
		for(int i=0;i<guiResponseType.getMessages().getMessage().size();i++){
			shortText.add(guiResponseType.getMessages().getMessage().get(i).getShortText());
			messageID.add(guiResponseType.getMessages().getMessage().get(i).getMessageId());
			if(guiResponseType.getMessages().getMessage().get(i).getMessageText()!=null)
			messageText.add(guiResponseType.getMessages().getMessage().get(i).getMessageText()+ "\n");
			else 
				messageText.add("");
		}
		for(int i=0;i<messageID.size();i++){
			messageIDFinal+= messageID.get(i)+" : " + shortText.get(i) + "\n" ; 
			title = "Error";
			messageTextFinal+= messageText.get(i).substring(1, messageText.get(i).length()-2) + "\n";	
		}
		TT_ErrorDialog.openError(null, title, messageIDFinal, new Throwable(messageTextFinal));	
	}

	public ArrayList<DBDInfo> getDBDInfoList(){
		return dbdinfoList;
	}

	public PCBInfoListType getPCBInfoList(){
		return pcbInfoList;
	}
		
	public SIXInfoListType getSIXInfoList(){
		return sixInfoList;
	}			
	
	public EditModeType getEditMode(){
		if(browseOption.getSelection()){
			return EditModeType.B;
		}
		if(editOption.getSelection()){
			return EditModeType.E;
		}
		return EditModeType.B;
	}
	
	public void setValues(boolean changeLog, boolean changeLogForce, IMSENVTypeType imsEnvType, String imsEnvName){
		this.changeLog = changeLog;
//		this.changeLogForce = changeLogForce;
//		this.imsEnvType = imsEnvType;
		
		try {
			text_2.setText(imsEnvName.trim());

			if(changeLog == true){
				editOption.setEnabled(false);
				setMessage(Messages.OpenDatabaseWizardPageDBD_Warning_Change_Log_text, WARNING);
			} else {
				editOption.setEnabled(true);
				setMessage(null, WARNING);
			}
		}
		catch (NullPointerException npe){}
	}
}
