/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

/**
 * @author parra12
 *
 */

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;

import com.ca.fmp.ims.common.CommonMFCalls;
import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.fmp.ims.common.FMXMLProfile;
import com.ca.fmp.ims.common.FileMasterMember;
import com.ca.fmp.ims.common.FileMasterSegment;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.model.ListSegmentsRequestType;
import com.ca.fmp.ims.model.UnmarshalGUIResponse;
import com.ca.fmp.ims.model.ValidateDSNRequestType;
import com.ca.fmp.ims.model.ViewLayoutRequestType;
import com.ca.fmp.ims.model.generated.FieldListType;
import com.ca.fmp.ims.model.generated.FieldType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.SegmentInfoType;
import com.ca.fmp.ims.model.generated.YorNType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class FormattedSelCritWizardPage1 extends WizardPage implements SelectionListener {
	private static final int SEGMENTNAME = 0;
	private static final int CONDITION = 1;

	private static TableViewer viewer;

	private final String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.formattedSelCritWizardPage1";
	private int pixelSizeOfCharacter = -1;
	private static final int GUISESSIONLEN = 36;
	private Shell shell;
	private Text text;
	private GC gc;
	private Listener sortListener;
	private FileMasterServer server;
	private String envName;
	private String dbdName;
	private String layoutName;
	ArrayList<String> shortText = new ArrayList<String>();
	ArrayList<String> messageID = new ArrayList<String>();
	List<String> messageText = new ArrayList<String>();
	String messageIDFinal="";
	String messageTextFinal= "";
	String title = "";
	private TreeViewer treeViewer;
	private Tree tree;
	private Button rulesBtn;
	private Shell parentShell;
	public static Button saveSelCrit;
	private ArrayList<FileMasterSegment> fmSegments;
	private static String conditionsToRet = "";
	private ArrayList<FileMasterSegment> listOfAllSeg;
	private HashMap<String, FileMasterSegment> mapOfAllSeg;
	private ArrayList<FileMasterSegment> fmpSegments;
	private boolean canFinish = false;
	
	public FormattedSelCritWizardPage1(Shell shell, String title,
			FileMasterServer server, String envName, String dbdName, String layoutName, ArrayList<FileMasterSegment> fmpSegments) {

		super("FormattedSelCritWizardPage1");
		setTitle("Segment Selection");
		setDescription("Select segment to build selection criteria");
		this.server = server;
		this.envName = envName;
		this.dbdName = dbdName;
		this.layoutName = layoutName;
		this.parentShell = shell;
		this.fmpSegments = fmpSegments;
	}

	@Override
	public void createControl(Composite parent) {
		setPageComplete(true);
		Composite container = new Composite(parent, SWT.NONE);
		GridLayout container_layout = new GridLayout(1, false);
		container.setLayout(container_layout);
		Composite select_Member_composite = new Composite(container, SWT.NULL);
		select_Member_composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL,
				true, true, 1, 1));
		select_Member_composite.setLayout(new GridLayout(2, false));

		
		// Create a table view
		createViewer(select_Member_composite);
		
		
		Composite rulesBtn_composite = new Composite(select_Member_composite, SWT.NULL);
		rulesBtn_composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		GridLayout select_datasetbtn_composite_layout = new GridLayout(1, false);
		select_datasetbtn_composite_layout.marginHeight = 0;
		select_datasetbtn_composite_layout.marginWidth = 0;
		rulesBtn_composite.setLayout(select_datasetbtn_composite_layout);
		rulesBtn = new Button(rulesBtn_composite,SWT.PUSH);
		rulesBtn.setText("Select...");
		rulesBtn.setEnabled(true);
		rulesBtn.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				
				
				// TODO Auto-generated method stub
				String layoutInfo = "";
				FileMasterSegment fmpSegment = ((FileMasterSegment)treeViewer.getTree().getSelection()[0].getData());
					// its coming from layout dsn and member
					layoutInfo = layoutName + "(" + fmpSegment.getName() + ")";
					if (layoutName.isEmpty() || fmpSegment.getName().isEmpty()) {
						MessageDialog.openError(new Shell(), "Layout error", "You must specify a layout to perform this action.");
						return;
					}
				
				/*
				 * Gather Selection conditions and store in an array 1 condition
				 * per index
				 */
				//String[] selConds = selConditionText.getText().trim().split("\\r\\n");
				String[] selConds = ((FileMasterSegment)treeViewer.getTree().getSelection()[0].getData()).getSelectionConditions().trim().split("\\r\\n");	
				CRLClass crl = createDummyDRL(layoutInfo);
				if(crl==null)
					return;
				//@parra12:Defect 2976
				if(crl.hasMultiple01Levels()){
					MessageDialog.openError(new Shell(), "Layout error", "Member "+layoutInfo.split("[(*)]")[1]+" contains multiple 01 level definitions which are not supported in this function.  Define a Custom Record Layout member for this copybook which can be used in this function.");
					return;
				}
				TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(parentShell, new SelWithLayout("Selection Criteria Member", "Selection Criteria - Conditions", crl, 0, layoutInfo, selConds, server));
				dialog.create();
				SelWithLayoutPage.saveSelCrit.addSelectionListener(new SelectionListener() {

					@Override
					public void widgetSelected(SelectionEvent e) {
						canFinish = true;
						setPageComplete(isPageComplete());
						// TODO Auto-generated method stub
						AddLayoutSelCondition(SelWithLayoutPage.getNewCondition());
						if (ImportSelCritWizardPage.getLayDsname() != null) {
					//		AddLayoutDatasetMember(ImportSelCritWizardPage.getLayDsname(), ImportSelCritWizardPage.getLayMem());
						}
					}

					@Override
					public void widgetDefaultSelected(SelectionEvent e) {
						// TODO Auto-generated method stub

					}
				});
				//if (canTheDialogBeDisplayed(selConds))
					dialog.open();
					
			}
			
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		setControl(container);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CONTEXT_HELP_ID);
		populateMap(fmpSegments);
		//@parra12: Make a list segments call and store the results that are to be displayed on this dialog.
		parseResponse(ListSegmentsRequest());
		saveSelCrit = new Button(parent, SWT.NONE);
		saveSelCrit.setEnabled(false);
		
		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);
	}

	private void createViewer(Composite parent) {

		treeViewer = new TreeViewer(parent, SWT.BORDER
				| SWT.FULL_SELECTION );
	    tree = treeViewer.getTree();
		tree.setHeaderVisible(true);
		tree.setLinesVisible(true);
		tree.addSelectionListener(this);
		GridData gd = new GridData(SWT.FILL, SWT.FILL, true, true);
        tree.setLayoutData(gd);
		treeViewer.setContentProvider(new SegmentNameContentProvider());
		createColumns(parent, treeViewer);
		getShell().getDefaultButton().setText("OK");
		
		
	}
	
	private void createColumns(Composite parent, TreeViewer viewer) {
		String[] titles = { "Segment Name", "Selection Criteria"};
		int[] bounds = { 10, 300}; // Dynamic values based on segment name.
		for (int i = 0; i < titles.length; i++) {
			TreeViewerColumn treeViewerColumn = new TreeViewerColumn(viewer,SWT.NONE);
			TreeColumn treeColumn = treeViewerColumn.getColumn();

			treeColumn.setText(titles[i]);
			treeColumn.setWidth(bounds[i]);
			treeColumn.setResizable(true);
			switch (i) {
			case SEGMENTNAME:
				treeViewerColumn.setLabelProvider(new SegmentNameLabelProvider());
				break;
			case CONDITION:
				treeViewerColumn.setLabelProvider(new ConditionLabelProvider());
				treeViewerColumn.getColumn().setAlignment(SWT.LEFT);
				break;
			}
		}
		treeViewer.setAutoExpandLevel(AbstractTreeViewer.ALL_LEVELS);
		
	}

	public TableViewer getViewer() {
		return viewer;
	}

	@Override
	public boolean isPageComplete() {
		return canFinish;
	}

	public boolean doFinish() {
		//gather the conditions for all the segments and put them in one string. Prepend it with "ifseg(segmentname)"
		conditionsToRet = "";
		boolean ifSeg = true;
		for(FileMasterSegment fms: listOfAllSeg){
			ifSeg = true;
			if(fms.getSelectionConditions().isEmpty())
				continue;
			if(mapOfAllSeg.get(fms.getName())!=null){
				ifSeg = mapOfAllSeg.get(fms.getName()).isIfSeg();
			}
			if(ifSeg)
			{
				conditionsToRet+="IFSEG("+fms.getName().trim()+") "+fms.getSelectionConditions().trim();
			}
			else{
				conditionsToRet+="IFREC("+fms.getName().trim()+") "+fms.getSelectionConditions().trim();
			}
			if(!conditionsToRet.substring(conditionsToRet.length()-2).equals("\r\n")){
				conditionsToRet+="\r\n";
			}
		}
		saveSelCrit.notifyListeners(SWT.Selection, new Event());
		return true;
	}
	
	protected static String getNewCondition(){
		return conditionsToRet;
	}

	public static FileMasterMember getSelectedMember() {

		return (FileMasterMember) viewer.getElementAt(viewer.getTable()
				.getSelectionIndex());
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}
	protected int getPixelSizeOfCharacter() {
		
		if(pixelSizeOfCharacter == -1) {
			if (shell == null)
				// get the pixel size for each character
				shell = new Shell(Display.getDefault());
			if (text == null)
				text = new Text(shell, SWT.NONE);
			text.setFont(this.getFont());
			if (gc == null)
				gc = new GC(text);
			pixelSizeOfCharacter = gc.textExtent("W").x;
		}
		return pixelSizeOfCharacter;
	}
	
	private GUIResponseType ListSegmentsRequest(){
		XMLDocument xmlDocument = null;
		int begOfGUISession = -1;
		String uuid ="";
		
		try {
			xmlDocument = new XMLDocument(new ListSegmentsRequestType(server,envName,dbdName).createXml());
		} catch (TTException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
		uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+GUISESSIONLEN);
		
		if(uuid.equalsIgnoreCase("\""))
			try {
				throw new TTException();
			} catch (TTException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
		SendRequestToMainframe req=new SendRequestToMainframe(server, new HashMap<String, Object>(), "opendb", true, xmlDocument);	
			if(req.getResult()==Status.CANCEL_STATUS)
				return null;

		if(req.getGuiResponseType().getReturnCode()!=0 || req.getGuiResponseType().getFunctionRC()!=0){
			showError(req);
			
		}
		return req.getGuiResponseType();
	}
	
	private boolean showError(SendRequestToMainframe req) {
		// TODO Auto-generated method stub
		
	//check for error condition upon clicking finish- navri01
	if(req.getGuiResponseType().getReturnCode()!=0|| req.getGuiResponseType().getFunctionRC()!=0){
		if(req.getGuiResponseType().getMessages() ==null){
			TT_ErrorDialog.openError(null, "Segment not found","Selected segment does not exist in the specified layout data set.", new Throwable("Selected segment does not exist in the specified layout data set."));
			return false;
		}
		for(int i=0;i<req.getGuiResponseType().getMessages().getMessage().size();i++){
			shortText.add(req.getGuiResponseType().getMessages().getMessage().get(i).getShortText());
			messageID.add(req.getGuiResponseType().getMessages().getMessage().get(i).getMessageId());
			if(req.getGuiResponseType().getMessages().getMessage().get(i).getMessageText()!=null)
			messageText.add(req.getGuiResponseType().getMessages().getMessage().get(i).getMessageText()+ "\n");
			else 
				messageText.add("");
		}
		for(int i=0;i<messageID.size();i++){
			messageIDFinal+= messageID.get(i)+" : " + shortText.get(i) + "\n" ;
			if(messageIDFinal.contains("CAWL101E")){
				title = "Information";
			}
			else 
				title = "Error";
			messageTextFinal+= messageText.get(i).substring(1, messageText.get(i).length()-2) + "\n";
			
		}
		TT_ErrorDialog.openError(null, title, messageIDFinal, new Throwable(messageTextFinal));
		return false;
	}	
	return true;
	}
	
	private void parseResponse(GUIResponseType req){
		List<SegmentInfoType> segList = req.getListSegmentsResponse().getSegmentInfoList().getSegmentInfo();
		fmSegments = new ArrayList<FileMasterSegment>();
		listOfAllSeg = new ArrayList<FileMasterSegment>();
		for(SegmentInfoType seg : segList){
			if(seg.getSegLvl() == 1){
				FileMasterSegment fmSeg = new FileMasterSegment();
				fmSeg.setName(seg.getSegName());
				fmSeg.setNumber(seg.getSegNum());
				fmSeg.setLevel(seg.getSegLvl());
				fmSeg.setSelectionConditions(mapOfAllSeg.get(seg.getSegName().toUpperCase())!=null ? mapOfAllSeg.get(seg.getSegName().toUpperCase()).getSelectionConditions() : "");
				fmSegments.add(fmSeg);
				listOfAllSeg.add(fmSeg);
				treeViewer.getTree().getColumn(1).setWidth(Math.max(fmSeg.getSelectionConditions().length()*getPixelSizeOfCharacter(),treeViewer.getTree().getColumn(1).getWidth()));
				treeViewer.getTree().getColumn(0).setWidth(Math.max((fmSeg.getLevel()+fmSeg.getName().length()+5)*getPixelSizeOfCharacter(), treeViewer.getTree().getColumn(0).getWidth()));
				treeViewer.refresh();
			}
			else{
				int level = 1;
				FileMasterSegment fmpSeg = fmSegments.get(fmSegments.size()-1);
				while(level < seg.getSegLvl()){
					if(fmpSeg.getChildSegments().size()==0 || level == seg.getSegLvl()-1)
						break;
					level = fmpSeg.getChildSegments().get(fmpSeg.getChildSegments().size()-1).getLevel();
					fmpSeg = fmpSeg.getChildSegments().get(fmpSeg.getChildSegments().size()-1);
				}
				FileMasterSegment fmSeg = new FileMasterSegment();
				fmSeg.setName(seg.getSegName());
				fmSeg.setNumber(seg.getSegNum());
				fmSeg.setLevel(seg.getSegLvl());
				//fmSegments.add(fmSeg);
				fmSeg.setSelectionConditions(mapOfAllSeg.get(seg.getSegName())!=null ? mapOfAllSeg.get(seg.getSegName()).getSelectionConditions() : "");
				fmpSeg.addChildSegments(fmSeg);
				listOfAllSeg.add(fmSeg);
				treeViewer.getTree().getColumn(1).setWidth(Math.max(fmSeg.getSelectionConditions().length()*getPixelSizeOfCharacter(),treeViewer.getTree().getColumn(1).getWidth()));
				treeViewer.getTree().getColumn(0).setWidth(Math.max((fmSeg.getLevel()+fmSeg.getName().length()+5)*getPixelSizeOfCharacter(), treeViewer.getTree().getColumn(0).getWidth()));
				treeViewer.refresh();
			}
		}
		
		treeViewer.setInput(fmSegments
				.toArray(new Object[fmSegments.size()]));
		
		treeViewer.refresh();
		treeViewer.getTree().select(treeViewer.getTree().getItem(0));
	}
	
	@Override
	public boolean canFlipToNextPage() {
		return isPageComplete();
	}
	private CRLClass createDummyDRL(String layoutInfo) {
		CRLClass crl = new CRLClass();
		final GUIResponseType xml;
		XMLDocument xmlDocument;
		try {
			xmlDocument = new XMLDocument(new ViewLayoutRequestType(server,
					layoutName,((FileMasterSegment)treeViewer.getTree().getSelection()[0].getData()).getName()).createXml());
			int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
    		if(uuid.equalsIgnoreCase("\""))
    			throw new TTException();
		} catch (TTException exception) {
			// TODO Auto-generated catch block
			exception.printStackTrace();
			return null;
		}
		SendRequestToMainframe req = new SendRequestToMainframe(server, new HashMap<String, Object>(), "opendb", true, xmlDocument);
		if(req.getResult() == Status.CANCEL_STATUS){
			return null;
		}
		// ParseResponse
		xml = req.getGuiResponseType();
		if (xml == null) {
			return null;
		}
		/*UnmarshalGUIResponse u = new UnmarshalGUIResponse();
		File f = new File("C:\\ViewLayout_QMODEL.xml");
		u.readAndUnmarshal(f);
		xml = u.getResponse();*/
		if (xml != null) {
			if(!showError(req))
				return null;
			CRLClass.Layout layouttoAdd;
			FileMasterSegment fmpSegment = ((FileMasterSegment) treeViewer
					.getTree().getSelection()[0].getData());
			layouttoAdd = crl.addLayout(layoutName, fmpSegment.getName());

			String formatChar;
			boolean has01Level = false;
			FieldListType flt = xml.getViewLayoutResponse().getFieldList();
			for (int i = 0; i < flt.getField().size(); i++) {
				FieldType ft = flt.getField().get(i);
				formatChar = ft.getFormatChar();
				if (ft.getLevel() == 01) {
					if (has01Level) {
						crl.setMultiple01Levels(true);
					} else {
						has01Level = true;
					}
				}
				layouttoAdd.addField(ft.getName(), ft.getLevel(),
						ft.getLevel() == 01, true, ft.getPosition() == null ? 0
								: ft.getPosition().intValue(), ft.getSigned() ==YorNType.Y ? ft
								.getFormatChar() +"S" : ft.getFormatChar(), ft.getIntegerLength() == null ? 0 : ft.getIntegerLength(), ft.getFractionLength()==null ? 0 : ft.getFractionLength(),ft.getLength() == null ? 0
								: ft.getLength().intValue(), CRLClass.NONE,
						CRLClass.NONE, "");

			}
			return crl;
			// }
			// }
		}
		return null;

	}
	
	public void AddLayoutSelCondition(String layoutSelCondition) {
		FileMasterSegment fmSegment = ((FileMasterSegment)treeViewer.getTree().getSelection()[0].getData());
		fmSegment.setIfSeg(mapOfAllSeg.get(fmSegment.getName()) == null ? true : mapOfAllSeg.get(fmSegment.getName()).isIfSeg());
		fmSegment.setSelectionConditions(layoutSelCondition);
		mapOfAllSeg.put(fmSegment.getName(),fmSegment);
		treeViewer.refresh();
		treeViewer.getTree().getColumn(1).setWidth(Math.max(layoutSelCondition.length()*getPixelSizeOfCharacter(),treeViewer.getTree().getColumn(1).getWidth()));
	}
	
	private void populateMap(ArrayList<FileMasterSegment> fmpSegments){
		mapOfAllSeg = new HashMap<String, FileMasterSegment>();
		for(FileMasterSegment fmps : fmpSegments){
			mapOfAllSeg.put(fmps.getName().toUpperCase(), fmps);
		}
		
	}
}
