/**
 * Copyright (c) 2016 CA, All rights Reserved.

 This software and all information contained therein is confidential and 
 proprietary and shall not be duplicated, used, disclosed or disseminated in any 
 way except as authorized by the applicable license agreement, without the 
 express written permission of CA. All authorized reproductions must be marked 
 with this language.  

 EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
 BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
 INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
 FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
 OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
 THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
 INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
 LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.FileMasterSession;
import com.ca.fmp.ims.view.databaselist.*;
import com.ca.testingtools.core.TT_TreeItem;

/**
 * 
 * @author navri01
 */
public class RemoveItemHandler extends AbstractHandler implements
		IElementUpdater {
	static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	private FMServerTreeModel model = FMServerTreeModel.getInstance();
	private TT_TreeItem toBeRemoved = null;
	private boolean dataListView = false;
	boolean remove = false;
	boolean deleteServer = false;
	String deleteItem = "";
	

	/**
	 * @param event
	 * @throws ExecutionException
	 */
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IPreferenceStore store = new ScopedPreferenceStore(new InstanceScope(),
				"com.ca.fmp.ims.common");
		String key = "CLOSING_VALUE";
		boolean showDiag = !store.getBoolean(key);
		IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
		ISelection sel = HandlerUtil.getCurrentSelection(event);
		if (!(sel instanceof IStructuredSelection))
			return null;
		IStructuredSelection selection = (IStructuredSelection) sel;
		Class<?> testClass = null;
		if (selection.isEmpty()) {
			return null;
		}
		if (((TT_TreeItem) (((IStructuredSelection) selection)
				.getFirstElement())).getValue().getAdapter(
				FileMasterServer.class) != null) {
			testClass = FileMasterServer.class;
			deleteServer = true;
			deleteItem = "server";
			dataListView = true;
		}  
		else
			return null;

		ArrayList<TT_TreeItem> list = new ArrayList<TT_TreeItem>(
				selection.size());
		Iterator<?> it = selection.iterator();
		while (it.hasNext()) {
			Object item = it.next();
			if (item instanceof TT_TreeItem) {
				TT_TreeItem treeItem = ((TT_TreeItem) item)
						.getParent(testClass);
				if (treeItem != null) {
					list.add(treeItem);
				}
			}
		}
		if (showDiag){
			if (list.size() == 0)
				return null;
			showDialog(list,selection,deleteItem,window,store,key);
		}
			else
			remove = true;
		if (remove) {
			for (TT_TreeItem value : list) {
				if (dataListView == true && (FileMasterServer) value.getServer() instanceof FileMasterServer) {
					deleteSessions(value);
					toBeRemoved = model.removeItem(value);
					refreshDatabaseListView(deleteServer,window);
				}  

			}
		}
		
		model.save();
		return null;
	}
	private void showDialog(ArrayList<TT_TreeItem> list,IStructuredSelection selection,String deleteItem,IWorkbenchWindow window,IPreferenceStore store,String key){
			String question = null;
			if (list.size() > 1) {
				Object itemToBeRemoved = list.get(0);
				if (((TT_TreeItem) itemToBeRemoved).getValue() instanceof FileMasterServer) {
					question = String
							.format("Do you want to remove these %d items? All items associated with these servers will be removed from the Database List view.",
									selection.size());
				} else
					question = String
							.format("Do you want to remove these %d items", selection.size()); //$NON-NLS-1$
			} else {
				Object target = list.get(0);
				if (((TT_TreeItem) target).getValue() instanceof FileMasterServer) {
					question = String
							.format("Do you want to remove %s : %s? All items associated with this server will be removed from the Database List view.", deleteItem, target.toString()); //$NON-NLS-1$
				} else
					question = String
							.format("Do you want to remove %s : %s ", deleteItem, target.toString()); //$NON-NLS-1$
			}
			Shell shell = window.getShell();
			shell.setMinimized(false);
			shell.forceActive();
			shell.forceFocus();
			final String title = "Confirm Remove";
			String toggleMessage = "Always remove items without this prompt";
			MessageDialogWithToggle result = MessageDialogWithToggle
					.openYesNoQuestion(null, title, question, toggleMessage,
							false, store, key);
			int returncode = result.getReturnCode();
			store.setValue(key, result.getToggleState());
			remove = returncode == MessageDialogWithToggle.OK
					|| returncode == 2 /* YES */;
			if (returncode == 3 || returncode == -1) {  /* NO */
				remove= false;
			}
		} 
	
	private void refreshDatabaseListView(boolean deleteServer,IWorkbenchWindow window){
	try {
		final IWorkbenchPage page = window.getActivePage();	
			IViewPart view = page.showView(DatabaseListView.ID);
			if (view instanceof DatabaseListView) {
				TreeViewer viewer = ((DatabaseListView) view).getViewer();
				if (viewer != null) {
					if (deleteServer) {
						Object[] expandedElements = viewer
								.getExpandedElements();
						viewer.setInput(model.getServers());
						viewer.setExpandedElements(expandedElements);
					} else
						viewer.refresh(true);
				}

				TT_TreeItem selectionIndex = toBeRemoved;
				viewer.setSelection(
						new StructuredSelection(selectionIndex), true);
				view.setFocus();
			
		}

	} catch (final PartInitException e) {
	}
}
	private void deleteSessions(TT_TreeItem value) {
		int count = 0;
		FileMasterServer server = (FileMasterServer) value.getServer();
		while (count < model.getSessions(server).size()) {
			model.getSessions(server).get(count);
			FileMasterSession.cancelOneSession(server);
		}

	}

	@SuppressWarnings("rawtypes")
	@Override
	public void updateElement(UIElement element, Map parameters) {
	}

}
