/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.handlers;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.Constants;
import com.ca.fmp.ims.model.generated.CursorType;
import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.EditModeType;
import com.ca.fmp.ims.model.generated.SegmentFieldType;
import com.ca.fmp.ims.model.generated.YorNType;
import com.ca.fmp.ims.view.editor.CharFormatMode;
import com.ca.fmp.ims.view.editor.EditingSupportFileMasterIMS;
import com.ca.fmp.ims.view.editor.EditorView;
import com.ca.fmp.ims.view.editor.FormatMode;
import com.ca.fmp.ims.view.editor.SingleRecordFormatMode;

/**
 * 20140909
 * - yesterday we removed the subStringBeginIndex and subStringEndIndex
 *   variables.  After some test today, I think we were wrong to do so.
 *   The use case where this is failing is when we do a Horizontal Scroll 
 *   right after an edit.  When that happens, the subStringBeginIndex gets 
 *   updated before we formulate the response to mainframe.
 *   
 * 20140908 carel06
 * - the subStringEndIndex was off (needs to be 0 based instead of 1 based).
 *   removed the local variable subStringBeginIndex and subStringEndIndex and
 *   just get it from the FormatMode class.  subStringBeginIndex
 *   and subStringEndIndex
 *   
 * 20140903 carel06
 * - changed local variables that were protected into private, there's no reason 
 *   to make it protected.
 * - removing most logging messages, right now, it's too verbose.
 * - modified the constructor to take in less paramters.  Only the segmentType
 *   element is changing so I just updated those with the setters from 
 *   FileMasterPlusKeyListener
 * - made all static final variables as "public"
 *   
 * 20140902 carel06
 * I'm created the FileMasterPlusKeyListener class from the EditingSupportFileMaster
 * class.  The EditingSupportFileMaster class contained all the logic to support
 * the editing features (overtype/delete). 
 * - removed focusLost() // should be part of FocusListener
 * - removed focusGained() // should be part of FocusListener
 * - removed getCellEditor() // should be part of EditingSupport
 * - removed canEdit() // should be part of EditingSupport
 * - removed getValue() // should be part of EditingSupport
 * - removed setValue() // should be part of EditingSupport
 * - removed sendFileMasterRecordFieldUpdateRequestToMainFrame() // should be part of EditingSupport
 * - removed makeEditorDirty() // should be part of EditingSupport
 * - removed updateView() methods // it really wasn't doing anything so I removed it.
 * - removed setupFileMasterRecordRequestMessage() // should be part of EditingSupport
 * - replaced Constants.LINE_SEPARATOR with local variable
 * - replaced Constants.EMPTY_SPACE_IN_CHAR with local variable
 * - removed getMaxLengthP() // passed value into constructor instead
 * - removed getProtectedListInCharData() // constructor parameter will provide this values
 * - removed getProtectedListInHexData() // constructor parameter will provide this values 
 * - replaced protectedCursorPositionList with protectedValues
 * - removed getSubStringEndIndex() // get value from keyPress method
 * - removed getSubStringBeginIndex() // get value from keyPress method
 * - removed every instance of where Constants class is being used.
 * - copied class TextCellEditorFileMaster from MVS package
 * - added recordPosition and recordId local variable // get value from constructor
 * - removed getFormatMode(), formatMode variable is being passed in the constructor
 * - removed fileMasterRecord // no need for that since we are trying to make it model independent
 * - commented out setCursor() // we don't need it right now, will handle it in the future
 * - commented out positionCursorToNextLocation // we don't need it right now, will handle it in the future.
 * - removed local variables columnIndex and columnIndexOnTable, MF mode not being used
 * - removed reference TextCellEditorFileMaster, TextCellEditor will do just fine.
 * - removed isSubstring from constructor parameter, not being used.
 * - removed getTableViewer() - not being used.
 * 
 * 20130814 carel06
 * Having trouble with the BaseKeyListener class accessing the correct FileMasterRecordField.
 * To resolve this issue, I removed the BaseKeyListener class and just implemented the behavior 
 * inside this class.  Now, when there is a keyPress or keyRelease, I have access to the 
 * FileMasterRecord and FileMasterRecordField variables.
 * 
 * @author carel06
 */
public class FileMasterPlusKeyListener implements KeyListener {

	public static final String LINE_SEPARATOR = "\r\n";
	public static final String EMPTY_SPACE_IN_CHAR = " ";
	public static final int EMPTY_SPACE_TO_INSERT = 0x20;
	public static final String MFREQUEST = "MFRequest";
	public static final String ODOCHANGE = "EditODOChange";
    
	// 20140902 carel06
	// created maxLengthP variable so that it can be model independent 
	// (FileMasterRecordField vs. SegmentField)
	// we shouldn't care where it comes from
	private int maxLengthP = -1;

	// 2014/09/09 carel06
	// created this variables since I wanted this class to be 
	// independent of the model (SegmentType vs. FileMasterRecord)
	private String charData = null;
	private String hexData1 = null;
	private String hexData2 = null;
	private SegmentFieldType segmentFieldType = null;
    
	

	// 2014/09/09 carel06
	// added this variables back because we want it to remain constant.
	// the use case we are trying to fix is when the person clicks on
	// a segment and then does a horizontal scroll.  We don't want the 
	// subStringBeginIndex to change before formulating a response to mainframe.
	private int subStringBeginIndex = -1;
	private int subStringEndIndex = -1;
    
	// 20140902 carel06
	// create protectedValues variable so that it can be model independent
	// (FileMasterRecordField vs. SegmentField)
	// we shouldn't care where it comes from
	// these are positions that can't be modified
	// include lkeys and protected ranges
	// hexData and charData portion.
	// 0 based
    private ArrayList<Integer> protectedValues = new ArrayList<Integer>();
    private ArrayList<Integer> keyValues = new ArrayList<Integer>();
    
	
	private Logger log = Logger.getLogger(FileMasterPlusKeyListener.class.getName());
	private FormatMode formatMode;
	
	// this variable is used to story the fileMasterRecord that
	// is currently being edited.  Useful when Focus is lost and 
	// we need to update the record.
	private TextCellEditor textCellEditorFileMaster; 
	
	private static  boolean insertToggleFlag = false; // determines if we are in insert mode
	
	// when pasting, duplicate paste was happening.
	// need to get the value from keypress and pass 
	// it to keyRelease pasting function
	private String textText = null;
	private Point textSelection;
	private int textCaretPosition;
	private int textCaretPositionRowIndex; // which row is the caret position in.  In CharMode, there are three rows.
	private int textCaretPositionOffset; // the cursor position based on the row.
	private int textCaretPositionTrue; // the cursor position based on the model.
    private String[] textFromWidgetSplitIntoRows;
    private int capacity;
    
	// made this into a member variable vs. a local variable
	// because I need it accessible for the keyRelease() for the 
	// handling of paste operation.  We want to work on text 
	// before it has been acted upon.
	private Text textFromKeyPressed;
	
	private static String clipboardDataToBePasted = null;
	private String asciiCode = "";
	private String extendedASCIIChars = "ÇüéâäàåçêëèïîìÄÅÉæÆôöòûùÿÖÜø£Ø×ƒáíóúñÑªº¿®¬½¼¡«»░▒▓│┤�?ÂÀ©╣║╗�?¢¥�?└┴┬├─┼ãÃ╚╔╩╦╠�?╬¤ð�?ÊËÈı�?Î�?┘┌█▄¦Ì▀ÓßÔÒõÕµþÞÚÛÙý�?¯´≡±‗¾¶§÷¸°¨·¹³²■ ";
    
	private EditorView editorView;
	
	/**
	 * 
	 * @param tableViewer
	 * @param formatMode
	 * @param segmentFieldType 
	 * @param columnIndex Column indexed starts at 1 (not 0-based)
	 * @param subStringBeginIndex start index for this column
	 */
	public FileMasterPlusKeyListener(EditorView editorView, FormatMode formatMode, TextCellEditor textCellEditor, String charData, String hexData1, String hexData2, SegmentFieldType segmentFieldType) {
		this.formatMode = formatMode;
		this.textCellEditorFileMaster = textCellEditor;	
        
        // we initialize the subStringBeginIndex and subStringEndIndex
        // during the constructor since we might not have a chance to 
        // initialize this variables during the keyPress.
        // use case would be the person starts editing the TextCellEditor
        // but instead of pressing a key, user goes and pressed the
        // horizontal scrollbar instead.
        subStringBeginIndex = formatMode.getSubstringBeginIndex();
        subStringEndIndex = formatMode.getSubstringEndIndex();
        log.info("subStringBeginIndex: " + subStringBeginIndex + " subStringEndIndex: " + subStringEndIndex);
        this.charData = charData;
        this.hexData1 = hexData1;
        this.hexData2 = hexData2;
        this.segmentFieldType = segmentFieldType;
        // 2014/09/11 carel06
        // need to add editorView variable to update the status bar
        // and determine which mode we are in.
        this.editorView = editorView;
        
	}
	
	/**
     * 
	 * Set the cursor position
	 * Need to make it protected so that it can be overwritten
	 * for SRM which only uses srfField variable.
     * 
	 * @param fileMasterPlusText
	 */
	protected void setCursor(Text textFromKeyPressed) {		
		if (textFromKeyPressed != null) {
			int positionInText = textFromKeyPressed.getCaretPosition(); 
			int positionInRow = positionInText;
			int columnEnd = textFromKeyPressed.getText().length();
			if (formatMode.getEditorView().getHexToggled()== YorNType.Y & formatMode.getEditorView().getDisplayMode() == DisplayModeType.C) {
				columnEnd = columnEnd / 3;
				}	

			while (positionInRow > columnEnd){
				positionInRow = positionInRow - columnEnd - 1; 
			}
			positionInRow = positionInRow + formatMode.getSubstringBeginIndex();
			CursorType fmiCursor = editorView.getCursor();
			fmiCursor.setCursorPosition(positionInRow);
//			fmiCursor.setSegid(segmentType.getSegid());
			editorView.setCursor(fmiCursor);
		}
	}
	
	/**
	 * If you want to process key events before the text is modified,
	 * put your key event processing handlers here.
	 */
	@Override
	public void keyPressed(KeyEvent keyEvent) {	
		// navri01- Defect 3200
		//show information when try to edit variable segment at key press.
		if(segmentFieldType.getSegmentLength() == YorNType.Y) {
            MessageDialog.openInformation(null, "Information", "Length cannot be changed\nChanging the length of a variable segment is not allowed.");
            return;
		}
        subStringBeginIndex = formatMode.getSubstringBeginIndex();
        subStringEndIndex = formatMode.getSubstringEndIndex();
        log.info("subStringBeginIndex: " + subStringBeginIndex + " subStringEndIndex: " + subStringEndIndex);
        
		checkForValidCharacter(keyEvent);
		getAsciiCode(keyEvent);
        
        // carel06 - 2014/12/04
		// Defect 3223
		// we need to be able to do this for SingleRecordFormatMode as well.
		// In Browse mode, if there is another key than traverse do not allow it
		if (editorView.getEditMode() == EditModeType.B | YorNType.Y == segmentFieldType.getKeyPart()) {
			if(formatMode instanceof CharFormatMode) {
				CharFormatMode xFormatMode = (CharFormatMode) formatMode;
				handleNavigationKeysInBrowseMode(keyEvent, xFormatMode.getEditingSupportFileMasterIMS());
			} else {
				SingleRecordFormatMode xFormatMode = (SingleRecordFormatMode) formatMode;
				handleNavigationKeysInBrowseMode(keyEvent, xFormatMode.getEditingSupportFileMasterIMS());				
			}
		}
		
		if(keyEvent.doit == false) {
			// the same key event goes to all the same BaseKeyListener instance.
			// if it's already handled, don't continue to repeat it.
			// an issue was happening where I have 3 BaseKeyListeners active
			// it the keyEvent was going to all the listeners.. This was move my arrow key
			// three times instead of one.
			return;
		}
		if(keyEvent.keyCode == 16777225) {
			log.info("INSERT KEY pressed");
			EditingSupportFileMasterIMS.isOvertypeMode = !EditingSupportFileMasterIMS.isOvertypeMode;
			if(editorView.getEditMode() == EditModeType.E)
				((StatusLineContributionItem) editorView.getViewSite().getActionBars().getStatusLineManager().find("insertOrOvertype")).setText(EditingSupportFileMasterIMS.isOvertypeMode ? "Overtype" : "Insert");
		} else if(keyEvent.keyCode == 16777226) {
			log.info("F1 key pressed");
			return;
		} else if(keyEvent.keyCode == SWT.PAGE_DOWN) {
//          disable PageDown key in Editor mode, shortcut: CTRL + PAGEDOWN is available for a user			
//			textCellEditorFileMaster.deactivate();
			
//			Rectangle rect = tableViewer.getTable().getClientArea();
//			int itemHeight = tableViewer.getTable().getItemHeight();
//			int headerHeight = tableViewer.getTable().getHeaderHeight();
//			int recordsOnScreen = (rect.height - headerHeight + itemHeight - 1) / itemHeight;
//			
//			tableViewer.getTable().setSelection(tableViewer.getTable().getTopIndex() + recordsOnScreen - 2);
//			if(tableViewer.getTable().getItem(tableViewer.getTable().getTopIndex() + recordsOnScreen - 2).getData() == null){
//				tableViewer.setSelection(null);
//			}
			
			keyEvent.doit = false;
			return;
		}
			
		if(keyEvent.keyCode == SWT.PAGE_UP) {
//          disable PageUp key in Editor mode, shortcut: CTRL + PAGEUP is available for a user  
//			textCellEditorFileMaster.deactivate();
			
//			tableViewer.getTable().setSelection(tableViewer.getTable().getTopIndex());
			
			keyEvent.doit = false;
			return;
		}
		
		// carel06 - 20130909 - 2736
		// if the end-user continues to hold ctrl-x or ctrl-a
		// we have to ignore it.
		ignoreSelectAllEvent(keyEvent);
		
		// 2014/09/15 carel06
		// Defect 3134
        // Need to ingore keypress with the statemask of CTRL.
		// Handling Paste (CTRL-V) is done with the CustomPasteHandler class
		// Handling Copy (CTRL-C) is done automatically.  Not handled
		// in KeyListener interface.  
		// I tested the copy feature and it seems to work.
		if((keyEvent.stateMask & SWT.CTRL) == SWT.CTRL) {
            log.info("CTRL key pressed, ignoring it");
			keyEvent.doit = false;
            return;
		}
		
		// handle the insert button
		// by just reversing the insertToggleFlag
		if(keyEvent.keyCode == SWT.INSERT) {
			insertToggleFlag = !insertToggleFlag;
			keyEvent.doit = false;
			return;
		}
		
		initializeVariables((Text) keyEvent.getSource());
		
//		log.log(Level.INFO, 
//				"Pre Text  :" + textText + "\n" + 
//				"Position  :" + textCaretPosition + "\n" + 
//				"KeyEvent-->\n" +  
//				"character :" + keyEvent.character + "\n" + 
//				"code      :" + keyEvent.keyCode + "\n" +
//				"location  :" + keyEvent.keyLocation + "\n" +
//				"stateMask :" + keyEvent.stateMask + "\n" +
//				"time      :" + keyEvent.time + "\n" +
//				"hashCode  :" + keyEvent.hashCode() + "\n" +
//				"data      :" + keyEvent.data + "\n" +
//				"doit      :" + keyEvent.doit + "\n");
		
		
		// 20130904 carel06 2730
		// had to get the clipboard data in keyPressed vs. in keyReleased.
		// get the text to put in the record from the clipboard
		TextTransfer transfer = TextTransfer.getInstance();
		Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay());
		clipboardDataToBePasted = (String) clipboard.getContents(transfer);
		
		// characterToBeReplace is a variable I will be using in the 
		// future to make sure I am not deleting the "\r" or "\n"
		// for a field.
				
		// carel06 - Defect 2391
		// CTRL-Z (UNDO) is not recognized for now.
		if (Character.toUpperCase((char)keyEvent.keyCode) == 'Z' && (keyEvent.stateMask & SWT.CTRL) == SWT.CTRL){ 
			keyEvent.doit = false;
		} 

		// up arrow key pressed
//		if(keyEvent.keyCode == 16777217) {
//			log.log(Level.INFO, "up arrow key pressed");		
//			keyEvent.doit = false;
//			return;
//		}
		
		// down arrow key pressed
//		if(keyEvent.keyCode == 16777219) {
//			log.log(Level.INFO, "down arrow pressed");
//			keyEvent.doit = false;
//			return;
//		}
		

		// left arrow key pressed
		// carel06 2013-06-21
		// added the stateMask clause since if the shift key is pressed with thte 
		// right arrow key, it's a totally different behavior
		if(keyEvent.keyCode == 16777219 && keyEvent.stateMask == 0) {
			if(textCaretPositionOffset == 0) {
				keyEvent.doit = false;
				return;
			}
			if(textCaretPosition == 0) {
				keyEvent.doit = false;
				return;
			}
			moveToPreviousCharacter(textFromKeyPressed, textFromKeyPressed.getCaretPosition(), getProtectedPositions());
//			positionCursorToNextLocation(textFromKeyPressed.getCaretPosition());
			keyEvent.doit = false;
			return;
		}
		
		// carel06 - 2492
		// move this if clause before the checking of isProtected
		// no need to check if the next key is protected if you are going to work on the
		// previous character
		// ---
		// if pressing the BS key in both insert mode and overtype mode
		// the string is reduce by one, at the tail env of the protected mode or end of file.
		if(keyEvent.keyCode == SWT.BS ) {
			int selectionCount = textFromKeyPressed.getSelectionCount();
			
			// 2014/09/11 carel06
			// Just added the extra condition that selectionCount == 0
			// If there are multiple characters selected for delete
			// then we just can't ignore the BS key.  We have to 
			// handle deleting the characters.
			//int caretPosition = textFromKeyPressed.getCaretPosition();
			// if trying to do a backspace at the 0'th position.. Can't be done.
			// just ignore the backspace if you are already in the 0th position.
			if(textCaretPositionOffset == 0 && selectionCount == 0) {
				keyEvent.doit = false;
				return;
			}
			
			// trying to backspace a protected data, denied do nothing. 
			// do not move the cursor.
			if(getProtectedPositions().contains(new Integer(textCaretPositionOffset + subStringBeginIndex - 1)) && selectionCount == 0) {
				keyEvent.doit = false;
				return;
			} 

            
			// carel06 - 20130905 - 2674
			// we also enable deletion of selection using the bs key
			if(selectionCount > 0) {
				// delete the selection
				handleDeleteKeyOnSelection(textFromKeyPressed, getProtectedPositions());
			} else {
                
				// When the BS key is pressed, what are the behaviors?
				// You delete the character at caretPosition - 1. 
				// This shifts everything from the right of the cursor position to the left by 1.
				// If it is in overtyping mode, you just shift stuff up to the protected range mode of end of line
				// If in is in insert mode, you delete at the end of the line
				handleDeleteKey(textFromKeyPressed, textCaretPositionTrue-1, getProtectedPositions());
			}
			keyEvent.doit = false;
			return;
		}
		
		// right arrow key pressed
		// carel06 2013-06-21
		// added the stateMask clause since if the shift key is pressed with thte 
		// right arrow key, it's a totally different behavior
		if(keyEvent.keyCode == 16777220 && keyEvent.stateMask == 0) {
			isEndOfRecordField(keyEvent);
			if(keyEvent.doit == false) {
				return;
			}
			// just the right arrow key is being pressed
			moveToNextCharacter(textFromKeyPressed, textFromKeyPressed.getCaretPosition(), getProtectedPositions());
//			positionCursorToNextLocation(textFromKeyPressed.getCaretPosition());
			keyEvent.doit = false;
			return;
		}
		
		// handle the event if the user presses the delete key
		if(keyEvent.keyCode == SWT.DEL) {			


			int selectionCount = textFromKeyPressed.getSelectionCount();
			if(selectionCount > 0) {
				// delete the selection
				handleDeleteKeyOnSelection(textFromKeyPressed, getProtectedPositions());
			} else {	
				
				// trying to delete a protected data, denied do nothing. 
				// do not move the cursor.
				if(getProtectedPositions().contains(new Integer(textCaretPositionTrue))) {
					keyEvent.doit = false;
					return;
				} 
				
				Character characterToBeReplaced = getCharacterFromTextControl(textText);
				if(characterToBeReplaced != null && (characterToBeReplaced == '\r' || characterToBeReplaced == '\n')) {
					keyEvent.doit = false;
					return;
				}
				if(characterToBeReplaced == null) {
					log.warning("characterToBeReplaced is null");
//					keyEvent.doit = false;
					return;
				}
				
				isEndOfRecordField(keyEvent);
				if(keyEvent.doit == false) {
					return;
				}
				// delete the next key after the cursor
				// we need to stay at the same caretPosition
				handleDeleteKey(textFromKeyPressed, textCaretPositionTrue, getProtectedPositions());		
			}
			keyEvent.doit = false;
			return;
		}
		
		// had to add the doit flag check b/c
		// if it wasn't there, the handleInsertMode/handleOvertype mode
		// would also be handling the BS/INSERT/DEL key.
		if(keyEvent.character != '\0' && keyEvent.doit == true) {
			//depil01 - defect 2928 - If we have some characters selected they must be deleted before inserting new characters
			//and the cursor position(textCaretPositionOffset) needs to be adjusted if the selection is done from left to right
			if(textFromKeyPressed.getSelectionCount() > 0) {
				handleDeleteKeyOnSelection(textFromKeyPressed, getProtectedPositions());
				if(textCaretPositionOffset == textSelection.y) {
					textCaretPositionOffset = textCaretPositionOffset - Math.abs(textSelection.x - textSelection.y);
				}
			}//end
			isEndOfRecordField(keyEvent);
			if(keyEvent.doit == false) {
				return;
			}
			// carel06 - 2013-06-21
			// had to put this below the "left and right arrow key pressed"
			// the priority is to do the traversals when editing first before any other 
			// actions.
			// if you are in overtype mode,
			// we don't want to overwrite the carriage return
			Character characterToBeReplaced = getCharacterFromTextControl(textText);
			if(characterToBeReplaced != null && (characterToBeReplaced == '\r' || characterToBeReplaced == '\n') && insertToggleFlag == false) {
                // trying to overwrite a carriage return, don't do it
				keyEvent.doit = false;
				return;			
			}	
			//@parra12: Commenting out the following line of code because selection insert fails here.
			/*if(characterToBeReplaced == null) {
                // characterToBeReplaced is null
//				keyEvent.doit = false;
				return;
			}*/
			
			// trying to modify a protected character, denied
			//navri01: i added getRowBased condition to make sure we allow editing hex data 1& 2 to fix defect 2806
            // 20141006 carel06
			// Added extra condition that the textCaretPositionRowIndex must be 0.
			// This way, when we are in hex mode and user is overtyping hex value,
			// it won't escape.  Use is allowed to edit hex even if it is considred
			// protected.
			if(getProtectedPositions().contains(new Integer(textCaretPositionOffset + subStringBeginIndex))) {
                // trying to overwrite a protected mode, don't do it
				keyEvent.doit = false;
				return;
			} 
			
			handleNonNullCharacter(keyEvent);
			return;
		}
			
//		log.log(Level.INFO, 
//				"Post Text  :" + text.getText() + "\n" + 
//				"Position  :" + text.getCaretPosition() + "\n" + 
//				"KeyEvent-->\n" +  
//                "character :" + keyEvent.character + "\n" + 
//                "code      :" + keyEvent.keyCode + "\n" +
//                "location  :" + keyEvent.keyLocation + "\n" +
//                "stateMask :" + keyEvent.stateMask + "\n" +
//                "time      :" + keyEvent.time + "\n" +
//                "hashCode  :" + keyEvent.hashCode() + "\n" +
//                "data      :" + keyEvent.data + "\n" +
//                "doit      :" + keyEvent.doit + "\n");
	}

	public void initializeVariables(Text text) {
		textFromKeyPressed = text;
		textText = textFromKeyPressed.getText();
		textCaretPosition = textFromKeyPressed.getCaretPosition();
		textSelection = textFromKeyPressed.getSelection();
		textCaretPositionRowIndex = getRowIndexBasedOnText(textFromKeyPressed, textFromKeyPressed.getCaretPosition());
		textCaretPositionOffset = getRowPositionBasedOnText(textFromKeyPressed, textFromKeyPressed.getCaretPosition());
		textCaretPositionTrue = textCaretPositionOffset + subStringBeginIndex;
		textFromWidgetSplitIntoRows = textFromKeyPressed.getText().split(LINE_SEPARATOR);
	}

	private void checkForValidCharacter(KeyEvent keyEvent) {
		byte[] nonPrintChars = null;
		try {
			nonPrintChars = "bdfghijkloprstuy".getBytes("ISO-8859-1");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		
		if (((keyEvent.stateMask & SWT.CTRL) == SWT.CTRL)) {
			for(int i = 0; i < nonPrintChars.length; i++) {
				if(nonPrintChars[i] == keyEvent.keyCode) {
					keyEvent.doit = false;
					return;
				}
			}
		}
		
		byte[] nonPrintCharsAltGr = null;
		try {
			nonPrintCharsAltGr = "e=".getBytes("ISO-8859-1");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		if (((keyEvent.stateMask & SWT.ALT) == SWT.ALT)) {
			for(int i = 0; i < nonPrintCharsAltGr.length; i++) {
				if(nonPrintCharsAltGr[i] == keyEvent.keyCode) {
					keyEvent.doit = false;
					return;
				}
			}
		}
	}
	
	private void getAsciiCode(KeyEvent keyEvent) {
		if (((keyEvent.stateMask & SWT.ALT) == SWT.ALT)) {
			if(keyEvent.character >= '0' && keyEvent.character <= '9') {
				asciiCode += keyEvent.character + "";
				keyEvent.doit = false;
			}
		}

	}

	/**
	 * 20130905 - carel06 - 2735
	 * when trying to return a character from position not available, return null
	 * 
	 * If trying to extract a character from a text control
	 * that doesn't have that character availabe, because the text control length
	 * is too short, just replace it with a space.
	 * 
	 * The use case for this is that I deleted the cust-name field so that it didn't have any characters.
	 * Mainframe response is just an empty CharData.  Even though max-length-p is 15, it returns null.
	 * 
	 * @return a character from the text control, if it cannot access return a space.
	 */
	private Character getCharacterFromTextControl(String value) {
		try {
			return new Character(value.charAt(textCaretPosition));
		} catch (StringIndexOutOfBoundsException e) {
			// return null instead if it cannot be retrieved
			log.warning("StringIndexOutOfBoundsException handled --> textCaretPosition: " + textCaretPosition + " textText: " + value);
			return null;
		}
	}

	protected void isEndOfRecordField(KeyEvent keyEvent) {
		int currentCursorPositionInRecordField = textCaretPositionOffset + subStringBeginIndex;
		// carel06 - 20141027
		// in SF mode, you can enter as many characters as you want
		// as long as it fits the text widget
		// 2763 - carel06 - 20130913
		// had to change from currentCursorPositionInRecordField > maxLength to currentCursorPositionInRecordField >= maxLength (added equals sign)
		// when trying to edit a record field of 6, i would always get an extra character
		// that didn't need to be there.
		if(currentCursorPositionInRecordField >= maxLengthP && formatMode instanceof CharFormatMode) {
            // forward acting and already at the end of the record field, do nothing
			keyEvent.doit = false;
			return;
		}
		if(currentCursorPositionInRecordField > subStringEndIndex) {
            // forward acting and already at the end of the record field, have reached end of substring, do nothing
			keyEvent.doit = false;
			return;
		}
	}

	/**
     * 20131008 carel06 Refactored Paste.  Paste is being handled by CustomPasteHandler.
     * 
	 * If yo want to process key events after the text is modified,
	 * put your key event processing handlers here.
	 */
	@Override
	public void keyReleased(KeyEvent keyEvent) {
		if(keyEvent.doit == false) {
			// the same key event goes to all the same BaseKeyListener instance.
			// if it's already handled, don't continue to repeat it.
			// an issue was happening where I have 3 BaseKeyListeners active
			// it the keyEvent was going to all the listeners.. This was move my arrow key
			// three times instead of one.
			return;
		}
		if((keyEvent.stateMask & SWT.ALT) == SWT.ALT && keyEvent.character == '\0' && !asciiCode.isEmpty()) {
			if(Integer.parseInt(asciiCode) < 128) {
				keyEvent.character = (char)Integer.parseInt(asciiCode);
			} else if(Integer.parseInt(asciiCode) >= 128 && Integer.parseInt(asciiCode) < extendedASCIIChars.length() + 128){
				keyEvent.character = extendedASCIIChars.charAt(Integer.parseInt(asciiCode) - 128);
			}
			asciiCode = "";
		}
		
		setCursor(textFromKeyPressed);

//		log.log(Level.INFO, "Pre Text  :" + text.getText() + "\n"
//				+ "Position  :" + text.getCaretPosition() + "\n"
//				+ "KeyEvent-->\n" + "character :" + keyEvent.character + "\n"
//				+ "code      :" + keyEvent.keyCode + "\n" + "location  :"
//				+ keyEvent.keyLocation + "\n" + "stateMask :"
//				+ keyEvent.stateMask + "\n" + "time      :" + keyEvent.time
//				+ "\n" + "hashCode  :" + keyEvent.hashCode() + "\n"
//				+ "data      :" + keyEvent.data + "\n" + "doit      :"
//				+ keyEvent.doit + "\n");

		ignoreSelectAllEvent(keyEvent);
	}


	
	/**
	 * carel06 - Defect 2736
	 * CTRL-A (Select All) is not recognized for now
	 */
	private void ignoreSelectAllEvent(KeyEvent keyEvent) {
		if (Character.toUpperCase((char)keyEvent.keyCode) == 'A' && (keyEvent.stateMask & SWT.CTRL) == SWT.CTRL){ 
            // Ctrl+A pressed --> ignore for now
			Text text = (Text) keyEvent.getSource();
			text.setText(textText);
			text.setSelection(textCaretPosition);
			keyEvent.doit = false;
		}
	}

	/**
	 * Exposing the handleNonNullCharacter to child classes.
	 * The reason for this is that in Character Mode Key Column,
	 * only a digit is accepted.  I want to have a check for this in 
	 * one of the child classes.
	 * 
	 * @param keyEvent
	 */
	protected void handleNonNullCharacter(KeyEvent keyEvent) {	
		Text text = (Text) keyEvent.getSource();
		
		// carel06 - defect 3017
		// if acting on a text field which has some selection
		// treat it as if we are in insert mode.
		if(insertToggleFlag || textSelection.x != textSelection.y) {
			handleInsertMode(keyEvent, text, text.getCaretPosition());
		} else {
			handleOvertypeMode(keyEvent, text, text.getCaretPosition());
		}
//		positionCursorToNextLocation(text.getCaretPosition());
		keyEvent.doit = false;
	}

	/**
	 * 20140902 carel06
	 * Right now, we don't need to handle cursor position.
	 * 
	 * TODO need to confirm if this is the same behavior for all the 3 modes
	 * @param caretPosition
	 */
//	protected void positionCursorToNextLocation(int caretPosition) {
//		if(formatMode instanceof CharFormatMode) {
//			// need to position the cursor to the next location
//			FMPCursor cursor = formatMode.getEditorView().getCursor();
//			
//			if(EditorWizardPageOne.dataSet instanceof FMPVSAMDataset) {
//				if(!((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength().isEmpty()){
//					int cursorOffset = caretPosition+Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getLength())+Integer.parseInt(((FMPVSAMDataset)EditorWizardPageOne.dataSet).getOffset())-1;
//					log.log(Level.INFO, "clicked on data column: " + cursor.getRecordNumber() + " cursorOffset: " + cursorOffset);
//					if(cursor!=null) {
//						cursor.setCursorOffset(cursorOffset);					
//						formatMode.getEditorView().setCursor(cursor);
//					}
//				} else{
//					// carel06 20130730
//					// we no longer support subcolumns, hence dataColumnNumber
//					// no longer used
//					// cursor.setCursorOffset(((dataColumnNumber)*1000)+caretPosition);
//					cursor.setCursorOffset(caretPosition);
//					formatMode.getEditorView().setCursor(cursor);
//				}
//			} else {
//				// carel06 20130730
//				// we no longer support subcolumns, hence dataColumnNumber
//				// no longer used
//				// cursor.setCursorOffset(((dataColumnNumber)*1000)+caretPosition);
//				cursor.setCursorOffset(caretPosition);
//				formatMode.getEditorView().setCursor(cursor);
//			}
//		}
//		// need to position the cursor to the next location
//		formatMode.getEditorView().getCursor().setCursorOffset(caretPosition);
//	}
	
	/**
	 * determine which is closer, a protected character or the end of the line
	 * based on the caretPositon 
     * 
	 * @return the cursor position (not the offset) that contains the last place to type/paste 
	 */
	protected int getLastCursorPositionForDeletion(String source, int caretPosition, ArrayList<Integer> characterPositionsThatCantBeModified) {
		// 2014/09/08 carel06
		// I'm accessing the substring index directly from FormatMode class.
		int terminatingCharacterPosition = Math.min(maxLengthP, formatMode.getSubstringEndIndex());

		// carel0 2014/10/17
		// if there are protected values, shifting only matters in CharData
		// not in HexData1 or HexDAta2
		int currentPositionThatIncludesOffset = caretPosition + formatMode.getSubstringBeginIndex();
		for(Integer x : characterPositionsThatCantBeModified) {
			if(x >= currentPositionThatIncludesOffset && x <= formatMode.getSubstringEndIndex()) {
				// found the closet terminating character
				terminatingCharacterPosition = x;
				break;
			}
		}
		return terminatingCharacterPosition;
	}
	
	protected int getLastCursorPositionForInsertion(String source, int caretPosition) {
		return getLastCursorPositionForDeletion(source, caretPosition, getProtectedPositions());
	}

	/**
	 * move to the next position
	 * should handle the protected list
	 * 
	 * @param text
	 * @param currentCaretPosition
	 */
	protected int moveToNextCharacter(Text text, int currentCaretPosition, ArrayList<Integer> characterPositionsThatCantBeModified) {
		// carel06 - the currentCaretPosition is 0 based.  no need to add one.
		// the currentCaretPosition needs to add a plus 1
		// since currentCaretPosition is not 0 index based
		// currentCaretPosition = currentCaretPosition + 1;

		int nextCaretPosition = currentCaretPosition + 1;
		
		// carel06
		// if you are in the hexdata portion, you can move to the next character
		while(characterPositionsThatCantBeModified.contains(new Integer(textCaretPositionTrue + 1))) {
            // this character is protected, going to next character
			//depil01 - #2993
			textCaretPositionTrue++;
			if(textCaretPositionTrue >= subStringEndIndex) {
				break;
			}
			//end #2993
			nextCaretPosition++;
		}
	
		// undo the changes of the 0 based index mixmatched.
		// nextCaretPosition need to have 1 removed from it b/c it is 1 based.
		// nextCaretPosition = nextCaretPosition - 1;

		text.setSelection(nextCaretPosition, nextCaretPosition);
		return nextCaretPosition;
	}
	
	/**
	 * move to the previous position
	 * should handle the protected list
	 * 
	 * @param text
	 * @param currentCaretPosition
	 * @return the new caretPosition
	 */
	private int moveToPreviousCharacter(Text text, int currentCaretPosition, ArrayList<Integer> characterPositionsThatCantBeModified) {
		// carel06 - commented this out, when i did some 
		// testing, the text.getCaretPosition was 0 based
		// the currentCaretPosition needs to add a plus 1
		// since currentCaretPosition is not 0 index based
		// currentCaretPosition = currentCaretPosition + 1;
		if(currentCaretPosition == 0) {
            // currentCaretPosition is 0, no more room to move left to
			return currentCaretPosition;
		}
		int previousCaretPosition = currentCaretPosition - 1;
		
		// if there are no protectedValues to check for,
		// go to the previous character in the string
		if(characterPositionsThatCantBeModified.size() == 0) {
			text.setSelection(previousCaretPosition, previousCaretPosition);
			return previousCaretPosition;
		}
		
		// carel06
		// only move it to the next next character when you are in charData position.
		while(characterPositionsThatCantBeModified.contains(new Integer(textCaretPositionTrue - 1))) {
            // this charater is protected, going to next charater
			//depil01 - #2993
			textCaretPositionTrue--;
			if(textCaretPositionTrue <= subStringBeginIndex) {
				break;
			}
			//end #2993
			previousCaretPosition--;
		}
		
		text.setSelection(previousCaretPosition, previousCaretPosition);
		return previousCaretPosition;		
	}
	
	/**
	 * 2013/09/19 - carel06 - 2756
	 * The end user can enter as many characters as they want.
	 * Unlimited in SRM but if the field is visible full, then no more additional characters.
	 * 
	 * You can insert into the SRF Record Field but ones its all full, 
	 * you are not able to anymore
	 */
	protected boolean isInsertableForSingleRecordFormatMode(String text, int caretPosition, int numberOfCharactersToInsert) {
//		int beginIndex = getSubStringBeginIndex();
//		int endIndex = getSubStringEndIndex();
		int caretPositionIncludingOffset = subStringBeginIndex + textCaretPosition;
		capacity = (subStringEndIndex - subStringBeginIndex); //@parra1@: because 0 based so +1.
		log.log(Level.INFO, "begin index: " + subStringBeginIndex + " end index: " + subStringEndIndex + " textCaretPosition: " + textCaretPosition + " caretPositionIncludingOffset: " + caretPositionIncludingOffset);
		log.log(Level.INFO, "text length: " + text.length() + " capacity: " + capacity + " text: " + text);
		//int numberOfSpacesBeforeTerminatingPosition = Constants.getNumberOfTrailingSpaces(text);
		boolean testForSelection = false;
		// carel06 - TK-268985
        // I was using the trim method which also removes the leading
		// spaces.  I'm only concerned with the trailing spaces.
		String textWithTrailingSpacesRemoved = text.replaceFirst("\\s+$", "");
		if(textSelection.x == textSelection.y)  {
			testForSelection = textWithTrailingSpacesRemoved.length() + numberOfCharactersToInsert > capacity;			
		} else {
			// we have to subtract the characters that have been selected
			// since they will be deleted.
			testForSelection = textWithTrailingSpacesRemoved.length() + numberOfCharactersToInsert - textFromKeyPressed.getSelectionCount() > capacity;
		}
		if(textWithTrailingSpacesRemoved.length() > capacity ||  textCaretPositionTrue > subStringEndIndex || testForSelection) {
			log.log(Level.INFO, "no longer to insert");
			return false;
		}
		
		// default is to return true
		return true;
	}
	/**
     * 2014/10/21 carel06
     * Added the characterPositionsThatCantBeModified variable since it is a 
     * different behavior when in hexData vs. charData.
     * 
	 * To be able to insert, we must have some spaces at the end of the record field.
	 * We calculate the number of available spaces.
	 * We figure out how many spaces we can insert to based on current caret position.
	 * And we do a quick compare if we have enough room.
	 * 
	 * @param text - string to be pasted upon - destination 
	 * @param caretPosition - The caret position provided is 0-based
	 * @param numberOfCharactersToInsert
     * @param characterPositionsThatCantBeModified the positions that are protected
	 * @return 
	 */
	protected boolean isInsertable(String text, int caretPosition, int numberOfCharactersToInsert, ArrayList<Integer> characterPositionsThatCantBeModified) {
		String textSubstringThatAccountsForCaretPositionAndProtectedValues;
		int positionThatContainsProtectedValue = -1;
		//if selection is protected area don't paste
		
		// carel06 - Defect 3017
		// when getting the caretPosition, we were using the offset and not the true caretPosition.
		// we have to use textCaretPositionTrue when comparing it to the protectedValues
		if(textSelection.x == textSelection.y) {
			// there is no selection
			if(characterPositionsThatCantBeModified.contains(textCaretPositionTrue)) {
				return false;
			}					
		} else {
				// carel06 - Defect 3017
				// trying to fix the error when there is a selection, and trying to do an insert
				int offset = textCaretPositionRowIndex * (textFromWidgetSplitIntoRows[textCaretPositionRowIndex] + LINE_SEPARATOR).length();
				if(characterPositionsThatCantBeModified.contains(textSelection.x - offset + subStringBeginIndex) || characterPositionsThatCantBeModified.contains(textSelection.y - offset + subStringBeginIndex)) {
					return false;
				}			
		}
		
		for(Integer x: characterPositionsThatCantBeModified) {
			// carel06 - Defect 3017
			// using textCaretPositionOffset instead of caretPosition (parameter variable)
			// since we are trying to get the protected values, we need to use the offset + subStringBeginIndex
			int currentPositionModel = textCaretPositionOffset + subStringBeginIndex;
			if(x > currentPositionModel) {
				positionThatContainsProtectedValue = x.intValue();
				break;
			}
		}
		
		
		if(characterPositionsThatCantBeModified.size() == 0 || positionThatContainsProtectedValue == -1  || subStringEndIndex< positionThatContainsProtectedValue) {
			//Mahma04 defect 2834
			if(textCaretPositionRowIndex>0){
			textSubstringThatAccountsForCaretPositionAndProtectedValues = text.substring(textCaretPositionOffset);
			}else{
				textSubstringThatAccountsForCaretPositionAndProtectedValues = text.substring(caretPosition);	
			}

		} else {
			// carel06 defect 3017
			// substring parameter use beginIndex (inclusive) / endIndex (exclusive)
			textSubstringThatAccountsForCaretPositionAndProtectedValues = text.substring(textCaretPositionOffset, positionThatContainsProtectedValue - subStringBeginIndex);
		}
		
		int numberOfSpacesBeforeTerminatingPosition = getNumberOfTrailingSpaces(textSubstringThatAccountsForCaretPositionAndProtectedValues); 
		numberOfSpacesBeforeTerminatingPosition = numberOfSpacesBeforeTerminatingPosition +  textFromKeyPressed.getSelectionCount();
		if(numberOfSpacesBeforeTerminatingPosition >= numberOfCharactersToInsert) {
			return true;
		} else {
			return false;
		}
	}
	

	
	private int getNumberOfTrailingSpaces(String str) {
		int i;
		int numberOfSpaces = 0;
		for ( i=str.length()-1;i>=0;i--){  
			char c = str.charAt(i);  
			if (c != EMPTY_SPACE_TO_INSERT) {  
				break;  
			} else {
				numberOfSpaces++;
			}
		}  
		return numberOfSpaces;
	}
	/**
	 * This method handles the overtype mode.
	 * once the text has been replaced with the new StringBuffer value
	 * we need to position the cursor in the right position.
	 * this does replacement of characters
	 * 
	 * @param keyEvent
	 * @param text
	 * @param caretPosition
	 */
	private void handleOvertypeMode(KeyEvent keyEvent, Text text, int caretPosition) {
		// this replaces the character in the current position with the one 
		// newly typed.  also need to update the cursor position
		String valueOfText = deleteCharAtPositionAndInsertCharAtPosition(keyEvent, text, caretPosition);
		text.setText(valueOfText.toString());	
		moveToNextCharacter(text, caretPosition, getProtectedPositions());
		
		// text has been modified
		editorView.setDirty();
		((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
					.getStatusLineManager().find("messages")).setText(" ");
	}

	/**
	 * Insert of using a stringBuffer, we are using the String class instead.
	 * StringBuffer adds extra characters at the end and we don't want to use that.
	 * 
	 * @param keyEvent
	 * @param text
	 * @param caretPosition
	 * @return
	 */
	private String deleteCharAtPositionAndInsertCharAtPosition(KeyEvent keyEvent, Text text, int caretPosition) {	
		String a = textFromWidgetSplitIntoRows[textCaretPositionRowIndex].substring(0, textCaretPositionOffset);
        String b = "";
		try {
			b = textFromWidgetSplitIntoRows[textCaretPositionRowIndex].substring(textCaretPositionOffset + 1, textFromWidgetSplitIntoRows[textCaretPositionRowIndex].length());
		} catch(StringIndexOutOfBoundsException e) {
			// carel06 - 2014/12/11
			// TK-271841
			// do nothing, it just means there is no more characters available.
			// b is set as an empty string anyways
		}
//        log.info("a: " + a);
//        log.info("b: " + b);
		textFromWidgetSplitIntoRows[textCaretPositionRowIndex] = a + b;
		String c = textFromWidgetSplitIntoRows[textCaretPositionRowIndex].substring(textCaretPositionOffset, textFromWidgetSplitIntoRows[textCaretPositionRowIndex].length());
//        log.info("c: " + c);
		textFromWidgetSplitIntoRows[textCaretPositionRowIndex] = a + keyEvent.character + c;
		
		if(textFromWidgetSplitIntoRows.length > 1) {
			return textFromWidgetSplitIntoRows[0] + LINE_SEPARATOR + textFromWidgetSplitIntoRows[1] + LINE_SEPARATOR + textFromWidgetSplitIntoRows[2];
		} else {
			return textFromWidgetSplitIntoRows[0];			
		}
	}
	
//	private void handlePasteEvent(KeyEvent keyEvent, Text text, int caretPosition) {
//
//		
//		if(clipboardDataToBePasted == null || clipboardDataToBePasted.length() == 0) {
//			log.log(Level.INFO, "nothing to paste");
//			return;
//		}
//
//		if(insertToggleFlag) {
//			pasteInsertMode(keyEvent, text, caretPosition, clipboardDataToBePasted);
//		} else {
//			pasteOvertypeMode(keyEvent, text, caretPosition, clipboardDataToBePasted);
//		}
//	}

	/*
	 * still have some work to do to figure out which other class 
	 * is doing some pasting but there is. for now, accept the fact that somebody 
	 * else is doing some pasting and just adjust to is.
	 * some other class does a paste so we just make sure we delete the proper 
	 * characters
	 * 
	 * This method is being called by FileMasterPlusKeyListener
	 */
	public void pasteOvertypeMode(Object eventObject, Text text, int caretPosition_old, String stringThatWillBePasted) {
		//Defect 2890
		textFromKeyPressed = text;
		textText = text.getText();
		textCaretPosition = textFromKeyPressed.getCaretPosition();
		textSelection = textFromKeyPressed.getSelection();
        
		boolean isPasteable = canPasteOvertypeMode(eventObject, text, caretPosition_old, stringThatWillBePasted);
        if(isPasteable == false) {
        	updateDoItFlagForEvent(eventObject, false);
        	return;
        }
		
		deleteAndInsertToData(text, caretPosition_old, stringThatWillBePasted);
	}

	protected boolean canPasteOvertypeMode(Object eventObject, Text text, int caretPositionOffset, String clipboardData) {
		
		//int caretPosition = getSubStringBeginIndex()+caretPositionOffset;
		
		// one of the things discussed with Guy is that we do not
		// allow them to past if the destination location is too short.
		int dataLength = clipboardData.length();
//		int textCharCount = text.getCharCount();
//		log.log(Level.INFO, "dataLength: " + dataLength + " textCharCount: " + textCharCount + " caretPosition: " + caretPosition);
		
		// can the object you are trying to paste fit in the field in the first place.
		if(dataLength > maxLengthP ) {
			log.warning("trying to paste object with a length of: " + dataLength + " when we only have " + maxLengthP + " space left");
			return false;
		}

		// Defect 2462 - carel06 - 20130930
		int p = getLeftMostCaretPositionIncludingSelection(textCaretPositionOffset);
		if(dataLength > (maxLengthP - p)) {
			log.warning("cannot paste into buffer, too many characters. caretPosition also being considered");
			return false;
		}
		
		
		// another condition why we can't paste is if there is not enough room
		// figure out how many characters are visible, and see when you are.
		//@parra12: without +1 in charformatmode we are unable to paste the contents of a clipboard where dataLength == subStringEndIndex - caretPosition 
        // 2014/09/08 carel06
		// changing the subStringEndIndex variable should never be done.
//		if(formatMode instanceof CharFormatMode)
//			subStringEndIndex+=1;
        
		if(subStringEndIndex - (subStringBeginIndex + textCaretPositionOffset) < dataLength) {
			// not enough room to paste.
			// limited visible space available
			return false;
		}
		
		int terminatingCharacterPosition = getLastCursorPositionForDeletion(text.getText(), textCaretPositionOffset, getProtectedPositions());
		// defect 2462 carel06 20130930
		// if there is something already selected
		// use that position rather than the current caret position
		// we have some extra space to paste to 
		// FYI, if there is no current selection, textSelection.x = textSelection.y = caretPosition
		int findTheLeftMostPosition = getLeftMostCaretPositionIncludingSelection(textCaretPositionOffset);
		int currentCaretPositionThatIncludesSubStringOffset = findTheLeftMostPosition- subStringBeginIndex;
		int pastingDestionationPosition = currentCaretPositionThatIncludesSubStringOffset + dataLength;
		
		
		if(pastingDestionationPosition > terminatingCharacterPosition) {
			log.warning("cannot paste into buffer, too many characters. terminatingCharacterPosition: " + pastingDestionationPosition + ":" + terminatingCharacterPosition);
            return false;
		}
		
		checkIfPastingToProtectedValue(eventObject, text, caretPositionOffset, dataLength, getProtectedPositions());
		if(eventObject instanceof Event) {
			Event event = (Event) eventObject;
			if(event.doit == false) {
				// checkIfPastingToProtectedValue found that you cannot paste
				return false;
			}
		} else if(eventObject instanceof KeyEvent) {
			KeyEvent keyEvent = (KeyEvent) eventObject;
			if(keyEvent.doit == false) {
				// checkIfPastingToProtectedValue found that you cannot paste
				return false;
			}
		}
		
		// if it got this far, it has met all the conditions.
		// can paste in overtype mode
		return true;
	}

	/**
	 * This method is being called by CustomPasteHandler
	 * 
	 * @param event
	 * @param text
	 * @param caretPosition_old
	 * @param stringThatWillBePasted
	 */
//	public void pasteOvertypeMode(Event event, Text text, int caretPosition_old, String stringThatWillBePasted) {
//		int caretPosition = getSubStringBeginIndex()+caretPosition_old;
//		log.log(Level.INFO, "inside pasteOvertypeMode");
//		
//		// one of the things discussed with Guy is that we do not
//		// allow them to past if the destination location is too short.
//		int dataLength = stringThatWillBePasted.length();
////		int textCharCount = text.getCharCount();
////		log.log(Level.INFO, "dataLength: " + dataLength + " textCharCount: " + textCharCount + " caretPosition: " + caretPosition);
//		log.log(Level.INFO, "dataLength: " + dataLength + " caretPosition: " + caretPosition);
//		
//		// can the object you are trying to paste fit in the field in the first place.
//		if(dataLength > getMaxLengthP()) {
//			log.log(Level.INFO, "trying to paste object with a length of: " + dataLength + " when we only have " + getMaxLengthP() + " space left");
//			event.doit = false;
//			return;
//		}
//
//		// Defect 2462 - carel06 - 20130930
//		int p = getLeftMostCaretPositionIncludingSelection(caretPosition);
//		if(dataLength > (getMaxLengthP()- p)) {
//			log.log(Level.INFO, "cannot paste into buffer, too many characters. caretPosition also being considered");
//			event.doit = false;
//			return;
//		}
//		
//		
//		// another condition why we can't paste is if there is not enough room
//		// figure out how many characters are visible, and see when you are.
//		int subStringEndIndex = getSubStringEndIndex();
//		//@parra12: without +1 in charformatmode we are unable to paste the contents of a clipboard where dataLength == subStringEndIndex - caretPosition 
//		if(formatMode instanceof CharFormatMode) {
//			subStringEndIndex+=1;
//		}
//
//		int caretPositionBasedOnRowIndex = getRowPositionBasedOnText(text, caretPosition);
//		if(subStringEndIndex - caretPositionBasedOnRowIndex < dataLength) {
//			// not enough room to paste.
//			// limited visible space available
//			log.log(Level.INFO, "subStringEndIndex: " + subStringEndIndex + " caretPosition: " + caretPosition + " dataLength: " + dataLength);
//			event.doit = false;
//			return;
//		}
//		
//		int terminatingCharacterPosition = getLastCursorPositionForDeletion(text.getText(), caretPosition);
//		// defect 2462 carel06 20130930
//		// if there is something already selected
//		// use that position rather than the current caret position
//		// we have some extra space to paste to 
//		// FYI, if there is no current selection, textSelection.x = textSelection.y = caretPosition
//		int findTheLeftMostPosition = getLeftMostCaretPositionIncludingSelection(caretPositionBasedOnRowIndex);
//		int currentCaretPositionThatIncludesSubStringOffset = findTheLeftMostPosition- getSubStringBeginIndex();
//		int pastingDestionationPosition = currentCaretPositionThatIncludesSubStringOffset + dataLength;
//		
//		
//		if(pastingDestionationPosition > terminatingCharacterPosition) {
//			log.log(Level.INFO, "cannot paste into buffer, too many characters. terminatingCharacterPosition: " + pastingDestionationPosition + ":" + terminatingCharacterPosition);
//			event.doit = false;
//			return;
//		}
//		
//		deleteAndInsertToData(text, caretPosition_old, stringThatWillBePasted);
//	}
	
	/**
	 * Common code used by pasteOvertypeMode
	 * We are trying to overtype to the text data.
	 * 
	 * @param text
	 * @param caretPosition_old
	 * @param stringThatWillBePasted
	 */
	protected void deleteAndInsertToData(Text text, int caretPosition_old, String stringThatWillBePasted) {
		for(char c: stringThatWillBePasted.toCharArray()) {
			// this replaces the character in the current position with the one 
			// newly typed.  also need to update the cursor position
			String valueOfText = new String(text.getText());
			String preValueOfText = valueOfText.substring(0, caretPosition_old);
			String postValueOfText = valueOfText.substring(caretPosition_old + 1, valueOfText.length());
			valueOfText = preValueOfText + postValueOfText;
			valueOfText = preValueOfText + c + valueOfText.substring(caretPosition_old, valueOfText.length());
			text.setText(valueOfText.toString());
			caretPosition_old = moveToNextCharacter(text, caretPosition_old, getProtectedPositions());
		}
//		makeEditorDirty();
	}

	private int getLeftMostCaretPositionIncludingSelection(int caretPosition) {
		int findTheLeftMostPositionBasedOnSelection = Math.min(textSelection.x, textSelection.y);
		int findTheLeftMostPosition = Math.min(caretPosition, findTheLeftMostPositionBasedOnSelection + subStringBeginIndex);
		return findTheLeftMostPosition;
	}

	/**
	 * We have a pasteInsertModeCommon since the keyEvent/event
	 * is used by this class and the CustomPasteHandler class.
	 * Trying to refactor to avoid duplication.
	 * 
	 * @param text
	 * @param caretPosition
	 * @param data
	 */
	public void pasteInsertMode(Object eventObject, Text text, int caretPosition, String data) {
		

        
		// determines if there is space to insert
		if(!(isInsertable(textFromWidgetSplitIntoRows[textCaretPositionRowIndex], textCaretPositionOffset, data.length(),getProtectedPositions()))) {
			log.warning("cannot be inserted");
			updateDoItFlagForEvent(eventObject, false);
			return;
		}
		
		//depil01 - defect #2918
		//For SF mode if the length of the data in the field is less than the length of the visible area, new data can be pasted into that empty space
		if(formatMode instanceof SingleRecordFormatMode && capacity > textFromWidgetSplitIntoRows[textCaretPositionRowIndex].length()) { 
			int freeSpaceAtTheEnd = capacity - textFromWidgetSplitIntoRows[textCaretPositionRowIndex].length();
			for(int count = 0; count < freeSpaceAtTheEnd; count++) {
				textFromWidgetSplitIntoRows[textCaretPositionRowIndex] = textFromWidgetSplitIntoRows[textCaretPositionRowIndex] + " ";
			}
		}
		
		if(textFromKeyPressed.getSelectionCount() > 0) {
			//textSelection.x;
			handleDeleteKeyOnSelection(text, getProtectedPositions());
			//depil01 - defect 2927 -> if the selection is done from left to right, subtract the length of the selection to the offset
			//						   if the selection is done from right to left leave textCaretPositionOffset as it is
			//The offset will be used when we edit the hex lines (textCaretPositionRowIndex != 0)
			int offset = textCaretPositionRowIndex * (textFromWidgetSplitIntoRows[textCaretPositionRowIndex] + LINE_SEPARATOR).length();
			if(textCaretPositionOffset == textSelection.y - offset) {
				int numberOfCharactersSelected = Math.abs(textSelection.x - textSelection.y);
				textCaretPositionOffset = textCaretPositionOffset - numberOfCharactersSelected;	
			}
		}
		
		// Defect 2987
		// if the offset is negative, there is something wrong,
		// the offset should never be less then 0.
		// just abort pasteInsertMode
		if(textCaretPositionOffset < 0) {
			log.warning("textCaretPositionOffset is negative which should never be, aborting operation " + textCaretPositionOffset);
			return;
		}
		
		// do the actual insert
		String editedRow = textFromWidgetSplitIntoRows[textCaretPositionRowIndex];
		for(char c: data.toCharArray()) {
			
			String valueOfText = null;
			
            //depil01 - when inserting characters the protected areas must not be shifted
			//the protected area needs to be considered in char mode only
			if(formatMode instanceof CharFormatMode) {
				int terminatingCharacterPosition = getLastCursorPositionForInsertion(text.getText(), caretPosition) - subStringBeginIndex;                           
	            editedRow = editedRow.substring(0   , terminatingCharacterPosition - 1) + editedRow.substring(terminatingCharacterPosition, editedRow.length());
			}
            //end
            
			// carel06 - Defect 2594
			// had to add this code snippet because it was not working in SRM.
			// an extra character was being added.
			// to replicate, copy characters (length = 3) into clipboard
			// select 6 characters in the record.
			// do a CTRL-V to paste.
			// an extra character was being added.
			// this get's around that issue.
			String firstSubstring = editedRow.substring(0, textCaretPositionOffset);
			String secondSubstring = "";
			if(formatMode instanceof SingleRecordFormatMode) {
				secondSubstring = editedRow.substring(textCaretPositionOffset, editedRow.length() - 1);
			} else {
				secondSubstring = editedRow.substring(textCaretPositionOffset, editedRow.length());
			}
			
			editedRow = firstSubstring + c + secondSubstring;
			if(textFromWidgetSplitIntoRows.length == 1) {
				valueOfText = editedRow;
			} else {
				textFromWidgetSplitIntoRows[textCaretPositionRowIndex] = editedRow;
				valueOfText = textFromWidgetSplitIntoRows[0] + LINE_SEPARATOR +  textFromWidgetSplitIntoRows[1] + LINE_SEPARATOR +  textFromWidgetSplitIntoRows[2];
			}
			text.setText(valueOfText.toString());
			int hex = moveToNextCharacter(text, getTruePositionBasedOnRowIndexAndPositionOffset(textCaretPositionRowIndex, textCaretPositionOffset), getProtectedPositions());
			textCaretPositionOffset = getRowPositionBasedOnText(text, hex);
		}
//		makeEditorDirty();
	}
	
	/**
	 * Resolves Defect 2334
	 * 
	 * When text is selected and the delete key is pressed, we should be deleting the selected text
	 * 
	 * Some notes during investigation from Point to CaretPosition:
	 * INFO: selectionText:   GHIJ selectionCount: 4 selectionPoint: Point {19, 23} caretLocation: Point {136, 0} currentCaretPosition: 19
     * INFO: selectionText: ABCDEF selectionCount: 6 selectionPoint: Point {13, 19} caretLocation: Point {136, 0} currentCaretPosition: 19
     * INFO: selectionText:    DEF selectionCount: 3 selectionPoint: Point {16, 19} caretLocation: Point {136, 0} currentCaretPosition: 19
     * It seems the selection point will allow me to figure out if I should be going left or right
	 */
	private synchronized void handleDeleteKeyOnSelection(Text text, ArrayList<Integer> characterPositionsThatCantBeModified) {
		int numberOfCharactersToDelete = 0;
		if(textCaretPosition == textSelection.x) {
			// characters selected from right to left - delete the characters following currentCaretPosition
			numberOfCharactersToDelete = textSelection.y - textCaretPosition;
		} else if(textCaretPosition == textSelection.y) {
			// characters selected from left to right - delete the characters previous to currentCaretPosition
			numberOfCharactersToDelete = textCaretPosition - textSelection.x;
			textCaretPositionTrue = textCaretPositionTrue - numberOfCharactersToDelete;
			
		} else {
			// do nothing for now.
			log.warning("unknown selection to delete");
			return;
		}
		
		// need to check if any of the characters is protected, if so, don't do a delete.
		for(int x=0; x < numberOfCharactersToDelete; x++) {
			// if trying to delete a protected value, don't do it and just return
			// 2014/09/12 carel06
			// we removed the subStringBeginIndex calculation.  we dont' 
			// need to add subStringBeingIndex since we have the true caret
			// position, not the offset.
			if(characterPositionsThatCantBeModified.contains(new Integer(textCaretPositionTrue + x))) {
				log.warning("trying to delete a protected value, can't complete");					
				return;
			}
		}
		
		for(int x=0; x < numberOfCharactersToDelete; x++) {
			// carel06 - defect 3017
			// when providing parameters to handleDeleteKey,
			// the second paramter should be the offset
			// not the true caret position.
			handleDeleteKey(text, textCaretPositionTrue, getProtectedPositions());
		}
	}
	/**
	 * The protected range is not being protected
	 * a record can have three rows (chardata/hex1/hex2)
	 * determine which row you are editing
	 * this is what should be passed to the isInsertable method.		
	 * 
	 * @param currentPositionButNotRowAware current position based ont the Text widget
	 * @param currentPositionButNotRowAware should be the offset value
	 */
	private void handleDeleteKey(Text text, int currentPositionButNotRowAware, ArrayList<Integer> characterPositionsThatCantBeModified) {
		//int positionTrue = currentPositionButNotRowAware + getSubStringBeginIndex();
		//int caretPositionBasedOnRowIndex = getRowPositionBasedOnText(text, currentPositionButNotRowAware);
		
		// 2014/09/16 carel06
		// Defect 3151
		// I removed the "- subStringBeginIndex" clause because the variable
		// currentPositionButNotRowAware is not the offset but the true value.
		// the protectedValues array list is the true value.
		//
		// if trying to delete a protected value, don't do it and just return
		if(characterPositionsThatCantBeModified.contains(new Integer(currentPositionButNotRowAware))) {
			// trying to delete a protected value, can't complete
			return;
		}

		/* Defect 2151 - The empty space needs to be inserted not only for protected fields. If no space is inserted null
		 character is inserted. This happen when trying to insert data in an empty data set. */
		//if(protectedValues != null && protectedValues.size() > 0) {
		// protected values exist, insert a character on protecteValues - 1;
		// 2774 - carel06 - 20130910
		// had to remove the subStringBeginIndex.
		// when working in SRM, it would put a space in the wrong position.
		// Defect 2510. In SRM, we were deleting the the said character but inserting the 
		// space not in the last position.
		// By getting the "terminatihgCharacterPosition before we delete the said character, we provide the correct value for terminatingCharacterPosition.
		// delete the character at caretPosition
		// rowInWhichCharacterIsToBeDeleted.deleteCharAt(cursorPosition);
		String firstParameter = "";
		try {
			firstParameter = textFromWidgetSplitIntoRows[textCaretPositionRowIndex].substring(0, currentPositionButNotRowAware - subStringBeginIndex);
		} catch(StringIndexOutOfBoundsException e) {
			firstParameter = textFromWidgetSplitIntoRows[textCaretPositionRowIndex];

		}
		String secondParameter = "";
		try {
			secondParameter = textFromWidgetSplitIntoRows[textCaretPositionRowIndex].substring(currentPositionButNotRowAware - subStringBeginIndex + 1, textFromWidgetSplitIntoRows[textCaretPositionRowIndex].length());
		}catch(StringIndexOutOfBoundsException e) {
			secondParameter = "";
		}
		textFromWidgetSplitIntoRows[textCaretPositionRowIndex] = firstParameter + secondParameter;

		
        int terminatingCharacterPosition = getLastCursorPositionForDeletion(textFromWidgetSplitIntoRows[textCaretPositionRowIndex], textCaretPositionOffset, getProtectedPositions());
        log.info("terminatingCharacterPosition: " + terminatingCharacterPosition);
        
        // carel06 - 20130920 - Defect 2730
        // the terminatingCharacterPosition value that comes from getLastCursorPositionForDeletion is the exact cursor position related 
        // to the model.  when we try to insert something, we have to remove the offset.
        int terminatingCharacterPositionOffset = terminatingCharacterPosition - subStringBeginIndex;
       
        String before = "";
        try {
        	before =  textFromWidgetSplitIntoRows[textCaretPositionRowIndex].substring(0, terminatingCharacterPositionOffset -1);			
		} catch (StringIndexOutOfBoundsException e) {
            before = textFromWidgetSplitIntoRows[textCaretPositionRowIndex];
		}
        String after = "";
        try {
        	after = textFromWidgetSplitIntoRows[textCaretPositionRowIndex].substring(terminatingCharacterPositionOffset - 1, textFromWidgetSplitIntoRows[textCaretPositionRowIndex].length());
        } catch(StringIndexOutOfBoundsException e) {
            after = "";
        }
       	textFromWidgetSplitIntoRows[textCaretPositionRowIndex] = before + EMPTY_SPACE_IN_CHAR + after;        	        	
        	
		if(textFromWidgetSplitIntoRows.length == 1) {
			text.setText(textFromWidgetSplitIntoRows[0]);
		} else {
			text.setText(textFromWidgetSplitIntoRows[0] + LINE_SEPARATOR + textFromWidgetSplitIntoRows[1] + LINE_SEPARATOR + textFromWidgetSplitIntoRows[2]);
		}
		int currentPosition = getTruePositionBasedOnRowIndexAndPositionOffset(textCaretPositionRowIndex,currentPositionButNotRowAware - subStringBeginIndex);
		text.setSelection(currentPosition, currentPosition);
		editorView.setDirty();
		((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
				.getStatusLineManager().find("messages")).setText(" ");
	}
	
	private void handleInsertMode(KeyEvent keyEvent, Text text, int caretPosition) {
		String stringContentOfTheTextWidget = text.getText();
		 
		// a record can have three rows (chardata/hex1/hex2)
		// determine which row you are editing
		// this is what should be passed to the isInsertable method.
		String[] row = text.getText().split(LINE_SEPARATOR);
		
//		if(caretPosition <= getMaxLengthP()) {
//			whichRowDoesCaretPositionBelongTo = 0;
//			caretPositionWithRowContext = caretPosition;
//		} else {
//			whichRowDoesCaretPositionBelongTo = caretPosition / getMaxLengthP();
//			caretPositionWithRowContext = caretPosition % getMaxLengthP();
//			if(whichRowDoesCaretPositionBelongTo == 1) {
//				caretPositionWithRowContext = caretPositionWithRowContext - 2;
//			} else {
//				caretPositionWithRowContext = caretPositionWithRowContext - 4;
//			}
//		}
		
		// there are only three rows.
		// if it is greater then 2, something is wrong and flag it.
		if(textCaretPositionRowIndex > 2) {
			log.warning("incorrect row: " + textCaretPositionRowIndex);
			log.warning("row:" + Arrays.toString(row) + " caretPosition: " + caretPosition);
			return;
		}
		
//		log.log(Level.INFO, "whichRowDoesCaretPositionBelongTo: " + whichRowDoesCaretPositionBelongTo);
//		log.log(Level.INFO, "caretPositionWithRowContext: " + caretPositionWithRowContext);
//		log.log(Level.INFO, "row[whichRowDoesCaretPositionBelongTo]: " + row[whichRowDoesCaretPositionBelongTo]);
		boolean insertableFlag = false;
		if(formatMode instanceof SingleRecordFormatMode) {
			insertableFlag = isInsertableForSingleRecordFormatMode(text.getText(), caretPosition, 1);
		} else {
			insertableFlag = isInsertable(row[textCaretPositionRowIndex], caretPosition, 1, getProtectedPositions());
		}
//		if(whichRowDoesCaretPositionBelongTo == 0) {
//		} else {
//			if(row[whichRowDoesCaretPositionBelongTo].length() < x) {
//				insertableFlag = true;
//			} else {
//				insertableFlag = false;
//			}
//		}
		if(insertableFlag) {
            String valueOfText = new String(row[textCaretPositionRowIndex]);

            // carel06 / Defect 2954
            // had to add this code snippet because in SRM mode
            // you have to edit the whole visible record, this includes the spaces.
            if(formatMode instanceof SingleRecordFormatMode) {
            	int howManySpacesToFillTillTheEnd = subStringEndIndex - subStringBeginIndex;
            	int x = valueOfText.length();
            	int numberOfSpacesToAdd = howManySpacesToFillTillTheEnd - x;
            	for(int i = 0; i < numberOfSpacesToAdd; i++) {
            		valueOfText = valueOfText + " ";
            	}            	
            }
            
            // carel06 - 2446
            // not sure why this was commented out in the first place but we need
            // to insert this code snippet back.
            // when you insert an item, you can only insert it at the end replacing a space
            // If text is not empty, remove one space at the end before inserting a new char
            int terminatingCharacterPosition = -1;
            int indexForDelete = terminatingCharacterPosition - 1;
            if(!stringContentOfTheTextWidget.isEmpty()) {
            	try {
            		terminatingCharacterPosition = getLastCursorPositionForInsertion(valueOfText, textCaretPositionOffset) - subStringBeginIndex;                        
            		// valueOfText.deleteCharAt(indexForDelete);
            		// need to delete the space at the end of the row
            		valueOfText = deleteCharacterWhileEditing(valueOfText, terminatingCharacterPosition);
            	} catch (StringIndexOutOfBoundsException e) {
            		log.warning("unable to delete character --> position: " + indexForDelete + " text: " + valueOfText);
            	}
            }
            
            // carel06 - Defect 3017
            // We have to handle the condition 
            // where there is a some text selection, insert it at the right poing
            int numberOfCharactersSelection = Math.abs(textSelection.x - textSelection.y);
            if(numberOfCharactersSelection > 0 && textSelection.y == textCaretPosition && textCaretPositionRowIndex != 0)  {
            	// if there is no textSelection
            	textCaretPositionOffset = textCaretPositionOffset - numberOfCharactersSelection;
            } 
            valueOfText = valueOfText.substring(0, textCaretPositionOffset) + keyEvent.character + valueOfText.substring(textCaretPositionOffset, valueOfText.length());
            row[textCaretPositionRowIndex] = valueOfText.toString();
            
            
            if(row.length > 1) {
            	text.setText(row[0] + LINE_SEPARATOR + row[1] + LINE_SEPARATOR + row[2]);                                        
            } else {
            	text.setText(row[0]);
            }

            // carel06 - Defect 3017
            // If there is a text selection, we noticed that the caretPosition
            // was incorrect.  We handle that here.
            int correctCaretPositionEvenIfThereIsSelection = caretPosition;
            if(numberOfCharactersSelection > 0) {
            	if(textSelection.x == textCaretPosition) {
            		correctCaretPositionEvenIfThereIsSelection = textCaretPosition;
            	} else {
            		correctCaretPositionEvenIfThereIsSelection = textCaretPosition - numberOfCharactersSelection;
            	}
            } 
            moveToNextCharacter(text, correctCaretPositionEvenIfThereIsSelection, getProtectedPositions());
            
            // the text value has been change, make the editor dirty
    		editorView.setDirty();
    		((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
					.getStatusLineManager().find("messages")).setText(" ");
		} else {
			log.warning("unable to insert since there is no room");
		}
	}

	/**
	 * carel06 / Defect 2954
	 * Had to create a sepate method for this since
	 * it is being handled differently in CharMode vs. SingleRecordFormatMode.
	 * 
	 * @param valueOfText
	 * @param terminatingCharacterPosition
	 * @return
	 */
	protected String deleteCharacterWhileEditing(String valueOfText, int terminatingCharacterPosition) {
		String firstSubString = valueOfText.substring(0   , terminatingCharacterPosition - 1);
		String secondSubString = valueOfText.substring(terminatingCharacterPosition, valueOfText.length());
		valueOfText = firstSubString + secondSubString;
		return valueOfText;
	}

	/**
	 * Determine which part of the data you are in.
	 * The cursor position provided could put the cursor in the CharData portion 
	 * or the HexData1 or the HexData2 portion.
	 * 
	 * @param text
	 * @param cursorPosition
	 * @return which row the cursor position is in.
	 */
	private int getRowIndexBasedOnText(Text text, int cursorPosition) {
		
		// trying to determine which row the cursor position is in.
		String[] row = text.getText().split(LINE_SEPARATOR);
		if(row.length == 1) {
			return 0;
		}
		
		// there are more then one row.  hexData is included
		int charDataLength = row[0].length() + LINE_SEPARATOR.length();
		int hexData1Length = charDataLength + row[1].length() + LINE_SEPARATOR.length();
		if(cursorPosition < charDataLength) {
			return 0;
		} else if(cursorPosition < hexData1Length) {
			return 1;
		} else {
			return 2;
		}
	}
	
	/**
	 * In SingleRecordMode, there is only one line. 
	 * It does not have 3 modes like in CharMode with Hex is On.
	 * Just return the cursorPosition.
	 */
	protected int getRowPositionBasedOnText(Text text, int cursorPosition) {
		String[] row = text.getText().split(LINE_SEPARATOR);
		
		if(row.length == 1) {
			return cursorPosition;
		}
		
		int charDataLength = row[0].length() + LINE_SEPARATOR.length();
		int hexData1Length = charDataLength + row[1].length() + LINE_SEPARATOR.length();
		
		if(cursorPosition < charDataLength) {
			return cursorPosition;
		} else if(cursorPosition < hexData1Length) {
			return cursorPosition - charDataLength;
		} else {
			return cursorPosition - hexData1Length;
		}
	}
	
	protected int getTruePositionBasedOnRowIndexAndPositionOffset(int rowIndex, int caretOffset) {
		if(rowIndex == 0) {
			return caretOffset;
		} else if(rowIndex == 1) {
			return textFromWidgetSplitIntoRows[0].length() + LINE_SEPARATOR.length() + caretOffset;
		} else if(rowIndex == 2) {
			return 2* textFromWidgetSplitIntoRows[0].length() + 2* LINE_SEPARATOR.length() + caretOffset;
		}
		return -1;
	}

	
	/**
	 * The insertToggleFlag determines if we are 
	 * in Insert Mode (TRUE) or Overtype Mode (FALSE)
	 * Used by CustomPasteHandler.
	 * @return the insertToggleFlag
	 */
	public boolean isInsertToggleFlag() {
		return insertToggleFlag;
	}
	
	/**
	 * EventObject can come from CustomPasteHandler or this class.
	 * I didn't want to make two methods so I'm using this method as 
	 * a helper.
	 * 
	 * @param eventObject
	 * @param flag
	 */
	private void updateDoItFlagForEvent(Object eventObject, boolean flag) {
		Event event = null;
		KeyEvent keyEvent = null;
		
		if(eventObject instanceof Event) {
			event = (Event) eventObject;
			event.doit = flag;
		} else if(eventObject instanceof KeyEvent) {
			keyEvent = (KeyEvent) eventObject;
			keyEvent.doit = flag;
		}
	}
	
	private void checkIfPastingToProtectedValue(Object eventObject, Text text, int caretPosition_old, int dataLength, ArrayList<Integer> characterPositionsThatCantBeModified) {
		// we are in CharData
		// check to see if we pasting over protected data		
		for(int x=textCaretPositionTrue; x < textCaretPositionTrue + dataLength; x++) {
			if(characterPositionsThatCantBeModified.contains(new Integer(x))) {
                // cannot paste into protected list
				updateDoItFlagForEvent(eventObject, false);					
				return;
			}
		}			
	}
	
	public String getClipboardDataToBePasted() {
		return clipboardDataToBePasted;
	}

	public void setMaxLengthP(int maxLengthP) {
        // carel06 2014/10/28
        // in SRF mode, we don't care about maxLengthP,
		// we can edit anything up to the visible segment
		if(formatMode instanceof SingleRecordFormatMode) {
			this.maxLengthP = formatMode.getSubstringEndIndex();
		} else {
			this.maxLengthP = maxLengthP;			
		}
	}

	public void setProtectedValues(ArrayList<Integer> protectedValues) {
		log.info("protectedValues: " + protectedValues);
		this.protectedValues = protectedValues;
	}
    
	public void setKeyValues(ArrayList<Integer> keyValues) {
		log.info("keyValues: " + keyValues);
		this.keyValues = keyValues;
	}
	/**
	 * The method generates the updated charData/hexData1/hexData2 portion
	 * based on the updated String from the the Text widget.
	 * 
	 * @author carel06 
	 * @return the updated record which we can send back to mainframe
	 */
	public ArrayList<String> getUpdateRecordRequest() {
        ArrayList<String> result = new ArrayList<String>();
//		boolean isFileMasterRecordFieldUpdated = false; // flag to determine if there if changes have occurred
		

		String[] text = ((Text)textCellEditorFileMaster.getControl()).getText().split(Constants.LINE_SEPARATOR);
		
		// Defect 2688 - carel06 - 20130905
		// if the text being edited does not contain anything.
		// don't send a request to mainframe.
//		if(text[0].length() == 0) {
//			getFormatMode().disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = true;
//			return null;
//		}
		
		// 2014/09/10 navri01
		// we are trying to edit the record 
		// which is already passed the record length (maxLengthP)
		// this should not be allowed
		// we did a "-1" since maxLengthP value is 1 based
        if(formatMode instanceof CharFormatMode) {
        	if(subStringBeginIndex > maxLengthP - 1) {
        		return null;
        	} 

        }
        
        if(formatMode instanceof CharFormatMode) {
        	if(charData != null) {
        		String updatedCharData = "";
        		// charData can be empty
        		if(charData.isEmpty()) {
        			updatedCharData = text[0];
        		} else {
        			String preSubString = "";
        			if(charData.length() >= subStringBeginIndex) {
        				preSubString = charData.substring(0, subStringBeginIndex);
        			}
        			String postSubString = "";
        			if(charData.length() >= subStringEndIndex -1) {
        				postSubString = charData.substring(subStringEndIndex);
        			}
        			updatedCharData = preSubString + text[0] + postSubString;
        		}
        		if(!(charData.equals(updatedCharData))) {
        			result.add(updatedCharData);
        		} else {
        			result.add(null);
        		}
        	}
        } else {
        	log.log(Level.INFO, "CharData:" + charData);
        	log.log(Level.INFO, "TextCellEditor:" + text[0]);
        	// we need to add padding to charDAta if it is more than maxLengthP
        	if(charData != null) {
        		String updatedCharData = "";
        		// charData can be empty
        		if(charData.isEmpty()) {
        			updatedCharData =  text[0];
        		} else {
        			String preSubString = "";
        			if(charData.length() >= subStringBeginIndex) {
        				preSubString = charData.substring(0, subStringBeginIndex);
        			}  else if(charData.length() < subStringBeginIndex) {
        				preSubString = String.format("%1$-" + subStringBeginIndex + "s", charData);
        			}
        			String postSubString = "";
        			if(charData.length() > subStringEndIndex -1) {
        				//navri01&carel06- added -1 to postsubString b/c we were modifying user data
        				postSubString = charData.substring(subStringEndIndex);
        			}
        			updatedCharData = preSubString + text[0] + postSubString;
        		}
        		// carel06 - 2014/11/07
        		// Defect 3203
        		// updatedCharData is not being trimmed
        		// when doing the comparison, it will not be the
        		// same, hence an extra updateRequest is sent
        		// when it should not be.
        		String charDataWithTextWithTrailingSpacesRemoved = charData.replaceFirst("\\s+$", "");
        		String updatedCharDataWithTextWithTrailingSpacesRemoved = updatedCharData.replaceFirst("\\s+$", "");
        		if(!(charDataWithTextWithTrailingSpacesRemoved.equals(updatedCharDataWithTextWithTrailingSpacesRemoved))) {
        			result.add(updatedCharData);
        		} else {
        			// do nothing because no changes
        			//result.add(null);
        		}
        	}
        }
		
		if(hexData1 != null) {
			String updatedHexData1 = "";
			// charData can be empty
			if(hexData1.isEmpty()) {
				updatedHexData1 = text[0];
			} else {
				String preSubString = "";
				if(hexData1.length() >= subStringBeginIndex) {
					preSubString = hexData1.substring(0, subStringBeginIndex);
				}
				String postSubString = "";
				if(hexData1.length() >= subStringEndIndex -1) {
					postSubString = hexData1.substring(subStringEndIndex);
				}
				updatedHexData1 = preSubString + text[1] + postSubString;
			}
			if(!(hexData1.equals(updatedHexData1))) {
                result.add(updatedHexData1);
			} else {
				result.add(null);
			}
		}
		
		if(hexData2 != null) {
			String updatedHexData2 = "";
			// charData can be empty
			if(hexData2.isEmpty()) {
				updatedHexData2 = text[0];
			} else {
				String preSubString = "";
				if(hexData2.length() >= subStringBeginIndex) {
					preSubString = hexData2.substring(0, subStringBeginIndex);
				}
				String postSubString = "";
				if(hexData2.length() >= subStringEndIndex -1) {
					postSubString = hexData2.substring(subStringEndIndex);
				}
				updatedHexData2 = preSubString + text[2] + postSubString;
			}
			if(!(hexData2.equals(updatedHexData2))) {
                result.add(updatedHexData2);
			} else {
				result.add(null);
			}
		}
		
		return result;		
	}

	public void setCharData(String charData) {
		this.charData = charData;
	}

	public void setHexData1(String hexData1) {
		this.hexData1 = hexData1;
	}

	public void setHexData2(String hexData2) {
		this.hexData2 = hexData2;
	}
	//navri01- defect 3200
	//passing segmentFieldType and setting it now
	public void setSegmentFieldType(SegmentFieldType segmentFieldType) {
		this.segmentFieldType = segmentFieldType;
	}
	public void setSubStringBeginIndex(int subStringBeginIndex) {
		this.subStringBeginIndex = subStringBeginIndex;
	}

	public void setSubStringEndIndex(int subStringEndIndex) {
		this.subStringEndIndex = subStringEndIndex;
	}
	
	/**
	 * Determine which protected values to use depending on
	 * textCaretPositionRowIndex.  Different behavior for charData
	 * vs. HexData
	 * @return the protected list.
	 */
	private ArrayList<Integer> getProtectedPositions() {
		if(textCaretPositionRowIndex == 0) {
			return protectedValues;
		} else {
			return keyValues;
		} 
	}
	
	/**
	 * carel06 - 2014/12/10
	 * Defect 3223
	 * Added this method so it can support both SingleRecordFormatMode and CharFormatMode when doing navigation 
	 * in browse mode
	 * 
	 * @param keyEvent
	 * @param editingSupportFileMasterIMS
	 */
	protected void handleNavigationKeysInBrowseMode(KeyEvent keyEvent, EditingSupportFileMasterIMS editingSupportFileMasterIMS) {
		if ((editingSupportFileMasterIMS.getTraverseTable().iskeyTraversed()) == false) {
			if(keyEvent.keyCode == 16777223 || keyEvent.keyCode == 16777224){ //polra04  - #3183 HOME & END not working
				editingSupportFileMasterIMS.getTraverseTable().setkeyTraversed(false); 
			} else {
				keyEvent.doit = false;
			}
		} else {
			editingSupportFileMasterIMS.getTraverseTable().setkeyTraversed(false); 
		}
	}
 }
