package com.ca.fmp.ims.view.handlers;

/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/

/**
* @author NAVRI01
*
*/

import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.EditModeType;
import com.ca.fmp.ims.view.editor.CharFormatMode;
import com.ca.fmp.ims.view.editor.EditingSupportFileMasterIMS;
import com.ca.fmp.ims.view.editor.EditorView;
import com.ca.fmp.ims.view.editor.SRFValueEditingSupport;
import com.ca.fmp.ims.view.editor.SingleRecordFormatMode;

public class CustomPasteHandler extends AbstractHandler {
	
	static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	Logger logger = Logger.getLogger(CustomPasteHandler.class.getName());


	
	/**
	 * @param event
	 * @throws ExecutionException
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {
		logger.log(Level.INFO, "inside CustomPasteHandler");
		
		IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
		
		IWorkbenchPage page = window.getActivePage();
		IWorkbenchPart workbenchPart = page.getActivePart();
		IWorkbenchPartSite workbenchPartSite = workbenchPart.getSite();
		String secondaryId = ((IViewSite) workbenchPartSite).getSecondaryId();		
		EditorView view = (EditorView) page.getActivePart();				
		DisplayModeType mode = view.getDisplayMode();
		Event event2 = ((Event) event.getTrigger());
		Object obj = event2.widget;
		//navri01: added return null condition to fix Cntl+V on protected fields. defect 2881
		if(obj instanceof Table){
			return null;
		}
		Text textWidget = ((Text) obj);
		int caretPosition = textWidget.getCaretPosition();
		
		if(mode == DisplayModeType.C) {
			CharFormatMode charFormatMode = (CharFormatMode) view.getFormatMode();		
			EditingSupportFileMasterIMS characterDataEditingSupport = charFormatMode.getEditingSupportFileMasterIMS();		
			
			//depil01 - the re-instantiation of the variables is necessary because sometimes they go to their default values 
	/*		//when going from char to sf mode then back to char mode
			characterDataEditingSupport.initializeVariables(textWidget);
			if(characterDataEditingSupport.isInsertToggleFlag()  || textWidget.getSelectionCount() > 0) {
				characterDataEditingSupport.pasteInsertMode(event2, textWidget, caretPosition, characterDataEditingSupport.getClipboardDataToBePasted());
			} else {
				characterDataEditingSupport.pasteOvertypeMode(event2, textWidget, caretPosition, characterDataEditingSupport.getClipboardDataToBePasted());
			}			
		} else if(mode.equalsIgnoreCase("S")) {
			SingleRecordFormatMode singleRecordFormatMode = view.getSingleRecordFormatMode();
			SRFValueEditingSupport srfValueEditingSupport = singleRecordFormatMode.getSrfValueEditingSupport();
			if(srfValueEditingSupport.getClipboardDataToBePasted() == null || srfValueEditingSupport.getClipboardDataToBePasted().length() == 0) {
				logger.log(Level.INFO, "nothing to paste");
				return null;
			}
			
			//depil01 - the re-instantiation of the variables is necessary because sometimes they go to their default values
			srfValueEditingSupport.initializeVariables(textWidget);
			if(srfValueEditingSupport.isInsertToggleFlag() || textWidget.getSelectionCount() > 0) {
				srfValueEditingSupport.pasteInsertMode(event2, textWidget, caretPosition, srfValueEditingSupport.getClipboardDataToBePasted());
			} else {
				srfValueEditingSupport.pasteOvertypeMode(event2, textWidget, caretPosition, srfValueEditingSupport.getClipboardDataToBePasted());
			}
		}
			*/
		}
		else if(mode == DisplayModeType.S){
			if(view.getEditMode() == EditModeType.B){
				return null;
			}
		}
		return null;		
		
	}
}
