/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.fmp.ims.view.databaselist.DatabaseListView;
import com.ca.fmp.ims.view.wizards.ConfigureMFSettingsWizard;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class ConfigureMFSettingsHandler extends AbstractHandler implements IElementUpdater {
	static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	private static final FMServerTreeModel model = FMServerTreeModel.getInstance();	
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IWorkbenchWindow window=HandlerUtil.getActiveWorkbenchWindowChecked(event);
		Shell shell = window.getShell();
		
		IWorkbench workbench=window.getWorkbench();
		IViewPart dbList = window.getActivePage().findView("com.ca.fmp.ims.view.databaselist");
		ISelection selection = null;
		if(dbList != null && dbList instanceof DatabaseListView){
			selection = dbList.getViewSite().getSelectionProvider().getSelection();
		}
		if (!(selection instanceof IStructuredSelection))
			selection = null;
		ConfigureMFSettingsWizard configureMFSettingsWizard = new ConfigureMFSettingsWizard();
		configureMFSettingsWizard.init(workbench, (IStructuredSelection) selection);
		TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, configureMFSettingsWizard);
		dialog.create();
		dialog.open();
		return null;			
	}

	@SuppressWarnings("rawtypes")	
	public void updateElement(UIElement element, Map parameters) {
		// TODO Auto-generated method stub		
	}

	
	public boolean isEnabled() {
		return model.getServers().length > 0;
	}

	
	public void setEnabled(Object evaluationContext) {
		// TODO Auto-generated method stub
		super.setEnabled(evaluationContext);
	}
}
