/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.editor;

/**
 * @author depil01
 *
 */

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

import com.ca.fmp.ims.model.UpdateSegmentFieldTypeRequest;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.SegmentFieldType;
import com.ca.fmp.ims.model.generated.YorNType;

public class SRFValueEditingSupport extends EditingSupportFileMasterIMS {
	private static Logger log = Logger.getLogger(SRFValueEditingSupport.class.getName());
//	private String oldCharValue;
//	private int vsamKeyOffset = -1;
//	private int vsamKeyLength = -1;
//	private IMSSegment fileMasterRecord;
	
	protected void handleReturnCode(GUIResponseType response, String charData, String hexData1, String hexData2) {
		// need to reset the error messages and buttons
		((SingleRecordFormatMode)formatMode).setDisableBtns(false);
		((SingleRecordFormatMode)formatMode).setErrorMessage("");
        
		// check if there are any errors.
        // if there are errors, notify using the errorText widget
        // 
		// we are using the messageText as that is the value 
		// also being used in MVS
		if(response.getFunctionRC()!=0 || response.getReturnCode() !=0){
			for(int i=0;i<response.getMessages().getMessage().size();i++){
				List<String> messageText = response.getMessages().getMessage().get(i).getMessageText();
                String messageTextAll = "";
				for(String m: messageText) {
					messageTextAll = m + messageTextAll;
				}

				// carel06 - 2014/11/10
				// Defect 3185
				// On SF mode, the isDirtyFlag remains the same
				// we don't undirty it.
				
				((SingleRecordFormatMode)formatMode).setDisableBtns(true);
				((SingleRecordFormatMode)formatMode).setErrorMessage(messageTextAll);
			}
		} 
		
//		NodeList messages = overTypingResponse.getElementsByTagName("Message");
//		for (int i = 0; i < messages.getLength(); i++) {
//			Node msgNode = (Node) messages.item(i);
//			Element msgElement = (Element) msgNode;
//			NodeList msgList = msgElement.getChildNodes();
//			Node msgValue = (Node) msgList.item(0);
//			errorMessage = msgValue.getNodeValue();
//		}
//
//		if (errorMessage.length() > 0) {
//			((SingleRecordFormatMode)getFormatMode()).setDisableBtns(true);
//			if (errorMessage.startsWith("CAWA546W")) {
//				((SingleRecordFormatMode)getFormatMode()).setDisableBtns(false);
//				errorMessage = "Input value has been truncated ";
//				((SingleRecordFormatMode)getFormatMode()).setErrorMessage(errorMessage);
//			} else {
//				if (errorMessage.startsWith("CAWA")) {
//					if (errorMessage.startsWith("CAWA516I") || errorMessage.startsWith("CAWA167W")
//							|| errorMessage.startsWith("CAWA997W")||errorMessage.startsWith("CAWA549E")|| errorMessage.startsWith("CAWA548E")) {
//						//navri01: added condition for CAWA549E to fix defect 2969 - Save dialog should appear when we try to close the editor
//						((SingleRecordFormatMode)getFormatMode()).setDisableBtns(false);
//					}
//					errorMessage = errorMessage.substring(8);
//				}
//				((SingleRecordFormatMode)getFormatMode()).setErrorMessage(errorMessage);
//			}
//
//		} else {
//			//#2555
//			((SingleRecordFormatMode)getFormatMode()).setDisableBtns(false);
//			((SingleRecordFormatMode)getFormatMode()).setErrorMessage("");
//		}
	}
	public SRFValueEditingSupport(EditorView eView, 
								  TableViewer tableViewer, 
                                  int colName, 
                                  TableViewerColumn tableViewerColumn, 
                                  FormatMode formatMode) {
		// TODO figure out is isSubString is always false when sending to parent class
		// TODO figure out is columnIndex should be 0 when sending it out to parent class.
//		super(viewer, singleRecordFormatMode, 0, 0, false, startIndex, endIndex);
        super(eView, tableViewer, colName, tableViewerColumn, formatMode);
//		vsamKeyOffset = getVsamKeyOffset();
//		vsamKeyLength = getVsamKeyLength();
//		this.fileMasterRecord = fileMasterRecord;
	}

	protected boolean canEdit(Object element) {
        
		SegmentFieldType srfField = null;
		String[] fieldNameAndLevel = null;
		String fieldName = null;
		
		if (!(element instanceof SegmentFieldType)) {
			log.log(Level.WARNING, "not an instance of SRFField");
			return false;
		}
		
		srfField = (SegmentFieldType) element;
		
		/**
		 * This is a group field.
		 * theres no data associated with a group field. As such, the field should not be editable. 
		 * The way youd know is identical to how it was done in the FMMVS Eclipse UI. I dont know 
		 * that coding, but from looking at the xml data, Id say that a group field is a SegmentField 
		 * that doesnt have a CharData child element (in fact no child elements at all). If you have 
		 * a need for an additional group field attribute, let me know.
		 */
		if(srfField.getCharData() == null) {
			log.info("has no charData, not editable");
			return false;
		}
		
		fieldNameAndLevel = srfField.getName().trim().split("\\s+",2);
		fieldName = fieldNameAndLevel[fieldNameAndLevel.length - 1];
		// if isDisableBtns() is true means there's an error. In this case only the field that caused the error can be edited.
		if(((SingleRecordFormatMode) formatMode).isDisableBtns() && !((SingleRecordFormatMode) formatMode).getLastFieldEdited().equals(fieldName)) {
			return false;
		}
		
		if(((SingleRecordFormatMode) formatMode).hasFieldWithErrorAfterEditing() && srfField.getColorData() == YorNType.N) { 
			return false;
		}
		
		if(((SingleRecordFormatMode) formatMode).hasFieldWithErrorAfterEditing() && srfField.getColorData() == YorNType.Y && 
				((SingleRecordFormatMode) formatMode).getFieldsWithErrorFromTheStart().contains(fieldName)) {
			return false;
		}
		
		if(((SingleRecordFormatMode) formatMode).getFieldsWithErrorFromTheStart().contains(fieldName) && srfField.getColorData() == YorNType.N) {
			((SingleRecordFormatMode) formatMode).getFieldsWithErrorFromTheStart().remove(fieldName);
		}

//		if(Integer.parseInt(srfField.getPosition())>SingleRecordFormatMode.recordLength) {
//			return false;
//		}
		
//		if(fileMasterRecord.hasVSAMKey()){
//		if (vsamKeyOffset != -1 && vsamKeyLength != -1) {
//			// carel06 - 2754 - 20130909
//			// need to limit the cursor position to what's currently being 
//			// displayed.  Hence, I added the mimimumValue parameter.
//			int position = Integer.parseInt(srfField.getPosition());
//			int length = srfField.getValue().length();
//				// carel06 Defect 2786 20130912
//				int lastVsamPosition = vsamKeyOffset + vsamKeyLength;
//				log.log(Level.INFO, "position: " + position + " length: " + length + " vsamKeyOffset: " + vsamKeyOffset + " vsamKeyLength: " + vsamKeyLength);
////				log.log(Level.INFO, "x: " + x + " lastVsamPosition: " + lastVsamPosition);				
//				if ((position >= vsamKeyOffset) && (position < lastVsamPosition)) {
//					log.log(Level.INFO, "not editable since this is a vsam key");
//					return false;
//				} 
//
////			int endIndex = getSubStringEndIndex();
////			int minimumValue = Math.min(length, endIndex);
//////			log.log(Level.INFO, "position: " + position + "length: " + length + "endIndex: " + endIndex + "minimumValue: " + minimumValue);
////			for (int x = position; x < position + minimumValue; x++) {
//////				log.log(Level.INFO, "x: " + x);
//////				log.log(Level.INFO, Boolean.toString((x >= vsamKeyOffset)));
//////				log.log(Level.INFO, Boolean.toString((x < (vsamKeyOffset + vsamKeyLength))));
////				if ((x >= vsamKeyOffset) && (x < (vsamKeyOffset + vsamKeyLength))) {
////					log.log(Level.INFO, "not editable since this is a vsam key");
////					return false;
////				}
////			}
//		}
//		}
//		if(fileMasterRecord.hasVSAMKey()){
//		if (((SRFField) element).isProtected()) {
//			log.log(Level.INFO, "not editable since this is protected");
//			return false;
//		}
//		}
		((SingleRecordFormatMode) formatMode).setLastFieldEdited(fieldName);
		return true;
	}

//	private int getVsamKeyOffset() {
//		int offset = -1;
//		if (EditorWizardPageOne.dataSet instanceof FMPVSAMDataset && !((FMPVSAMDataset) EditorWizardPageOne.dataSet).getOffset().isEmpty()) {
//			offset = Integer.parseInt(((FMPVSAMDataset) EditorWizardPageOne.dataSet).getOffset());
//		}
//		return offset;
//	}
//
//	private int getVsamKeyLength() {
//		int length = -1;
//		if (EditorWizardPageOne.dataSet instanceof FMPVSAMDataset && !((FMPVSAMDataset) EditorWizardPageOne.dataSet).getLength().isEmpty()) {
//			length = Integer.parseInt(((FMPVSAMDataset) EditorWizardPageOne.dataSet).getLength());
//		}
//		return length;
//	}

	protected Object getValue(Object element) {
		if(!(element instanceof SegmentFieldType)) {
			log.log(Level.WARNING, "element not instance of SRFField, return empty string instead");
			return "";
		}
		
		// in mainframe, the value of the field is trimmed of spaces
		// we are putting it back.
		SegmentFieldType srfField = (SegmentFieldType) element;
//		String originalSRFFieldValue = srfField.getValue();
		String originalSRFFieldValue = srfField.getCharData();
		
		String paddedValue = String.format("%-"+srfField.getMaxLengthP()+"s", originalSRFFieldValue);
//		srfField.setValue(paddedValue);
		srfField.setCharData(paddedValue);
		
        
		log.log(Level.INFO, "just added padding: " + paddedValue.length() + ":" + paddedValue);
		
		// carel06 Defect 2767 20130912
		// have to make a check so that we don't get a StringIndexOutOfBoundsException
		// handle it by returning an empty string
		if(paddedValue.length() < formatMode.getSubstringEndIndex()) {
			try {
				return srfField.getCharData().substring(formatMode.getSubstringBeginIndex());				
			} catch (StringIndexOutOfBoundsException e) {
				// just return an empty string
				log.log(Level.INFO, "srfField length: " + srfField.getCharData().length() +  " begin index: " + formatMode.getSubstringBeginIndex() + " srfField value: " + srfField.getCharData());
				return "";
			}
		} else {
			try {
				String getValueResult = srfField.getCharData().substring(formatMode.getSubstringBeginIndex(), formatMode.getSubstringEndIndex());
                log.info("getValueResult: " + getValueResult);
				return getValueResult; 				
			} catch (StringIndexOutOfBoundsException e) {
				log.log(Level.INFO, "srfField length: " + srfField.getCharData().length() +  " begin index: " + formatMode.getSubstringBeginIndex() + " end index:" + formatMode.getSubstringEndIndex() + " srfField value: " + srfField.getCharData());
				return "";
			}
		}
	}
	
//	protected int getSubStringEndIndex() {
//		return subStringEndIndex;
//	}
	
//	protected void handleDeleteKey(Text text, int currentPositionButNotRowAware) {
//		
//	}
	
//	private void handleXMLResponse(XMLRequest xmlResponse, boolean fieldEdited) {
//		getFormatMode().getEditorView().updateSRFEditViewer(xmlResponse, false, false, fieldEdited);
//
//		// the request has been sent to the mainframe
//		// let's mark this as dirty
//		getFormatMode().getEditorView().setDirty(true);
//
//		Element overTypingResponse = xmlResponse.getRoot();
//		String errorMessage = "";
//		NodeList messages = overTypingResponse.getElementsByTagName("Message");
//		for (int i = 0; i < messages.getLength(); i++) {
//			Node msgNode = (Node) messages.item(i);
//			Element msgElement = (Element) msgNode;
//			NodeList msgList = msgElement.getChildNodes();
//			Node msgValue = (Node) msgList.item(0);
//			errorMessage = msgValue.getNodeValue();
//		}
//
//		if (errorMessage.length() > 0) {
//			((SingleRecordFormatMode)getFormatMode()).setDisableBtns(true);
//			if (errorMessage.startsWith("CAWA546W")) {
//				((SingleRecordFormatMode)getFormatMode()).setDisableBtns(false);
//				errorMessage = "Input value has been truncated ";
//				((SingleRecordFormatMode)getFormatMode()).setErrorMessage(errorMessage);
//			} else {
//				if (errorMessage.startsWith("CAWA")) {
//					if (errorMessage.startsWith("CAWA516I") || errorMessage.startsWith("CAWA167W")
//							|| errorMessage.startsWith("CAWA997W")||errorMessage.startsWith("CAWA549E")|| errorMessage.startsWith("CAWA548E")) {
//						//navri01: added condition for CAWA549E to fix defect 2969 - Save dialog should appear when we try to close the editor
//						((SingleRecordFormatMode)getFormatMode()).setDisableBtns(false);
//					}
//					errorMessage = errorMessage.substring(8);
//				}
//				((SingleRecordFormatMode)getFormatMode()).setErrorMessage(errorMessage);
//			}
//
//		} else {
//			//#2555
//			((SingleRecordFormatMode)getFormatMode()).setDisableBtns(false);
//			((SingleRecordFormatMode)getFormatMode()).setErrorMessage("");
//		}
//	}

//	private static int getNewODOValue(Element odo) {
//		if (odo.hasAttribute("newValue")) {
//			String newValue = odo.getAttribute("newValue");
//			if (newValue.isEmpty())
//				return -1;
//			return Integer.parseInt(newValue);
//		}
//		return -1;
//	}

//	private static int getMaxODOValue(Element odo) {
//		if (odo.hasAttribute("maxValue")) {
//			String maxValue = odo.getAttribute("maxValue");
//			if (maxValue.isEmpty())
//				return -1;
//			return Integer.parseInt(maxValue);
//		}
//		return -1;
//	}

//	private static int getNewRecordLength(Element odo) {
//		if (odo.hasAttribute("newRecLen")) {
//			String newRecLen = odo.getAttribute("newRecLen");
//			if (newRecLen.isEmpty())
//				return -1;
//			return Integer.parseInt(newRecLen);
//		}
//		return -1;
//	}
	
//	private static int getMaxRecordLength(Element odo) {
//		if (odo.hasAttribute("maxRecLen")) {
//			String maxRecLen = odo.getAttribute("maxRecLen");
//			if (maxRecLen.isEmpty())
//				return -1;
//			return Integer.parseInt(maxRecLen);
//		}
//		return -1;
//	}

//	@Override
//	protected void updateView(XMLRequest xmlResponse, boolean fieldEdited) {
//		if (xmlResponse != null) {
//			Element root = xmlResponse.getRoot();
//			if (root.getTagName().equalsIgnoreCase(MFREQUEST)) { // Mainframe
//																	// is
//																	// making
//																	// a
//																	// request
//				XMLRequest updatedXMLResponse = getFormatMode().getEditorView().ParsingMFRequest(xmlResponse);
//				if (updatedXMLResponse != null) {
//					if(getFormatMode().getEditorView().isContinueToEdit()){
//						xmlResponse = updatedXMLResponse;
//					}else{
//						getFormatMode().getEditorView().setEditEnd("Y");
//						//isSaveOnCloseNeeded();
//						IViewPart view;
//						IViewReference viewRef = getFormatMode().getWorkbenchPage().findViewReference(EditorView.ID, getFormatMode().getSecondaryId());
//						if (viewRef != null) {
//							view = viewRef.getView(false);
//							if (view != null) {								
//								getFormatMode().getWorkbenchPage().hideView(view);
//								//return 0;
//							}
//						} 
//					}
//					
//				} else {
//					Element firstChild = (Element) root.getFirstChild();
//					if (firstChild.getTagName().equalsIgnoreCase(ODOCHANGE)) { // ODO
//																				// value
//																				// change
//																				// occured
//																				// and
//																				// we
//																				// need
//																				// to
//																				// make
//																				// sure
//																				// the
//																				// change
//																				// is
//																				// valid.
//						/* Show ODO change confirmation dialog */
//						int newODOValue = getNewODOValue(firstChild);
//						int newRecordLength = getNewRecordLength(firstChild);
//
//						/*
//						 * User confirmed the change therefore we need to
//						 * calculate the following values and make sure
//						 * change is valid
//						 */
//						int maxODOValue = getMaxODOValue(firstChild);
//						int maxRecordLength = getMaxRecordLength(firstChild);
//
//						if (newODOValue > maxODOValue) {
//							MessageDialog.openError(getTableViewer().getControl().getShell(), "Edit Length Modification", "The new value in an occurs depending on field is out of range.\n\nNew ODO value: " + newODOValue + "\n\nMaximum ODO value: " + maxODOValue);
//							RunSetODOChange runner = new RunSetODOChange(getFormatMode().getFileMasterServer(), getFormatMode().getUUID(), false);
//							BusyIndicator.showWhile(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), runner);
//							xmlResponse = runner.getXml();
//						} else if (newRecordLength > maxRecordLength) {
//							MessageDialog.openError(getTableViewer().getControl().getShell(), "Edit Length Modification", "The recalculated record length exceeds the maximum due to a change in an occurs\ndepending on field.\n\nRequired record length: " + newRecordLength + "\n\nMaximum record length: " + maxRecordLength);
//							RunSetODOChange runner = new RunSetODOChange(getFormatMode().getFileMasterServer(), getFormatMode().getUUID(), false);
//							BusyIndicator.showWhile(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), runner);
//							xmlResponse = runner.getXml();
//						} else { // The change of ODO is valid so we send
//									// the updated values to MF.
//							boolean ODOChangeConfirm = MessageDialog.openConfirm(getTableViewer().getControl().getShell(), "Edit Length Modification", "The length of the record changes due to a change in an occurs depending on field.\n\nNew record length: " + newRecordLength + "\n\nNew ODO value: " + newODOValue);
//							RunSetODOChange runner = new RunSetODOChange(getFormatMode().getFileMasterServer(), getFormatMode().getUUID(), ODOChangeConfirm);
//							BusyIndicator.showWhile(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), runner);
//							xmlResponse = runner.getXml();
//						}
//
//					}
//				}
//			}
//		}
//
//		handleXMLResponse(xmlResponse, fieldEdited);
//	}
//	
//	protected FileMasterRecord setupFileMasterRecordRequestMessage() {
//		if(srfField == null) {
//			log.log(Level.WARNING, "srfField is null");
//			return null;
//		}
//		
//		String valueFromTextCellEditor = textCellEditorFileMaster.toString();
//		
//		// we need to only send the recordField that has been modified
//		FileMasterRecordField fileMasterRecordField = new FileMasterRecordField();
//		fileMasterRecordField.getLayoutField().setId(srfField.getId());
//		// get the update value from the textCellEditing
//		// this is stored in the textText variable.
//		String charData = srfField.getValue();
//		
//		
//		// carel06 - Defect 2763
//		// if the value is not being displayed, there is no need to send to MF new values
//		// there was never any values to begin with
//		if(charData.length() < getSubStringBeginIndex()) {
//		log.log(Level.INFO, "length: " + charData.length() + " charData: " + charData + " beginIndex: " + getSubStringBeginIndex() + " endIndex: " + getSubStringEndIndex());
//			log.log(Level.INFO, "nothing was displayed, not sending");
//			return null;
//		}
//		
//		String preNewValue = charData.substring(0, getSubStringBeginIndex());
//		String postNewValue = "";
//		if(charData.length() >= getSubStringEndIndex() + 1) {
//			postNewValue = charData.substring(getSubStringEndIndex());
//		}
//		String newValue = preNewValue + valueFromTextCellEditor + postNewValue;
//		log.log(Level.INFO, "charData: " + charData + " preNewValue: " + preNewValue + " valueFromTextCellEditor: " + valueFromTextCellEditor + " postNewValue: " + postNewValue);
//		if(newValue.equals(srfField.getValue())) {
//			log.log(Level.INFO, "updated value is the same as original value, not sending");
//			return null;
//		}
//		srfField.setValue(newValue);
//		if(srfField.getCharDataHex().equalsIgnoreCase("Y")) {
//			fileMasterRecordField.setCharDataHex("Y");
//		}
//		fileMasterRecordField.setMaxLengthP(getMaxLengthP()+"");
//		fileMasterRecordField.setCharData(newValue);
//		
//		FileMasterRecord fileMasterRecord = new FileMasterRecord();	
//		fileMasterRecord.setNumber(srfField.getRecordNumber());
//		fileMasterRecord.getRecordFields().add(fileMasterRecordField);	
//		return fileMasterRecord;
//	}

	/**
	 * carel06 - 20130822
	 * this used to return getFormatLength
	 * but I think that was incorrect.
	 * What the maxLengthP variable represent
	 * the max allowable number of characters to enter 
	 * in the field.
	 */
//	protected int getMaxLengthP() {
//		return srfField.getMaxLengthP();
//	}
	
//	protected ArrayList<Integer> getProtectedList(FileMasterRecord aFileMasterRecord, FileMasterRecordField fmrecordfield,int dataColumnNumber, int maximumNumberOfCharactersPerColumn) {
//		log.log(Level.INFO, "single record format mode does not have any protected lists");
//		// just return an empty list, it's safer than returning null
//		return new ArrayList<Integer>();
//	}
	
//	protected ArrayList<Integer> getProtectedListInCharData() {
//		log.log(Level.INFO, "single record format mode does not have any protected lists");
//		// just return an empty list, it's safer than returning null
//		return new ArrayList<Integer>();
//	}
	/** 
	 * In SingleRecordFormatMode, you can always insert extra characters
	 * It's up to the mainframe to validate it.
	 * 
	 * (non-Javadoc)
	 * @see com.ca.filemaster.editor.virtualtableviews.EditingSupportFileMaster#isInsertable(java.lang.String, int, int)
	 */
//	protected boolean isInsertable(String text, int caretPosition, int numberOfCharactersToInsert) {
//		return true;
//	}
//	
//	protected boolean isInsertable(String text, int caretPosition) {
//		return true;
//	}

//	@Override
//	protected void setCursor(Text fileMasterPlusText) {
//		// set the proper cursor position when there are a mouse up event
//		int positionInText = fileMasterPlusText.getCaretPosition() + getSubStringBeginIndex();
//		FMPCursor fmpCursor = getFormatMode().getEditorView().getCursor();
//		fmpCursor.setCursorOffset(positionInText);
//		fmpCursor.setRecordNumber(srfField.getRecordNumber());
//		int position = new Integer(srfField.getPosition()).intValue();
//		fmpCursor.setFieldPosition(position);
//		int fieldId = new Integer(srfField.getId()).intValue();
//		fmpCursor.setFieldId(fieldId);
//		fmpCursor.setManuallyChanged(true);
//		getFormatMode().getEditorView().setCursor(fmpCursor);
//	}
	
	/**
	 * carel06 20131002
	 * During Pre-QA Testing we figured out that this doesn't work.
	 * The one in EditingSupportFileMaster supports both
	 * CharacterMode and SingleREcordFormatMode.
	 * 
	 * The terminating character position in SRM is different
	 * from the other modes.
	 * I am just returning either maxLengthP or the lenght of the source text.
	 * 
	 * @parra12: terminating character position was not taking into account the fact 
	 * that we can fit only part of data on screen and there fore was cause out of bounds issue.
	 */
//	protected int getLastCursorPositionForDeletion(String source, int caretPosition) {
//		// carel06 20130917 defect 2795
//		// had to comment this out.
//		// doesn't make sense when doing the steps to replicate the defect
//		// depil 20131004 - This should work now
//		// carel06 20131004 Had to add "+getSubSTringBeginIndex since it doesn't always start with 0.
//    	return source.length() + 1 + getSubStringBeginIndex();		
//	}
	
	/**
	 * carel06 / Defect 2954
	 * Had to create a sepate method for this since
	 * it is being handled differently in CharMode vs. SingleRecordFormatMode.
	 * 
	 * @param valueOfText
	 * @param terminatingCharacterPosition
	 * @return
	 */
//	protected String deleteCharacterWhileEditing(String valueOfText, int terminatingCharacterPosition) {
//		String firstSubString = valueOfText.substring(0   , terminatingCharacterPosition - 2);
//		String secondSubString = valueOfText.substring(terminatingCharacterPosition -1, valueOfText.length());
//		valueOfText = firstSubString + secondSubString;
//		return valueOfText;
//	}
	/*protected int getLastCursorPositionForInsertion(String source, int caretPosition) {
		log.log(Level.INFO, "source: " + source + "caretPosition: " + caretPosition + " maxLengthP: " + getMaxLengthP());
		return getMaxLengthP();
	}*/
	
	/**
	 * 2013/09/19 - carel06 - 2756
	 * The end user can enter as many characters as they want.
	 * Unlimited in SRM but if the field is visible full, then no more additional characters.
	 * 
	 * You can insert into the SRF Record Field but ones its all full, 
	 * you are not able to anymore
	 */
//	protected boolean isInsertable(String text, int caretPosition, int numberOfCharactersToInsert) {
//		int beginIndex = getSubStringBeginIndex();
//		int endIndex = getSubStringEndIndex();
//		int caretPositionIncludingOffset = beginIndex + textCaretPosition;
//		capacity = (endIndex - beginIndex); //@parra1@: because 0 based so +1.
//		log.log(Level.INFO, "begin index: " + beginIndex + " end index: " + endIndex + " textCaretPosition: " + textCaretPosition + " caretPositionIncludingOffset: " + caretPositionIncludingOffset);
//		log.log(Level.INFO, "text length: " + text.length() + " capacity: " + capacity + " text: " + text);
//		//int numberOfSpacesBeforeTerminatingPosition = Constants.getNumberOfTrailingSpaces(text);
//		boolean testForSelection = false;
//		if(textFromKeyPressed.getSelectionCount() == 0)  {
//			testForSelection = text.trim().length() + numberOfCharactersToInsert > capacity;			
//		} else {
//			// we have to subtract the characters that have been selected
//			// since they will be deleted.
//			testForSelection = text.trim().length() + numberOfCharactersToInsert - textFromKeyPressed.getSelectionCount() > capacity;
//		}
//		if(text.trim().length() > capacity ||  textCaretPositionTrue > endIndex || testForSelection) {
//			log.log(Level.INFO, "no longer to insert");
//			return false;
//		}
//		
//		// default is to return true
//		return true;
//	}
	
	/**
	 * 2013/09/19 - carel06 - 2756
	 * The end user can enter as many characters as they want.
	 * Unlimited in SRM but if the field is visible full, then no more additional characters.
	 * 
	 * 2013/09/10 - carel06 - 2751
	 * There are special cases for single record mode that has
	 * to be handled uniquely. Hence, overwriting the method found
	 * in EditingSupportFileMaster.
	 */
//	protected void isEndOfRecordField(KeyEvent keyEvent) {
//		int beginIndex = getSubStringBeginIndex();
//		int endIndex = getSubStringEndIndex();
//		int caretPositionIncludingOffset = beginIndex + textCaretPosition;
//		log.log(Level.INFO, "begin index: " + beginIndex + " end index: " + endIndex + " textCaretPosition: " + textCaretPosition + " caretPositionIncludingOffset: " + caretPositionIncludingOffset);
//		if(caretPositionIncludingOffset >= endIndex) {
//			log.log(Level.INFO, "forward acting and already at the end of the record field, have reached end of substring, do nothing");
//			keyEvent.doit = false;
//			return;
//		}
//	}

//	@Override
//	protected boolean canPasteOvertypeMode(Object eventObject, Text text, int caretPositionOffset, String clipboardData) {
//		int endIndex = getSubStringEndIndex();
//		int beginIndex = getSubStringBeginIndex();
//		if ((beginIndex + caretPositionOffset + clipboardData.length()) <= endIndex) {
//			return true;
//		}
//		return false;
//	}
	
//	@Override
//	protected void deleteAndInsertToData(Text text, int caretPosition_old, String stringThatWillBePasted) {
//		log.log(Level.INFO, "pasteOvertype before --> " + text.getText() + ":" + text.getCaretPosition());
//		String valueOfText = new String(text.getText());
//		StringBuffer valueOfTextBuffer = new StringBuffer(valueOfText);
//		for(char c: stringThatWillBePasted.toCharArray()) {
//			// this replaces the character in the current position with the one 
//			// newly typed.  also need to update the cursor position
//            
//			// TODO: commented out this if clause.. need to verify it again.
//			if(valueOfTextBuffer.length() > caretPosition_old) {
//				valueOfTextBuffer.deleteCharAt(caretPosition_old);
//			}
//			valueOfTextBuffer.insert(caretPosition_old, c);
//			
//			valueOfText = valueOfTextBuffer.toString();
//			String preValueOfText = valueOfText.substring(0, caretPosition_old);
//			String postValueOfText = valueOfText.substring(caretPosition_old + 1, valueOfText.length());
//			valueOfText = preValueOfText + postValueOfText;
//			valueOfText = preValueOfText + c + valueOfText.substring(caretPosition_old, valueOfText.length());
//			text.setText(valueOfText.toString());
//			caretPosition_old = moveToNextCharacter(text, caretPosition_old);
//		}
//		log.log(Level.INFO, "pasteOvertype after --> " + text.getText() + ":" + text.getCaretPosition());
//		
//		makeEditorDirty();
//	}
	
	@Override
	protected void setTextLimit(String hexData1, int maxLengthP, Text text) {
		// in SRF mode, there is no text limit 
		// this is how it works in MVS,
		// it is up to the MF to verify the length
		// we just let the user enter as many characters as visibly allowed.

		// carel06 - 2014/11/21
		// we had to update this.  now it is just x.
        // carel06 - 2014/11/07
		// There was a defect that Kip was mentioning when overtyping in SF mode.
		// we only view x amount but was able to overtype x + 1 number of characters.
		// by setting the text limit to x - 1, we can only overtype what is displayed.
        text.setTextLimit(numberOfCharactersThatWeCanDisplay);
	}
	
	/**
	 * carel06 - Defect 3182
	 * Update the table items for the different modes.
	 * In CharFormatMode, we only update one tableItem
	 * In SF mode, we update all the table items provided.
     * 
     * IN SF Mode, there is no hexData values so I am stripping it out.
     * 
     * TODO: we can refactor this method a little better but for now, it works fine.
	 */
	@Override
	protected void updateTableItems(String charData, String hexData1, String hexData2) {
		List<SegmentFieldType> segmentFields = response.getEditResponse().getSegmentList().getSegment().get(0).getSegmentFields().getSegmentField();
        
		for(int i=0; i < segmentFields.size(); i++) {
			TableItem item = tableViewer.getTable().getItem(i);
			// carel06 - 20141023
	        // when dealing with SingleRecordFormatMode
			// we assign the field types properly
			SegmentFieldType data = segmentFields.get(i);
	        String name = getNameIndented(response.getEditResponse().getSegmentList().getSegment().get(0), i);
	        item.setText(0, name);
	        item.setText(1, String.valueOf(data.getPosition()));
	        String formatData = getFormatChar(response.getEditResponse().getSegmentList().getSegment().get(0), i);
	        item.setText(2, formatData); 
	        data.setFormatChar(formatData);
	        data.setName(name);
	        item.setData(data);
	        
	        String charDataStripped = "";
	        if(data.getCharData() != null){
	        	charDataStripped = data.getCharData().length()<formatMode.getSubstringBeginIndex() ? "" : data.getCharData().substring(formatMode.getSubstringBeginIndex(),data.getCharData().length()<formatMode.getSubstringEndIndex()?data.getCharData().length() : formatMode.getSubstringEndIndex());	
	        }
	        
	        item.setText(3, charDataStripped);			
		}
	}
	
	@Override
	public void focusGained(FocusEvent arg0) {
		// we need to update the values for subStringBeginIndex and subStringEndIndex
		// in the focusGained method because it is not being updated correctly 
		// inside the FileMasterPlusKeyListener.
		// when we scroll, we don't register the index values properly.
		if(fileMasterPlusKeyListener != null) {
			fileMasterPlusKeyListener.setSubStringBeginIndex(formatMode.getSubstringBeginIndex());
			fileMasterPlusKeyListener.setSubStringEndIndex(formatMode.getSubstringEndIndex());
		}
	}

	
	/*
     * carel06 - 20141105
     * overwrote the focusLost method from EditingSupportFileMaster to focus on 
     * SRF mode only.  Thought it would be simple this way.
     * 
	 * (non-Javadoc)
	 * @see com.ca.fmp.ims.view.editor.EditingSupportFileMasterIMS#focusLost(org.eclipse.swt.events.FocusEvent)
	 */
	@Override
	public void focusLost(FocusEvent arg0) {
      
		if(fileMasterPlusKeyListener==null){
			return;
		}
		
        ArrayList<String> updatedResult = fileMasterPlusKeyListener.getUpdateRecordRequest();
        if(updatedResult == null || updatedResult.size() == 0) {
        	response = null; // Set response to null, prevent from the previous run
        	return;
        }

		segmentFieldType.setCharData(updatedResult.get(0));
    	File file = new UpdateSegmentFieldTypeRequest(editorView.getServer(),segmentFieldType, editorView.getCurrentSegment().segmentType).createXML();
    	updateXMLDocumentAndSend(file);
    	
        // we need to combine the original value with the value from the 
        // visible text widget.
//        String preNewValue = "";
//        try {
//        	preNewValue = segmentFieldType.getCharData().substring(0, formatMode.getSubstringBeginIndex());
//        } catch(StringIndexOutOfBoundsException e) {
//            preNewValue = segmentFieldType.getCharData();
//            int numberOfSpacesToAdd = formatMode.getSubstringBeginIndex() - segmentFieldType.getCharData().length();
//            for(int i=0; i < numberOfSpacesToAdd; i++) {
//            	preNewValue = preNewValue + " ";
//            }
//        }
//		String postNewValue = "";
//		if(segmentFieldType.getCharData().length() >= formatMode.getSubstringEndIndex() + 1) {
//			postNewValue = segmentFieldType.getCharData().substring(formatMode.getSubstringEndIndex());
//		}
//		String newValue = preNewValue + updatedResult.get(0) + postNewValue;
//        
//		if(newValue.equals(segmentFieldType.getCharData())) {
//            log.info("updated value is the same as original value, not sending");
//			return;
//		}
//
//		if(newValue != null && segmentFieldType != null && editorView.getEditMode() != EditModeType.B) {
//			segmentFieldType.setCharData(newValue);
//        	File file = new UpdateSegmentFieldTypeRequest(editorView.getServer(),segmentFieldType, editorView.getCurrentSegment().segmentType).createXML();
//        	updateXMLDocumentAndSend(file);
//		}
	}
}