/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/
package com.ca.fmp.ims.view.databaselist;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

import com.ca.fmp.ims.common.FileMasterDataset;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.testingtools.core.ITreeWrappedItem;
import com.ca.testingtools.core.TT_TreeItem;

public class DatabaseListViewComparator extends ViewerComparator {
	static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	@Override
	public int compare(Viewer viewer, Object element1, Object element2) {
	    if (element1 instanceof TT_TreeItem && element2 instanceof TT_TreeItem) {
	        ITreeWrappedItem value1 = ((TT_TreeItem)element1).getValue();
            ITreeWrappedItem value2 = ((TT_TreeItem)element2).getValue();
            if (value1 instanceof FileMasterDataset && value2 instanceof FileMasterDataset) {
                return value1.getName().compareTo(value2.getName());
            } else if (value1 instanceof FileMasterServer && value2 instanceof FileMasterServer) {
                return value1.getName().compareTo(value2.getName());
            }
	    }
		return 0;
	}
	
}