/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.databaselist;

/**
 * @author navri01
 *
 */
import java.util.Iterator;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.testingtools.core.TT_TreeItem;

public class DatabaseListPropertyTester extends PropertyTester {

	static String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$

	public DatabaseListPropertyTester() {
		// TODO Auto-generated constructor stub
	}

	@Override
	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
		if (receiver instanceof TT_TreeItem) {
			TT_TreeItem treeitem = null;
			boolean isdataset = false;
			boolean isserver = false;

			if (receiver instanceof TT_TreeItem) {
				treeitem = (TT_TreeItem) receiver;
			} else {
				return false;
			}
			boolean getParent = false;
			for (Object obj : args) {
				if (obj.toString().equalsIgnoreCase("getparent")) {
					getParent = true;
					break;
				}
			}
			TT_TreeItem result = null;
			if ("isServer".equals(property)) {
				result = treeitem.getParent(FileMasterServer.class);
				return getParent ? result != null : result == treeitem;
			} 
			else if ("isdsndser".equals(property)) {
				IWorkbench wb = PlatformUI.getWorkbench();
				IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
				IWorkbenchPage page = win.getActivePage();
				ISelection selection = page.getSelection();
				result = treeitem.getParent();
				if (result != null) {
					if (selection instanceof TreeSelection) {
						TreeSelection sel = (TreeSelection) selection;
						Iterator<?> it = sel.iterator();
						while (it.hasNext()) {
							Object obj = it.next();
							if (obj instanceof TT_TreeItem) {
								TT_TreeItem next = (TT_TreeItem) obj;
								if (next.getParent() != null) {
									isdataset = true;
								} else {
									isserver = true;
								}

							}
						}
						if (isdataset && isserver) {
							return true;
						}
					}
				}
				return false;
			}

	


		else if (receiver instanceof IStructuredSelection) {
			IStructuredSelection selection = (IStructuredSelection) receiver;
			if (!(selection instanceof TreeSelection) || selection.size() == 0) {
				return false;
			}

			else if ("hasSameParent".equals(property)) {
				TreeSelection sel = (TreeSelection) selection;
				if (sel.size() == 1) {
					return true;
				}
				if (sel.getFirstElement() instanceof TT_TreeItem) {
					TT_TreeItem itemToTest = ((TT_TreeItem) sel.getFirstElement()).getParent();
					Iterator<?> it = sel.iterator();

					while (it.hasNext()) {
						TT_TreeItem obj = (TT_TreeItem) it.next();
						if (obj == null) {
							return false;
						}
						if (obj.getParent() == null || itemToTest == null) {
							return false;
						}
						if (!obj.getParent().equals(itemToTest)) {
							return false;
						}
					}
					return true;
				}

			}

		}
		}
		return false;
	}
}

