/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.ckey;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

import com.ca.fmp.ims.model.generated.CKeyEntryType;
import com.ca.fmp.ims.model.generated.CKeyFieldType;
import com.ca.fmp.ims.model.generated.RangeListType;

public class ConcatenatedKeyValueLabelProvider extends StyledCellLabelProvider {
	private TextLayout layout;
	private Shell shell;
	
	public ConcatenatedKeyValueLabelProvider(TextLayout layout, Shell shell){
		this.layout = layout;
		this.shell = shell;
	}

	@Override
	protected void paint(Event event, Object element) {
		layout.setFont(JFaceResources.getTextFont());
		layout.setText(((TableItem)event.item).getText(1));
		
		TextStyle protectedField = new TextStyle(JFaceResources.getTextFont(),
				shell.getDisplay().getSystemColor(SWT.COLOR_LIST_FOREGROUND),
				shell.getDisplay().getSystemColor(SWT.COLOR_GRAY));
		
		for(CKeyFieldType cKeyField : ((CKeyEntryType)element).getCKeyField()){
			RangeListType protectedList = cKeyField.getProtectedList();
			
			if(protectedList != null){
				int start, end;
				
				for(int countProtectedFields = 0; countProtectedFields < protectedList.getRange().size(); countProtectedFields++){
					start = (int)protectedList.getRange().get(countProtectedFields).getStart() - 1;
					end = (int)protectedList.getRange().get(countProtectedFields).getEnd() - 1;
					
					doColumnHighlight(protectedField, start, end, false);
				}
			}
		}
		
		layout.draw(event.gc, event.x, event.y);
	}
	
	private void doColumnHighlight(TextStyle highlightStyle, int start, int end, boolean hex){
		layout.setStyle(highlightStyle, start, end);

//		if(hex){
//			//assume same length for char and hex data
//			layout.setStyle(highlightStyle,
//					layout.getText().length() + start + 1,
//					layout.getText().length() + end + 1);
//			layout.setStyle(highlightStyle,
//					layout.getText().length() + start + 2,
//					layout.getText().length() + end + 2);
//		}
	}
	
	@Override
	protected void measure(Event event, Object element) {
		if(element == null) {
//			log.log(Level.WARNING, "element is null");
			return; // do nothing
		}


		if(event == null) {
//			log.log(Level.WARNING, "event is null");
			return; // do nothing
		}

		Point size = event.gc.textExtent("");
		CKeyEntryType cKeyEntry = (CKeyEntryType) element;
		if (cKeyEntry.getCKeyField() != null && cKeyEntry.getCKeyField().size() > 0) {
			
			// check if we are displaying one line or three
			// is hex mode "on"
			size = event.gc.textExtent("H");
			
			if(cKeyEntry.getCKeyField().get(0).getHexData1() != null){
				event.height = (int) Math.ceil(size.y * 3.125);
			} else {
				event.height = size.y;
			}
		}
		
	}
}
