/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/

package com.ca.fmp.ims.view;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import com.ca.fmp.ims.view.ckey.ConcatenatedKeyView;
import com.ca.fmp.ims.view.databaselist.DatabaseListView;
import com.ca.testingtools.core.IConstants;
/**
 * 
 * Generates the initial page layout and visible action set for a page. 
 *
 */
public class PerspectiveFactory implements IPerspectiveFactory {
	protected final static String PREFIX = Activator.PLUGIN_ID + "."; //$NON-NLS-1$
	protected final static String LEFT = PREFIX + "Left"; //$NON-NLS-1$
	protected final static String RIGHT = PREFIX + "Right"; //$NON-NLS-1$
	//grake02 23/FEB/2016 protected final static String BOTTOM = PREFIX + "Bottom"; //$NON-NLS-1$
	@SuppressWarnings("unused")
	//grake02 23/FEB/2016 protected final static String MIDDLERIGHT = PREFIX + "MiddleRight"; //$NON-NLS-1$
	//grake02 23/FEB/2016 protected final float left = 0.20f;
	//grake02 23/FEB/2016 protected final float right = 0.70f;
	protected final float left = 0.60f;
	protected final float right = 0.40f;
	//grake02 23/FEB/2016 protected final float bottom = 0.05f;  
	@SuppressWarnings("unused")
	//grake02 23/FEB/2016 protected final float middleright = 0.70f;

	/**
	 * @param layout
	 */
	public void createInitialLayout(final IPageLayout layout) {
		layout.setFixed(false);
		//grake02 23/FEB/2016 layout.setFixed(false);
		final String editorArea = IPageLayout.ID_EDITOR_AREA;
		final IFolderLayout leftFolder = layout.createFolder(LEFT, IPageLayout.LEFT, left, editorArea);
		final IFolderLayout rightFolder = layout.createFolder(RIGHT, IPageLayout.RIGHT, right, editorArea);
		
		leftFolder.addView(DatabaseListView.ID);
		//grake02 23/FEB/2016 final IFolderLayout bottomFolder = layout.createFolder(BOTTOM, IPageLayout.BOTTOM, bottom, editorArea);
		//grake02 23/FEB/2016 bottomFolder.addPlaceholder(IPageLayout.ID_BOOKMARKS);
		//grake02 23/FEB/2016 bottomFolder.addPlaceholder(IPageLayout.ID_TASK_LIST);
		//grake02 23/FEB/2016 bottomFolder.addPlaceholder(IPageLayout.ID_PROP_SHEET);
		//grake02 17/FEB/2016 - no longer view error log and progress view by default.
		//grake02 bottomFolder.addView(IConstants.VIEW_ERROR_LOG);
		//grake02 bottomFolder.addView(IPageLayout.ID_PROGRESS_VIEW); // for CA debugging only
		rightFolder.addView(ConcatenatedKeyView.ID); //grake02 23/FEB/2016 - open concatenated key view on the right
		layout.setEditorAreaVisible(false);

	}

}
