/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizards;

import java.util.HashMap;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.StatusLineContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;

import com.ca.fmp.ims.model.SegmentRequest;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.editor.CharFormatMode;
import com.ca.fmp.ims.view.editor.EditorView;
import com.ca.fmp.ims.view.editor.FormatMode;
import com.ca.fmp.ims.view.editor.SingleRecordFormatMode;
import com.ca.fmp.ims.view.wizardpages.SegmentCommandWizardPage;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;

public class SegmentCommandWizard extends Wizard implements INewWizard {
	public SegmentCommandWizardPage page;
	private static int segmentCommandWizardCount = 0;
	private EditorView editorView;
	private FormatMode mode;

	/**
	 * Requirment to only have one instance of Segment Dialog box. We can
	 * monitor the number of instance using the segmentCommandWizardCount
	 * variable.
	 * 
	 * @return number of instance of Segment Dialog box
	 */
	public static int getSegmentCommandWizardCount() {
		return segmentCommandWizardCount;
	}

	public SegmentCommandWizard(EditorView editorView, FormatMode mode) {
		super();
		this.editorView = editorView;
		this.mode = mode;
		setWindowTitle("Filter Segments");
		segmentCommandWizardCount++;
	}

	@Override
	public void dispose() {
		segmentCommandWizardCount--;
		super.dispose();
		if (mode instanceof CharFormatMode) {
			((CharFormatMode) mode).putCursor();
		} else if (mode instanceof SingleRecordFormatMode){
			((SingleRecordFormatMode) mode).putCursor();
		} 
	}

	@Override
	public void addPages() {
		page = new SegmentCommandWizardPage();
		addPage((IWizardPage) page);
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {}

	@Override
	public boolean performFinish() {
		editorView.setSegmentState(page.getState());
		
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new SegmentRequest(
					editorView.getServer(),
					((IViewSite) editorView.getSite()).getSecondaryId(),
					editorView.getSegmentState()).createXml());
		} catch (TTException e1) {
			e1.printStackTrace();
		}
		
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req = new SendRequestToMainframe(
				editorView.getServer(), map, "opendb", true, xmlDocument);

		do {
		} while (req.getResult() != Status.OK_STATUS);

		GUIResponseType response = req.getGuiResponseType();
		
		if(editorView.isSegmentCmdActive){
			((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
					.getStatusLineManager().find("segmentCommand")).setText("SEG");			
		} else {
			((StatusLineContributionItem) ((IViewSite) editorView.getViewSite()).getActionBars()
					.getStatusLineManager().find("segmentCommand")).setText(" ");
		}

		if(mode instanceof CharFormatMode){
			((CharFormatMode)mode).updateDisplay(response, true);
			return true;
		}
		
		if(mode instanceof SingleRecordFormatMode){
			((SingleRecordFormatMode)mode).updateDisplay(response);
			return true;
		}
		
		return false;
	}
	
	public EditorView getEditorView(){
		return editorView;
	}
	
	public FormatMode getFormatMode(){
		return mode;
	}
}
