/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import com.ca.fmp.ims.view.editor.CharFormatMode;
import com.ca.fmp.ims.view.editor.FormatMode;
import com.ca.fmp.ims.view.editor.SingleRecordFormatMode;
import com.ca.fmp.ims.view.wizardpages.LocateKeyCommandWizardPage;


public class LocateKeyCommandWizard extends Wizard implements INewWizard {
	public LocateKeyCommandWizardPage page;
	private FormatMode mode;
	
	public LocateKeyCommandWizard(FormatMode mode) {
		super();
		setWindowTitle("Locate Key");
		this.mode = mode;
	}
	
	@Override
	public void dispose() {
		super.dispose();
		if (mode instanceof CharFormatMode) {
			((CharFormatMode) mode).putCursor();
		} else if (mode instanceof SingleRecordFormatMode){
			((SingleRecordFormatMode) mode).putCursor();
		} 
	}

	@Override
	public void addPages() {
		page = new LocateKeyCommandWizardPage();
		addPage((IWizardPage) page);
	}
	
	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		
	}

	@Override
	public boolean performFinish() {
		return page.doFinish();
	}
	
	public LocateKeyCommandWizardPage getPage() {
		return page;		
	}

}
