/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.model.generated.SegmentCmdInfoType;
import com.ca.fmp.ims.model.generated.SegmentCmdStateType;
import com.ca.fmp.ims.model.generated.SegmentInfoListType;
import com.ca.fmp.ims.model.generated.SegmentInfoType;
import com.ca.fmp.ims.view.wizards.SegmentCommandWizard;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class SegmentCommandWizardPage extends WizardPage {

	private static final String TITLE = "Select Segments";
	private static String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.Segment";

	private Composite container;
	private CheckboxTreeViewer viewer;
	private Button selectAllClearButton;
	private int selectionCount = 0;

	public SegmentCommandWizardPage() {
		super(TITLE);
		setTitle(TITLE);
	}

	@Override
	public void createControl(Composite parent) {
		container = new Composite(parent, SWT.NULL);
		container.setLayout(new GridLayout(1, false));
		container.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CONTEXT_HELP_ID);

		viewer = new CheckboxTreeViewer(container, SWT.BORDER | SWT.CHECK);
		viewer.getTree().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		
		final SegmentInfoListType input = ((SegmentCommandWizard)getWizard()).getFormatMode().getSegmentInfo();
		
		viewer.setContentProvider(new ITreeContentProvider(){

			@Override
			public void dispose() {}

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {}

			@Override
			public Object[] getElements(Object inputElement) {
				ArrayList<SegmentInfoType> roots = new ArrayList<SegmentInfoType>();
				
				for(int i = 0; i < ((SegmentInfoListType)inputElement).getSegmentInfo().size(); i++){
					if(((SegmentInfoListType)inputElement).getSegmentInfo().get(i).getSegLvl() == 1){
						roots.add(((SegmentInfoListType)inputElement).getSegmentInfo().get(i));
					}
				}
				return roots.toArray();
			}

			@Override
			public Object[] getChildren(Object parentElement) {
				ArrayList<SegmentInfoType> children = new ArrayList<SegmentInfoType>();
				
				for(int i = 0; i < input.getSegmentInfo().size(); i++){
					if(input.getSegmentInfo().get(i).getSegParNum() == ((SegmentInfoType)parentElement).getSegNum()){
						children.add(input.getSegmentInfo().get(i));
					}
				}
				return children.toArray();
			}

			@Override
			public Object getParent(Object element) {
				return null;
			}

			@Override
			public boolean hasChildren(Object element) {
				for(int i = 0; i < input.getSegmentInfo().size(); i++){
					if(input.getSegmentInfo().get(i).getSegParNum() == ((SegmentInfoType)element).getSegNum()){
						return true;
					}
				}
				return false;
			}
		});

		viewer.setLabelProvider(new LabelProvider(){
			@Override
			public String getText(Object element) {
				return ((SegmentInfoType) element).getSegName();
			}
		});
		
		viewer.setInput(input);
		viewer.expandAll();
		
		viewer.addCheckStateListener(new ICheckStateListener(){
			@Override
			public void checkStateChanged(CheckStateChangedEvent event) {
				if(event.getChecked()){
					selectionCount++;
				} else {
					selectionCount--;
				}
				
				setPageComplete(isPageComplete());
			}
		});
		
		final ArrayList<SegmentCmdInfoType> segmentCmd = ((SegmentCommandWizard)getWizard()).getEditorView().getSegmentState();
		viewer.setCheckStateProvider(new ICheckStateProvider(){
			@Override
			public boolean isChecked(Object element) {

				for(int i = 0; i < segmentCmd.size(); i++){
					if(segmentCmd.get(i).getSegNum() == ((SegmentInfoType)element).getSegNum()){
						if(segmentCmd.get(i).getState() == SegmentCmdStateType.S){
							selectionCount++;
							return true;
						} else {
							return false;
						}
					}
				}
				return true;
			}

			@Override
			public boolean isGrayed(Object element) {
				return false;
			}
		});
		
		selectAllClearButton = new Button(container, SWT.NONE);
		GridData gd_selectAllClearButton = new GridData(SWT.LEFT, SWT.CENTER, false, false, 1, 1);
		gd_selectAllClearButton.widthHint = 120;
		selectAllClearButton.setLayoutData(gd_selectAllClearButton);
		selectAllClearButton.setText("&Clear Selections");
		selectAllClearButton.addSelectionListener(new SelectionListener(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (selectionCount == 0) {
					viewer.setCheckedElements(input.getSegmentInfo().toArray());
					selectionCount = input.getSegmentInfo().size();
				} else {
					viewer.setCheckedElements(new ArrayList<Object>().toArray());
					selectionCount = 0;
				}
				setPageComplete(isPageComplete());
			}

			@Override
			public void widgetDefaultSelected(SelectionEvent e) {}
		});
		
		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);
		
		setControl(container);

		((TestingToolsWizardDialog) getWizard().getContainer()).getButton(
				IDialogConstants.FINISH_ID).setText("OK");
	}
	
	public ArrayList<SegmentCmdInfoType> getState(){
		TreeItem[] rootItems = viewer.getTree().getItems();

		ArrayList<TreeItem> treeItems = new ArrayList<TreeItem>();

		for(int i = 0; i < rootItems.length; i++){
			
			if(rootItems[i].getItemCount() > 0){
				treeItems.add(rootItems[i]);
				treeItems.addAll(getSubTree(rootItems[i]));
			} else {
				treeItems.add(rootItems[i]);
			}
		}
		
		ArrayList<SegmentCmdInfoType> segmentStateList = new ArrayList<SegmentCmdInfoType>(treeItems.size());
		
		SegmentCmdInfoType segmentState;
		boolean isSegmentCmdActive = false;
		
		for(int i = 0; i < treeItems.size(); i++){
			segmentState = new SegmentCmdInfoType();
			
			segmentState.setSegNum(((SegmentInfoType)treeItems.get(i).getData()).getSegNum());
			
			if(treeItems.get(i).getChecked()){
				segmentState.setState(SegmentCmdStateType.S);
			} else {
				segmentState.setState(SegmentCmdStateType.X);
				isSegmentCmdActive = true;
			}
			
			segmentStateList.add(segmentState);
		}
		
		((SegmentCommandWizard)getWizard()).getEditorView().isSegmentCmdActive = isSegmentCmdActive;
		
		return segmentStateList;
	}
	
	private ArrayList<TreeItem> getSubTree(TreeItem treeItem){
		ArrayList<TreeItem> temp = new ArrayList<TreeItem>();

		TreeItem[] t = treeItem.getItems();
		for(int i = 0; i < t.length; i++){
			if(t[i].getItemCount() > 0){
				temp.add(t[i]);
				temp.addAll(getSubTree(t[i]));
			} else {
				temp.add(t[i]);
			}
		}
		return temp;
	}
	
	@Override
	public boolean isPageComplete() {
		if(selectionCount == 0){
			setErrorMessage("Please select at least one segment");
			selectAllClearButton.setText("Select &All");
			return false;
		} else {
			setErrorMessage(null);
			selectAllClearButton.setText("&Clear Selections");
			return true;
		}
	}
	
}