/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;
/**
 * This is the options page of the OpenDatabase Wizard class. This contains layout group.
 * 
 * @author navri01
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.FMHistory;
import com.ca.fmp.ims.common.FileMasterDataset;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.common.validator.Validator;
import com.ca.fmp.ims.model.ValidateDSNRequestType;
import com.ca.fmp.ims.model.WCdsnRequestType;
import com.ca.fmp.ims.model.generated.DataSetInfoType;
import com.ca.fmp.ims.model.generated.DisplayModeType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.Messages;
import com.ca.fmp.ims.view.dialogs.RestoreArchiveDatasetsDialog;
import com.ca.fmp.ims.view.wizards.DatasetWizard;
import com.ca.fmp.ims.view.wizards.OpenDatabaseWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class OptionsWizardPage extends WizardPage implements ModifyListener{

	private Combo displayModeCombo;
	private Combo layoutDataSetCombo;
	private Button layoutDataSetSelectBtn;
	private Label layoutDSLbl;
	private Label crlDSLbl;
	private Combo crlDataSetCombo;
	private Button crlDataSetSelectBtn;
	private FileMasterDataset dataset;
	private FileMasterServer server;
	protected TestingToolsWizardDialog dialog = null;
	private GUIResponseType response;
	private Composite container;
	public GenericSelectionBox genSelCriteriaBox;
	
	public OptionsWizardPage(FileMasterServer server) {
		super(Messages.OpenDatabaseWizard_Page_Options);
		setTitle("Options");
		this.server=server;
		
		genSelCriteriaBox= new GenericSelectionBox(server.getName(),this);
		// TODO Auto-generated constructor stub
	}

	@Override
	public void createControl(Composite parent) {
		container = new Composite(parent, SWT.NULL);
		container.setLayout(new GridLayout(1, false));
		
		Composite displayComosite = new Composite(container, SWT.NONE);
		GridLayout gl_displayComosite = new GridLayout(2, false);
		gl_displayComosite.marginWidth = 0;
		displayComosite.setLayout(gl_displayComosite);
		displayComosite.setLayoutData(new GridData(SWT.LEFT, SWT.TOP, true, false, 1, 1));

		Label displayModeLabel = new Label (displayComosite, SWT.NONE);
		displayModeLabel.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		displayModeLabel.setText("D&isplay mode:");

		displayModeCombo = new Combo(displayComosite, SWT.READ_ONLY);
		displayModeCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		displayModeCombo.setItems(new String []{"Character", "Single Record"});
		displayModeCombo.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				setPageComplete(isPageComplete());
			}
		});

		if(FMHistory.getString(Messages.OpenWizardHistoryDisplayMode).equals("S")){
			displayModeCombo.select(1);
		} else {
			displayModeCombo.select(0);
		}
		
		Group layoutGroup = new Group(container, SWT.NONE);
		layoutGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true,
				false, 1, 1));
		layoutGroup.setLayout(new GridLayout(3, false));
		layoutGroup.setText("Layout");
		
		
		layoutDSLbl = new Label(layoutGroup, SWT.NONE);
		layoutDSLbl.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false,
				false, 1, 1));
		layoutDSLbl.setText("&Layout data set:");
		
		layoutDataSetCombo = new Combo(layoutGroup, SWT.NONE);
		GridData gd_layoutDataSetNameCombo = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_layoutDataSetNameCombo.horizontalIndent = 2;
		layoutDataSetCombo.setLayoutData(gd_layoutDataSetNameCombo);
		TextUtil.setWidth(layoutDataSetCombo, 37);
		layoutDataSetCombo.setTextLimit(44);
		layoutDataSetCombo.addVerifyListener(new verifytoUpperCase());
		layoutDataSetCombo.addModifyListener(this);
		
		
		layoutDataSetSelectBtn = new Button(layoutGroup, SWT.NONE);
		layoutDataSetSelectBtn.setText("&Select...");
		layoutDataSetSelectBtn.setEnabled(false);
		layoutDataSetSelectBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				doSelectlayoutdsn();
			}
		});	
		
		crlDSLbl = new Label(layoutGroup, SWT.NONE);
		crlDSLbl.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false,
				false, 1, 1));
		crlDSLbl.setText("&Custom layout data set:");
		
		crlDataSetCombo = new Combo(layoutGroup, SWT.NONE);
		GridData gd_crlDataSetNameCombo = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_crlDataSetNameCombo.horizontalIndent = 2;
		crlDataSetCombo.setLayoutData(gd_crlDataSetNameCombo);
		TextUtil.setWidth(crlDataSetCombo, 37);
		crlDataSetCombo.setTextLimit(44);
		crlDataSetCombo.addVerifyListener(new verifytoUpperCase());
		crlDataSetCombo.addModifyListener(this);
		
		
		crlDataSetSelectBtn = new Button(layoutGroup, SWT.NONE);
		crlDataSetSelectBtn.setText("S&elect...");
		crlDataSetSelectBtn.setEnabled(false);
		crlDataSetSelectBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				doSelectcrldsn();
			}
		});	
		FMHistory.intializeComboBoxes(layoutDataSetCombo,"layoutDataSetComboGenericOptions");
		FMHistory.intializeComboBoxes(crlDataSetCombo, "crlComboGenericOptions");
		
		if(FMHistory.getBoolean(Messages.OpenWizardHistoryLayoutUsed)){
			layoutDataSetCombo.select(0);
		}
		if(FMHistory.getBoolean(Messages.OpenWizardHistoryCustomLayoutUsed)){
			crlDataSetCombo.select(0);
		}
		
		genSelCriteriaBox.createConditionBoxContent(container,"La&yout...","Impo&rt...",((OpenDatabaseWizardPageServer)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_Server)).getImsEnvironment(), ((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).getDbd(),layoutDataSetCombo);
		genSelCriteriaBox.setEnableLayoutBtn(false);
		
		genSelCriteriaBox.selConditionText.setText(FMHistory.getString(Messages.OpenWizardHistorySelectionCriteria));
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(container, OpenDatabaseWizard.CONTEXT_HELP_ID);
		setControl(container);
		
		
	}
	private void doSelectlayoutdsn() {
		// TODO Auto-generated method stub
		
		String datasetName = layoutDataSetCombo.getText().trim().toUpperCase();
		String DSLength = Integer.toHexString(layoutDataSetCombo.getText().length());

		if (datasetName.startsWith("\"")) {
			datasetName = datasetName.substring(1, datasetName.length() - 1);
		}

		dataset = new FileMasterDataset(null);
		dataset.setName(datasetName);
		dataset.setDSLength(DSLength);
		if(getWCResponse(dataset)){
		DatasetWizard wizard = new DatasetWizard(response,server);
		dialog = new TestingToolsWizardDialog(getShell(), wizard);
		dialog.create();
		DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				//dataSetCombo.setText(DatasetWizardPage.getSelectedDSN());
				dataset = DatasetWizardPage.getSelectedDSN();
				layoutDataSetCombo.setText(dataset.getName());
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		dialog.open();
		}
	}


	private void doSelectcrldsn() {
		// TODO Auto-generated method stub
		
		String datasetName = crlDataSetCombo.getText().trim().toUpperCase();
		String DSLength = Integer.toHexString(crlDataSetCombo.getText().length());

		if (datasetName.startsWith("\"")) {
			datasetName = datasetName.substring(1, datasetName.length() - 1);
		}

		dataset = new FileMasterDataset(null);
		dataset.setName(datasetName);
		dataset.setDSLength(DSLength);
		if(getWCResponse(dataset)){
		DatasetWizard wizard = new DatasetWizard(response,server);
		dialog = new TestingToolsWizardDialog(getShell(), wizard);
		dialog.create();
		DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				//dataSetCombo.setText(DatasetWizardPage.getSelectedDSN());
				dataset = DatasetWizardPage.getSelectedDSN();
				crlDataSetCombo.setText(dataset.getName());
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		dialog.open();
		}

	}

	private boolean getWCResponse(FileMasterDataset dataset) {
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new WCdsnRequestType(server,dataset.getName()).createXml());
		} catch (TTException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req=new SendRequestToMainframe(server, map, "opendb", true, xmlDocument);
		if(req.getResult()==Status.CANCEL_STATUS){
			return false;
		}
		response = req.getGuiResponseType();
		if(response==null)
			return false;
		//No error therefore proceed with further processing.
		if(response.getFunctionRC()==0 && response.getReturnCode() ==0){
			int numOfDsnReturned = response.getWildCardDataSetResponse().getDataSetInfoList().getDataSetInfo().size();
	}
		else{
			for(int i=0;i<response.getMessages().getMessage().size();i++){
			String shortText = response.getMessages().getMessage().get(i).getShortText();
			String messageID = response.getMessages().getMessage().get(i).getMessageId();
			List<String> messageText = response.getMessages().getMessage().get(i).getMessageText();
			TT_ErrorDialog.openError(null, "Error", messageID+": "+shortText, new Throwable(messageText.get(i)));

		}
			return false;
		}
		return true;
	}
	@Override
	public void modifyText(ModifyEvent e) {
		// TODO Auto-generated method stub
		if (layoutDataSetCombo != null && crlDataSetCombo != null && genSelCriteriaBox!=null) {
			if (layoutDataSetCombo.getText().isEmpty()) {
				genSelCriteriaBox.setEnableLayoutBtn(false);
				layoutDataSetSelectBtn.setEnabled(false);
			}
			
		}
		
		setPageComplete(isPageComplete());
	}
	@Override
	public boolean isPageComplete() {
		if(layoutDataSetCombo.getText()==null || crlDataSetCombo.getText()==null)
			return false;

		String layoutdsnString = layoutDataSetCombo.getText();
		String crldsnString = crlDataSetCombo.getText();
		String error = "";

		switch (Validator.dataset(layoutdsnString, true)) {
		case Validator.DS_WILDCARD:
			error = error + Validator.errorMsg[Validator.DS_WILDCARD]
					+ "\n";
			layoutDataSetSelectBtn.setEnabled(true);
			genSelCriteriaBox.setEnableLayoutBtn(false);
			break;
		case Validator.DS_INVALID:
		case Validator.DS_LONG:
			error = error
			+ Validator.errorMsg[Validator.dataset(
					layoutdsnString, true)] + "\n ";
			layoutDataSetSelectBtn.setEnabled(false);
			genSelCriteriaBox.setEnableLayoutBtn(false);
			break;
		case Validator.DS_MISSING:
			genSelCriteriaBox.setEnableLayoutBtn(false);
			break;
		case Validator.NO_ERROR:
			layoutDataSetSelectBtn.setEnabled(false);
			genSelCriteriaBox.setEnableLayoutBtn(true);
			break;
		}
		if (error.length() == 0) {
			switch (Validator.dataset(crldsnString, false)) {
			case Validator.DS_WILDCARD:
				error = error + Validator.errorMsg[Validator.DS_WILDCARD]
						+ "\n";
				crlDataSetSelectBtn.setEnabled(true);
				break;
			case Validator.DS_INVALID:
			case Validator.DS_LONG:
				/*case Validator.DS_MISSING:*/
				error = error
				+ Validator.errorMsg[Validator.dataset(
						crldsnString, true)] + "\n ";
				crlDataSetSelectBtn.setEnabled(false);
				break;
			case Validator.NO_ERROR:
				crlDataSetSelectBtn.setEnabled(false);
				break;
			}
		}
		if(displayModeCombo.getSelectionIndex() > 0 &&
				(layoutdsnString.trim().length() == 0 && crldsnString.trim().length() == 0)){
			error += "Please select a layout data set\n";
		}
		if (error.length() > 0) {
			setErrorMessage(error);
			return false;
		}

		setErrorMessage(null);

		return true;
	}
	
	@Override
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		container.setFocus();
		if(genSelCriteriaBox != null){
			genSelCriteriaBox.setDBDName(((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).getDbd());
			genSelCriteriaBox.setIMSEnvName(((OpenDatabaseWizardPageServer)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_Server)).getImsEnvironment());
		}
	}
	
	public ArrayList<String> getSelConds(){
		ArrayList<String> selCondsList = new ArrayList<String>();
		if(genSelCriteriaBox.getText()!=null){
		String[] selConds = genSelCriteriaBox.getText().trim().split("\\r\\n");
		for(int i=0;i< selConds.length;i++){
			if(!selConds[i].trim().isEmpty())
			selCondsList.add(selConds[i]);
		}
		}
		return selCondsList;
	}
	public String getSelCriteriaBoxText() {
		// TODO Auto-generated method stub
		return genSelCriteriaBox.getText();
	}
	public void AddLayoutSelCondition(String layoutSelCondition) {
		genSelCriteriaBox.setText(layoutSelCondition);
	}
	public String getlayoutDSN(){
        // carel06 Defect 3167
		return layoutDataSetCombo.getText().trim();
	}
	public String getcustomLayDSN(){
		// carel06 Defect 3167
		return crlDataSetCombo.getText().trim();
	}
	public Combo getlayoutDSNCombo(){
		return layoutDataSetCombo;
	}
	public Combo getCustomLayoutDSNCombo(){
		return crlDataSetCombo;
	}
	public boolean checkifDSNisArchived(String dataSetName) {
		XMLDocument xmlDocument = null;
		ArrayList<String> datasets = new ArrayList<String>();
		try {
			xmlDocument = new XMLDocument(new ValidateDSNRequestType(server,dataSetName).createXml());
		} catch (TTException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req = new SendRequestToMainframe(server, map, "opendb", true, xmlDocument);
		if(req.getResult() == Status.CANCEL_STATUS){
			return false;
		}
		// ParseResponse
		response = req.getGuiResponseType();
		if (response == null) {
			return false;
		}
		if (response.getValidateDSNResponse().getDataSetInfo() == null) {
			return false;
		}
		
		DataSetInfoType dsInfo = response.getValidateDSNResponse().getDataSetInfo();
		if(dsInfo.getVolumeSerial()!=null)
		{
			if (dsInfo.getVolumeSerial().equalsIgnoreCase("ARCIVE")) {
				datasets.add(dsInfo.getDsname());
			}
		}
		
		if (datasets.size() > 0) {
			RestoreArchiveDatasetsDialog radd = new RestoreArchiveDatasetsDialog(
					getShell(), datasets, server);
			radd.create();
			radd.open();
			if(radd.getReturnCode() != 0){
				return false;
			}
		}
		return true;
	}

	public String getDescription(){
		return ImportSelCritWizardPage.description;
	}
	
	public DisplayModeType getDisplayMode(){
		switch(displayModeCombo.getSelectionIndex()){
		case 0:
			return DisplayModeType.C;
		case 1:
			return DisplayModeType.S;
		case 2:
			return DisplayModeType.M;
		default:
			return DisplayModeType.C;
		}
	}
	
	@Override
	public IWizardPage getNextPage() {
		return null;
	}
}
