/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.DBDInfo;
import com.ca.fmp.ims.common.FileMasterDataset;
import com.ca.fmp.ims.model.IMSDatabase;
import com.ca.fmp.ims.model.OpenDatabaseRequestType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.OpenDBActionType;
import com.ca.fmp.ims.model.generated.PCBInfoListType;
import com.ca.fmp.ims.model.generated.PCBInfoType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.Messages;
import com.ca.fmp.ims.view.wizards.OpenDatabaseWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;

public class OpenDatabaseWizardPagePCB extends WizardPage implements Listener {
	private OpenDatabaseWizard openDatabaseWizard;
	private Composite container;	
	public boolean isDBDDSNPageRequired = false;
	public boolean pageContentValidated = false;
	public ArrayList<DBDInfo> dbdinfoList;	
	
	ArrayList<String> shortText = new ArrayList<String>();
	ArrayList<String> messageID = new ArrayList<String>();
	List<String> messageText = new ArrayList<String>();
	String messageIDFinal="";
	String messageTextFinal= "";
	String title = "";	
	
	private TableViewer viewer;
	private Listener sortListener;
	
	private int pixelSizeOfCharacter = -1;
	private Shell shell;
	private Text text;
	private GC gc;
			 
	protected OpenDatabaseWizardPagePCB(String pageName) {
		super(pageName);
	}

	public OpenDatabaseWizardPagePCB() {
		super(Messages.OpenDatabaseWizard_Page_PCB);
		setTitle("PCB Selection");
		this.openDatabaseWizard = (OpenDatabaseWizard) this.getWizard();		
	}
	
	@Override
	public void createControl(Composite parent) {
		openDatabaseWizard = (OpenDatabaseWizard) this.getWizard();
		container = new Composite(parent, SWT.NULL);
		container.setLayout(new GridLayout(3, false));
		setControl(container);		
		
		viewer = new TableViewer(container, SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION | SWT.BORDER);
		
		viewer.getTable().setLinesVisible(true);
		viewer.getTable().setHeaderVisible(true);
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gd_table.heightHint = 300;
				
		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				setPageComplete(isPageComplete());
			}
		});
		viewer.getTable().setLayoutData(gd_table);
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setSorter(new PCBWizardPageSorter());
		setupColumnListener();		
		
		String[] titles = new String[] {"PCB Name", "PCB Type", "DBD Name", "Process Options", "Sensitive Segment Count", "Secondary Processing Sequence"};											
		int[] bounds = new int[] {100, 90, 90, 110, 150, 185};
		int[] alignments = new int[] {SWT.LEFT, SWT.LEFT, SWT.LEFT, SWT.LEFT, SWT.RIGHT, SWT.LEFT};		

		
		
		for (int i = 0; i < titles.length; i++) {
			TableViewerColumn tableColumn = new TableViewerColumn(viewer, bounds[i]);
			tableColumn.getColumn().setText(titles[i]);
			tableColumn.getColumn().setWidth(bounds[i]);
			tableColumn.getColumn().setAlignment(alignments[i]);			
			tableColumn.getColumn().addListener(SWT.Selection, sortListener);
		}
  	    		
		viewer.setLabelProvider(new PCBLabelProvider());
		viewer.getTable().setSortColumn(viewer.getTable().getColumn(0));
		viewer.getTable().setSortDirection(SWT.UP);
		
		setTableInput();				
		
		PlatformUI.getWorkbench().getHelpSystem().setHelp(container, OpenDatabaseWizard.CONTEXT_HELP_ID);		
	}
		
	@Override
	public boolean isPageComplete() {
        if (viewer.getTable().getSelectionCount() == 1) {
        	return true;
        }	
		else {
			return false;
		}	
	}	
	
	@Override
	public boolean canFlipToNextPage() {
		return isPageComplete();
	}
			
	protected int getPixelSizeOfCharacter() {		
		if(pixelSizeOfCharacter == -1) {
			if (shell == null)
				// get the pixel size for each character
				shell = new Shell(Display.getDefault());
			if (text == null)
				text = new Text(shell, SWT.NONE);
			text.setFont(this.getFont());
			if (gc == null)
				gc = new GC(text);
			pixelSizeOfCharacter = gc.textExtent("W").x;
		}
		return pixelSizeOfCharacter;
	}
			
	
	@Override
	public void handleEvent(Event event) {
		// TODO Auto-generated method stub		
	}
	
	@Override
	public IWizardPage getNextPage() {
		boolean canFlip = sendRequest();
		if(canFlip){					
            if(isDBDDSNPageRequired){
				OpenDatabaseWizardPageDBDDSN page = this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBDDSN) !=null ? ((OpenDatabaseWizardPageDBDDSN)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBDDSN)) : new OpenDatabaseWizardPageDBDDSN();
				if(this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBDDSN) == null){
					((OpenDatabaseWizard)this.getWizard()).addPage(page);
				}
				if(pageContentValidated == false){
					//The following call is needed to update the table based on the mainframe response.
					page.setTableInput();
					pageContentValidated = true;
				}
				return page;
			} else {
				OptionsWizardPage page = openDatabaseWizard.getPage(Messages.OpenDatabaseWizard_Page_Options) != null ?
						((OptionsWizardPage)openDatabaseWizard.getPage(Messages.OpenDatabaseWizard_Page_Options)) : new OptionsWizardPage(openDatabaseWizard.getFileMasterServer());
				((OpenDatabaseWizard)openDatabaseWizard).addPage(page);
				pageContentValidated = true;
				return page;
			}
		}
		return null;
	}
	
	public ArrayList<DBDInfo> getDBDInfoList(){
		return dbdinfoList;
	}	
	
	private boolean sendRequest(){
		XMLDocument xmlDocument = null;
		String uuid = "";
		IMSDatabase imsDb = new IMSDatabase();
		OpenDatabaseWizardPageServer oDBWizardPageServer = (OpenDatabaseWizardPageServer) openDatabaseWizard.getPage(Messages.OpenDatabaseWizard_Page_Server);
		imsDb.setIMSEmvironmentPDS(oDBWizardPageServer.getImsEnvDSN().trim());
		imsDb.setIMSEnvironment(oDBWizardPageServer.getImsEnvironment().trim());
		imsDb.setDBDName(((OpenDatabaseWizardPageDBD) openDatabaseWizard.getPage(Messages.OpenDatabaseWizard_Page_DBD)).getDbd().trim());				 
        imsDb.setPSBName(((OpenDatabaseWizardPageDBD) openDatabaseWizard.getPage(Messages.OpenDatabaseWizard_Page_DBD)).getPSBorACB().trim());        
        imsDb.setSecondaryIndex(((OpenDatabaseWizardPageDBD) openDatabaseWizard.getPage(Messages.OpenDatabaseWizard_Page_DBD)).getUseSecondaryIndex());                    
		imsDb.setPCBnum(getSelectedPCBNum());
		                                
		try {
			xmlDocument = new XMLDocument(new OpenDatabaseRequestType(openDatabaseWizard.getFileMasterServer(), imsDb, "", new ArrayList<String>(), OpenDBActionType.NEXT).createXml());
			int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
			uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+ 36 );
			if(uuid.equalsIgnoreCase("\""))
				throw new TTException();
		} catch (TTException e) {
			e.printStackTrace();
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req=new SendRequestToMainframe(openDatabaseWizard.getFileMasterServer(), map, "opendb", true, xmlDocument);	
		if(req.getGuiResponseType()!=null){		
			parseResponse(req.getGuiResponseType());
			if(req.getGuiResponseType().getMessages()!=null&&!req.getGuiResponseType().getMessages().getMessage().isEmpty())
				return false;
			else
				return true;
		}
		return false;
	}	
	
	public long getSelectedPCBNum(){		
		TableItem[] tbItem = viewer.getTable().getSelection();		
		PCBInfoType pcbInfo = (PCBInfoType) tbItem[0].getData();
		return pcbInfo.getPcbnum();
	}
		
	private void parseResponse(GUIResponseType guiResponseType) {
		if(guiResponseType.getFunctionRC()!=0 || guiResponseType.getReturnCode()!=0){
			showError(guiResponseType);
			setPageComplete(false);
		}
		
		isDBDDSNPageRequired = false;
		
		if(guiResponseType.getEditResponse().getOpenDatabaseResponse()!=null){					
            if(guiResponseType.getEditResponse().getOpenDatabaseResponse().getDLIFileList() != null){
				isDBDDSNPageRequired = true;
				String dbdName = "";
				String ddName = "";
				FileMasterDataset fmdataset = new FileMasterDataset(null);
				dbdinfoList = new ArrayList<DBDInfo>();
				for(int i = 0; i<guiResponseType.getEditResponse().getOpenDatabaseResponse().getDLIFileList().getDLIFileEntry().size();i++){
					dbdName =(guiResponseType.getEditResponse().getOpenDatabaseResponse().getDLIFileList().getDLIFileEntry().get(i).getDbdname());		
					ddName = (guiResponseType.getEditResponse().getOpenDatabaseResponse().getDLIFileList().getDLIFileEntry().get(i).getDdname());
					DBDInfo dbdinfo = new DBDInfo(dbdName, ddName, fmdataset);
					dbdinfo.setDBDName(dbdName);
					dbdinfo.setDDName(ddName);
					dbdinfo.setFmdataset(null);
					dbdinfoList.add(dbdinfo);
				}
			} 
		}
	}	
	
	private void showError(GUIResponseType guiResponseType) {
		shortText = new ArrayList<String>();
		messageID = new ArrayList<String>();
		messageText = new ArrayList<String>();
		messageIDFinal = new String();
		messageTextFinal = new String();
		for(int i=0;i<guiResponseType.getMessages().getMessage().size();i++){
			shortText.add(guiResponseType.getMessages().getMessage().get(i).getShortText());
			messageID.add(guiResponseType.getMessages().getMessage().get(i).getMessageId());
			if(guiResponseType.getMessages().getMessage().get(i).getMessageText()!=null)
			messageText.add(guiResponseType.getMessages().getMessage().get(i).getMessageText()+ "\n");
			else 
				messageText.add("");
		}
		for(int i=0;i<messageID.size();i++){
			messageIDFinal+= messageID.get(i)+" : " + shortText.get(i) + "\n" ; 
			title = "Error";
			messageTextFinal+= messageText.get(i).substring(1, messageText.get(i).length()-2) + "\n";	
		}
		TT_ErrorDialog.openError(null, title, messageIDFinal, new Throwable(messageTextFinal));	
	}			
	
	@Override
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		container.setFocus();
	}
	
	private void setupColumnListener() {
		sortListener = new Listener(){
			public void handleEvent(final Event event) {
				final TableColumn column =  (TableColumn)event.widget;
				final Table table = viewer.getTable();
				if (column.equals(table.getSortColumn())){
					final int direction = table.getSortDirection();
					switch (direction){
					case SWT.DOWN:
						table.setSortDirection(SWT.UP);
						break;
					case SWT.None:
					case SWT.UP:
					default:
						table.setSortDirection(SWT.DOWN);
						break;
					}
				} else {
					table.setSortColumn(column);
					table.setSortDirection(SWT.UP);
				}
				getShell().getDisplay();
 
				for (TableItem tableRow : viewer.getTable().getItems()) {
						viewer.getTable().getItem(viewer.getTable().indexOf(tableRow)).setForeground(null);
				}							
				viewer.refresh();
			}
		};		
	}		

	public void setTableInput() {		
		PCBInfoListType pcbInfoList = ((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).getPCBInfoList();
		viewer.setInput(pcbInfoList.getPCBInfo().toArray(new PCBInfoType[pcbInfoList.getPCBInfo().size()]));
	}
}