/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

import com.ca.fmp.ims.common.Activator;
import com.ca.fmp.ims.common.DBDInfo;
import com.ca.fmp.ims.common.FileMasterDataset;
import com.ca.fmp.ims.common.VPATSortDialog;
import com.ca.fmp.ims.common.validator.Validator;
import com.ca.fmp.ims.model.ValidateDSNRequestType;
import com.ca.fmp.ims.model.WCdsnRequestType;
import com.ca.fmp.ims.model.generated.DataSetInfoType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.Messages;
import com.ca.fmp.ims.view.dialogs.RestoreArchiveDatasetsDialog;
import com.ca.fmp.ims.view.wizards.DatasetWizard;
import com.ca.fmp.ims.view.wizards.OpenDatabaseWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;



public class OpenDatabaseWizardPageDBDDSN extends WizardPage implements ModifyListener, Listener {
	private static final String SELECT_DBD_DSN_1 = "&Select...";
	private TableViewer tableViewer;
	private Button selectDbdDSN1;
	private boolean changed = true;
	private FileMasterDataset dataset;
	protected TestingToolsWizardDialog dialog = null;
	private GUIResponseType response;
	private Composite container;
	private Logger log = Logger.getLogger(OpenDatabaseWizardPageDBDDSN.class.getName());
	private OpenDatabaseWizard openDatabaseWizard;
	ArrayList<String> shortText = new ArrayList<String>();
	ArrayList<String> messageID = new ArrayList<String>();
	List<String> messageText = new ArrayList<String>();
	String messageIDFinal="";
	String messageTextFinal= "";
	String title = "";
	private String error = "";
	private String currentChangedData = "";
	private Listener sortListener;
	private Listener sortListenerVPAT;  //grake02 3/NOV/2016	
	private boolean traverseHelper = false;
	private boolean doIspageComplete = true;
	/**
	 * Create the wizard.
	 */
	public OpenDatabaseWizardPageDBDDSN() {
		super(Messages.OpenDatabaseWizard_Page_DBDDSN);
		setTitle("Database DSN Specification");
		this.openDatabaseWizard = (OpenDatabaseWizard) this.getWizard();
		
	}

	/**
	 * Create contents of the wizard.
	 * @param parent
	 */
	public void createControl(Composite parent) {
		openDatabaseWizard = (OpenDatabaseWizard) this.getWizard();
		container = new Composite(parent, SWT.NULL);

		
		container.setLayout(new GridLayout(2, false));
		Composite select_dataset_composite = new Composite(container, SWT.NULL);
		select_dataset_composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		GridLayout select_dataset_composite_layout = new GridLayout(1, false);
		select_dataset_composite_layout.marginHeight = 0;
		select_dataset_composite_layout.marginWidth = 0;
		select_dataset_composite.setLayout(select_dataset_composite_layout);
		select_dataset_composite.setBounds(0, 0, 300, 800);
		createViewer(select_dataset_composite);
		/* Select Button for dbdDSN1 */
		Composite select_datasetbtn_composite = new Composite(container, SWT.NULL);
		select_datasetbtn_composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));
		GridLayout select_datasetbtn_composite_layout = new GridLayout(1, false);
		select_datasetbtn_composite_layout.marginHeight = 0;
		select_datasetbtn_composite_layout.marginWidth = 0;
		select_datasetbtn_composite.setLayout(select_datasetbtn_composite_layout);
		selectDbdDSN1 = new Button(select_datasetbtn_composite, SWT.PUSH);
		selectDbdDSN1.setText("&Select...");
		selectDbdDSN1.setEnabled(false);
		selectDbdDSN1.addListener(SWT.Selection, this);

		PlatformUI.getWorkbench().getHelpSystem().setHelp(container, OpenDatabaseWizard.CONTEXT_HELP_ID);
		setControl(container);
	}
	
	private void createViewer(Composite parent) {
		// TODO Auto-generated method stub
		tableViewer = new TableViewer(parent, SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION | SWT.BORDER);

		tableViewer.getTable().setLinesVisible(true);
		tableViewer.getTable().setHeaderVisible(true);
		setupColumnListener();
		createColumns(parent, tableViewer);
		tableViewer.setContentProvider(new ArrayContentProvider());	
		tableViewer.getTable().addTraverseListener(new TraverseListener() {
			public void keyTraversed(TraverseEvent e) {
				if (e.detail == SWT.TRAVERSE_TAB_NEXT) {
					if(traverseHelper){
						traverseHelper = false;
						e.doit = true;
						return;
					}
					int selectedElement = tableViewer.getTable().getSelectionIndex();
					if(selectedElement == -1){
						tableViewer.getTable().setSelection(0);
						e.doit = false;
						return;
					}
					if(selectedElement > -1 ){
						tableViewer.editElement(tableViewer.getElementAt(selectedElement), 2);
						return;
					}
				} else if (e.detail == SWT.TRAVERSE_TAB_PREVIOUS){
					int selectedElement = tableViewer.getTable().getSelectionIndex();
					if(selectedElement == -1){
						tableViewer.editElement(tableViewer.getElementAt(tableViewer.getTable().getItemCount() - 1), 2);
						e.doit = false;
						return;
					}
					if(selectedElement > 0){
						tableViewer.editElement(tableViewer.getElementAt(selectedElement - 1), 2);
						e.doit = false;
						return;
					}
					tableViewer.getTable().setSelection(-1);
				}
			}
		});
		tableViewer.editElement(tableViewer.getElementAt(0), 2);
		
		setupVPATColumnSorter();  //grake02 3/NOV/2016
	}

	private void createColumns(Composite parent, TableViewer tableViewer2) {
		String[] titles = { "DBD Name", "DD Name", "Data Set Name (editable)"};
		int[] bounds = { 125, 125, 425 };
		Table table = tableViewer.getTable();
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		table.setHeaderVisible(true);
		for (int i = 0; i < titles.length; i++) {
			TableViewerColumn tableColumn = new TableViewerColumn(tableViewer,
					bounds[i]);
			tableColumn.getColumn().setText(titles[i]);
			tableColumn.getColumn().setWidth(bounds[i]);
			switch (i) {
			case 2:
				tableColumn.setEditingSupport(new EditingSupport(tableColumn.getViewer()) {
					
					@Override
					protected void setValue(Object element, Object value) {
						DBDInfo m = (DBDInfo) element;
						FileMasterDataset fmdataset = new FileMasterDataset(null);
						// carel06 Defect 3167
						fmdataset.setName((String) value.toString().trim());
						m.setFmdataset(fmdataset);
						tableViewer.refresh();
						return;
						
					}
					
					@Override
					protected Object getValue(Object element) {
						DBDInfo m = (DBDInfo) element;
						if(m==null|| m.getFmdataset()==null||m.getFmdataset().getName()==null){
							return"";
						}
						return m.getFmdataset().getName().toUpperCase();
					}
					
					@Override
					protected CellEditor getCellEditor(Object element) {
						final TextCellEditor textEditor = new TextCellEditor(tableViewer.getTable(),SWT.BORDER);
						((Text) textEditor.getControl()).setTextLimit(44);
						((Text) textEditor.getControl()).addVerifyListener(new verifytoUpperCase());
						((Text) textEditor.getControl()).addModifyListener(new ModifyListener() {

									@Override
									public void modifyText(ModifyEvent e) {
										// TODO Auto-generated method stub
										Widget source = e.widget;
										if (source instanceof Text) {
											currentChangedData = ((Text)source).getText();	
											if(doIspageComplete)
												setPageComplete(isPageComplete());		
											}
										}
								});
						textEditor.getControl().addTraverseListener(new TraverseListener() {
				        	public void keyTraversed(TraverseEvent e) {
				        		if (e.detail == SWT.TRAVERSE_TAB_NEXT) {
				        			textEditor.getControl().traverse(SWT.TRAVERSE_TAB_PREVIOUS);
				        			int selectedElement = tableViewer.getTable().getSelectionIndex();
				        			if(selectedElement + 1 < tableViewer.getTable().getItemCount()){
				        				tableViewer.getTable().setSelection(selectedElement + 1);
				        				e.doit = false;
					        			return;
				        			}
				        			tableViewer.getTable().setSelection(-1);
				        			traverseHelper = true;
			        				tableViewer.getTable().traverse(SWT.TRAVERSE_TAB_NEXT);
				        		} else if (e.detail == SWT.TRAVERSE_TAB_PREVIOUS) {
				        			textEditor.getControl().traverse(SWT.TRAVERSE_RETURN);
				        		}
				        	}
				        });
						return textEditor;
					}
					
					@Override
					protected boolean canEdit(Object element) {
						// TODO Auto-generated method stub
						return true;
					}
				});
				break;
			}
			tableColumn.getColumn().addListener(SWT.Selection, sortListener);
		}
		tableViewer.setSorter(new DBDDSNWizardPageSorter());
		table.setSortColumn(table.getColumn(0));
		table.setSortDirection(SWT.UP);

		tableViewer.setContentProvider(new ArrayContentProvider());
		tableViewer.setLabelProvider(new DbdDsnLabelProvider());
		ArrayList<DBDInfo> dbdInfoList = ((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).getDBDInfoList();

		if (((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).getDBDInfoList()!=null)
			dbdInfoList = ((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).getDBDInfoList();
		else{
			if  (((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).isPSBPageRequired)
				dbdInfoList = ((OpenDatabaseWizardPagePCB)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_PCB)).getDBDInfoList();
			else if (((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).isSIXPageRequired)				
				dbdInfoList = ((OpenDatabaseWizardPageSIX)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_SIX)).getDBDInfoList();
		}		
		
		//@parra12: code to retreive data from serialized hashmap.
		OpenDatabaseWizard oDBWizard = ((OpenDatabaseWizard)this.getWizard());
		OpenDatabaseWizardPageServer oDBWizardPageServer = (OpenDatabaseWizardPageServer) oDBWizard.getPage(Messages.OpenDatabaseWizard_Page_Server);
		String imsEnv = oDBWizardPageServer.getImsEnvironment();
		HashMap<String, String> hm = readFromFile();
		if(dbdInfoList!=null){
			if(hm != null)
			{
				for(int count = 0; count < dbdInfoList.size(); count ++){
						FileMasterDataset ds = new FileMasterDataset(null);
						ds.setName(hm.get(imsEnv+dbdInfoList.get(count).getDBDName()));
						dbdInfoList.get(count).setFmdataset(ds);
				}
			}
		
		tableViewer.setInput(dbdInfoList.toArray(new DBDInfo[dbdInfoList.size()]));		
		}
		}
	
	private void setupColumnListener() {
		sortListener = new Listener(){


			public void handleEvent(final Event event) {
				final TableColumn column =  (TableColumn)event.widget;
				final Table table = tableViewer.getTable();
				if (column.equals(table.getSortColumn())){
					final int direction = table.getSortDirection();
					switch (direction){
					case SWT.DOWN:
						table.setSortDirection(SWT.UP);
						break;
					case SWT.None:
					case SWT.UP:
					default:
						table.setSortDirection(SWT.DOWN);
						break;
					}
				} else {
					table.setSortColumn(column);
					//table.setSortDirection(SWT.UP);
				}
				tableViewer.refresh();
			}
		};

	}

	@Override
	public boolean isPageComplete() {
		String dbdDsn1String = "";
		TableItem dbdDsn1String1 = null;
		error = "";
		//Base case: Page cannot be completed if either dbdDSN1 or dbdDsn2 is null
		
		if(tableViewer.getTable().getItemCount()>0&&selectDbdDSN1!=null){
		for(int i=0; i<tableViewer.getTable().getItems().length;i++){
		if(tableViewer.getTable().getSelectionIndex()==i){
			//System.out.println("i = "+tableViewer.getTable().getSelectionIndex());
			//System.out.println(currentChangedData);
			
			dbdDsn1String = currentChangedData;
		}
		else{
			dbdDsn1String1 = tableViewer.getTable().getItem(i);
			dbdDsn1String= dbdDsn1String1.getText(2);
		}
		switch (Validator.dataset(dbdDsn1String, true)) {
		case Validator.DS_WILDCARD:
			error = error + Validator.errorMsg[Validator.DS_WILDCARD] + "\n";
			selectDbdDSN1.setEnabled(true);
			break;
		case Validator.DS_INVALID:
		case Validator.DS_LONG:
			error = error + Validator.errorMsg[Validator.dataset(dbdDsn1String, true)] + "\n ";
			selectDbdDSN1.setEnabled(false);
			break;
		case Validator.DS_MISSING:
			error = error + Validator.errorMsg[Validator.dataset(dbdDsn1String, true)] + "\n ";
			selectDbdDSN1.setEnabled(false);
			if(!tableViewer.isCellEditorActive()){
				doIspageComplete = false;
				tableViewer.editElement(tableViewer.getElementAt(i), 2);
				doIspageComplete = true;
			}
			break;
		case Validator.NO_ERROR:
			selectDbdDSN1.setEnabled(false);
			break;
		}
	
		if (error.length() > 0){
			break;
		}
		}
		if (error.length() > 0)
		 {
            log.log(Level.WARNING, "there is an error: " + error + ", cannot go to next page");
			setErrorMessage(error);
			return false;
		}
			
		}
		setErrorMessage(null);
		return changed;
		
	}

	@Override
	public void modifyText(ModifyEvent e) {
		// TODO Auto-generated method stub
		changed = true;
		if(doIspageComplete)
		setPageComplete(isPageComplete());
	}

	@Override
	public void handleEvent(Event event) {
		// TODO Auto-generated method stub
		Widget source = event.widget;
		if (source instanceof Button) {
			if (((Button) source).getText().equals("&Select...")) {
				doSelectDBDDsn1();
			}
		}
	}
	
	private void doSelectDBDDsn1() {
		// TODO Auto-generated method stub
		String datasetName = "";
		TableItem[] tbItem = tableViewer.getTable().getSelection();
		DBDInfo dbinfo = (DBDInfo) tbItem[0].getData();
		datasetName = dbinfo.getFmdataset().getName();
		if (datasetName.startsWith("\"")) {
			datasetName = datasetName.substring(1, datasetName.length() - 1);
		}
		dataset = new FileMasterDataset(null);
		dataset.setName(datasetName);
		//navri01-- added this condition to see if some dsn is selected without wc criteria then dont send request
		if(!datasetName.contains("*")&&!datasetName.contains("%")){
			return;
		}
		if(getWCResponse(dataset)){
		DatasetWizard wizard = new DatasetWizard(response,openDatabaseWizard.getFileMasterServer());
		dialog = new TestingToolsWizardDialog(getShell(), wizard);
		dialog.create();
		DatasetWizardPage.dsnValue.addSelectionListener(new SelectionListener() {
			
			@Override
			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				TableItem item;
				dataset = DatasetWizardPage.getSelectedDSN();
				DBDInfo dbdInfo = (DBDInfo)(tableViewer.getTable().getItem(tableViewer.getTable().getSelectionIndex())).getData();
				dbdInfo.setFmdataset(dataset);
				item = tableViewer.getTable().getItems()[tableViewer.getTable().getSelectionIndex()];	
				item.setText(2,dataset.getName());
				item.setData(dbdInfo);
				tableViewer.refresh();
				currentChangedData = dataset.getName();
				setPageComplete(isPageComplete());
			}
			
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}
		});
		dialog.open();
		}
	}
	
	/*
	 * @parra12
	 * getWCResponse : makes the wc request and checks the response to ensure there is atleast one dataset returned successfully.
	 * */
	private boolean getWCResponse(FileMasterDataset ds){
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new WCdsnRequestType(openDatabaseWizard.getFileMasterServer(),dataset.getName()).createXml());
			int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
    		if(uuid.equalsIgnoreCase("\""))
    			throw new TTException();
		} catch (TTException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		final HashMap<String, Object> map = new HashMap<String, Object>();
		SendRequestToMainframe req=new SendRequestToMainframe(openDatabaseWizard.getFileMasterServer(), map, "opendb", true, xmlDocument);
		//Temporary fix to wait for the response before trying to parse it.
				if(req.getResult()==Status.CANCEL_STATUS){
					return false;
				}
		response = req.getGuiResponseType();
		if(response==null)
			return false;
		//No error therefore proceed with further processing.
		if(response.getFunctionRC()==0 && response.getReturnCode() ==0){
			int numOfDsnReturned = response.getWildCardDataSetResponse().getDataSetInfoList().getDataSetInfo().size();
			return true;
		}
		for(int i=0;i<response.getMessages().getMessage().size();i++){
			String shortText = response.getMessages().getMessage().get(i).getShortText();
			String messageID = response.getMessages().getMessage().get(i).getMessageId();
			List<String> messageText = response.getMessages().getMessage().get(i).getMessageText();
			TT_ErrorDialog.openError(null, "Error", messageID+": "+shortText, new Throwable(messageText.get(0)));
		}
		return false;
	}

	@Override
	public IWizardPage getNextPage() {
		openDatabaseWizard = ((OpenDatabaseWizard)this.getWizard());
		if(openDatabaseWizard!=null){
		ArrayList<String> datasets = new ArrayList<String>();
		TableItem dbdDsn1String1 = null;
		String dbdDsn1String="";
		// Static validate dsn requests.
		if(tableViewer.getTable().getItemCount()>0){
			for(int i=0; i<tableViewer.getTable().getItems().length;i++){
			dbdDsn1String1 = tableViewer.getTable().getItem(i);
			dbdDsn1String= dbdDsn1String1.getText(2).trim();
		XMLDocument xmlDocument = null;
		try {
			xmlDocument = new XMLDocument(new ValidateDSNRequestType(openDatabaseWizard.getFileMasterServer(),
					dbdDsn1String).createXml());
			int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
    		if(uuid.equalsIgnoreCase("\""))
    			throw new TTException();
		} catch (TTException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
		HashMap<String, Object> map = new HashMap<String, Object>();
		
		// carel06
		// instead of a using the SendRequestToMainframeJob, I 
		// changed it to SendRequestToMainframe.
		// we are waiting for the results anyways so no need to put this in a separate thread.
		SendRequestToMainframe req = new SendRequestToMainframe(openDatabaseWizard.getFileMasterServer(), map, "opendb", true, xmlDocument);
		if(req.getResult() == Status.CANCEL_STATUS){
			return null;
		}
		// ParseResponse
		response = req.getGuiResponseType();
		if (response == null) {
			return null;
		}
		//navri01- i added this to fix defect 3078. we need to show Error when DSN does not exist.
		if(response.getFunctionRC()!=0 || response.getReturnCode()!=0){
			((OpenDatabaseWizard)this.getWizard()).showError(req);
			setPageComplete(false);
		}
			
		if (response.getValidateDSNResponse().getDataSetInfo() == null) {
			return null;
		}	
			
		DataSetInfoType dsInfo = response.getValidateDSNResponse().getDataSetInfo();
		if(dsInfo.getVolumeSerial()!=null)
		{
			if (dsInfo.getVolumeSerial().equalsIgnoreCase("ARCIVE")) {
				datasets.add(dsInfo.getDsname());
			}
		}	
			} // ending the for loop incase of error
		if (datasets.size() > 0) {
			RestoreArchiveDatasetsDialog radd = new RestoreArchiveDatasetsDialog(
					getShell(), datasets, openDatabaseWizard.getFileMasterServer());
			radd.create();
			radd.open();
			if(radd.getReturnCode() != 0)
				return null;
		}
			
		//@parra12: make the following call from where we want to save the data.
		saveData();
		
		OptionsWizardPage page = openDatabaseWizard.getPage(Messages.OpenDatabaseWizard_Page_Options) !=null ? ((OptionsWizardPage)openDatabaseWizard.getPage(Messages.OpenDatabaseWizard_Page_Options)) : new OptionsWizardPage(openDatabaseWizard.getFileMasterServer());
		((OpenDatabaseWizard)openDatabaseWizard).addPage(page);
		return page;
		}
		}
		return null;
	}

	@Override
	public boolean canFlipToNextPage() {
		// TODO Auto-generated method stub
		if(doIspageComplete)
			return isPageComplete();
		return false;
	}
	
	@Override
	public void setVisible(boolean visible) {
		//DBD = ((OpenDatabaseWizardPageDBD) ((OpenDatabaseWizard)this.getWizard()).getPage(Messages.OpenDatabaseWizard_Page2_DBD)).getDbd();
		super.setVisible(visible);
		container.setFocus();
	}

	public void saveData(){
		HashMap<String, String> hm = readFromFile();
		if(hm == null)
			hm = new HashMap<String, String>();
		OpenDatabaseWizard oDBWizard = ((OpenDatabaseWizard)this.getWizard());
		OpenDatabaseWizardPageServer oDBWizardPageServer = (OpenDatabaseWizardPageServer) oDBWizard.getPage(Messages.OpenDatabaseWizard_Page_Server);
		String imsEnv = oDBWizardPageServer.getImsEnvironment().trim();
		DBDInfo[] dbdInfoList = ((DBDInfo[])tableViewer.getInput());
		for(int count = 0; count < dbdInfoList.length; count++){
			if(hm.containsKey(imsEnv+dbdInfoList[count].getDBDName())){
				hm.remove(imsEnv+dbdInfoList[count].getDBDName());
			}
			hm.put(imsEnv+dbdInfoList[count].getDBDName(), dbdInfoList[count].getFmdataset().getName());
		}
		writeToFile(hm);
	}
	
	private void writeToFile(HashMap<String, String> hm){
		String filename = "DBDDSNInfo";
		try{
			IPath propertyPath = Platform.getStateLocation(Activator.plugin
					.getBundle());
			String filePathName = propertyPath.append(filename).toOSString();
		    File fileOne=new File(filePathName);
		    FileOutputStream fos=new FileOutputStream(fileOne);
		        ObjectOutputStream oos=new ObjectOutputStream(fos);
		        oos.writeObject(hm);
		        oos.flush();
		        oos.close();
		        fos.close();
		    }catch(Exception e){}
	}
	
	private HashMap<String, String> readFromFile(){
		//read from file 
		String filename = "DBDDSNInfo";
	    try{
	    	IPath propertyPath = Platform.getStateLocation(Activator.plugin
					.getBundle());
			String filePathName = propertyPath.append(filename).toOSString();
		    File toRead=new File(filePathName);
	        FileInputStream fis=new FileInputStream(toRead);
	        ObjectInputStream ois=new ObjectInputStream(fis);

	        HashMap<String,String> hm=(HashMap<String,String>)ois.readObject();

	        ois.close();
	        fis.close();
	        //print All data in MAP
	        /*for(Map.Entry<String,String> m :hm.entrySet()){
	            System.out.println(m.getKey()+" : "+m.getValue());
	        }*/
	        return hm;    
	    }catch(Exception e){
	    	return null;
	    }
	}
	//@parra12:The following method is used to set the input for the current table based on mainframe response.
	protected void setTableInput(){
		ArrayList<DBDInfo> dbdInfoList = null;
		if (((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).getDBDInfoList()==null){			
			if  (((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).isPSBPageRequired)
				dbdInfoList = ((OpenDatabaseWizardPagePCB)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_PCB)).getDBDInfoList();
			else if (((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).isSIXPageRequired)				
				dbdInfoList = ((OpenDatabaseWizardPageSIX)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_SIX)).getDBDInfoList();					 
		}
		else {	
		    dbdInfoList = ((OpenDatabaseWizardPageDBD)this.getWizard().getPage(Messages.OpenDatabaseWizard_Page_DBD)).getDBDInfoList();
		}
		
		//@parra12: code to retreive data from serialized hashmap.
		OpenDatabaseWizard oDBWizard = ((OpenDatabaseWizard)this.getWizard());
		OpenDatabaseWizardPageServer oDBWizardPageServer = (OpenDatabaseWizardPageServer) oDBWizard.getPage(Messages.OpenDatabaseWizard_Page_Server);
		String imsEnv = oDBWizardPageServer.getImsEnvironment();
		HashMap<String, String> hm = readFromFile();
		if(dbdInfoList!=null){
			if(hm != null)
			{
				for(int count = 0; count < dbdInfoList.size(); count ++){
						FileMasterDataset ds = new FileMasterDataset(null);
						ds.setName(hm.get(imsEnv+dbdInfoList.get(count).getDBDName()));
						dbdInfoList.get(count).setFmdataset(ds);
				}
			}
		if(tableViewer!=null)
		tableViewer.setInput(dbdInfoList.toArray(new DBDInfo[dbdInfoList.size()]));		
		}
		}
	

	public ArrayList<DBDInfo> getDbdDatasets(){

		ArrayList<DBDInfo> dbdDatasets = new ArrayList<DBDInfo>();
		if(tableViewer.getTable().getItemCount() > 0){
			for(int i=0; i<tableViewer.getTable().getItems().length;i++){
				DBDInfo dbdInfo = (DBDInfo)tableViewer.getTable().getItem(i).getData();
				dbdDatasets.add(dbdInfo);
			}
		}
		
		return dbdDatasets;
	}
	
	//grake02 3/NOV/2016 - create filter filter for 508 compliant problem.
	private void setupVPATColumnSorter()
	{
        //grake02 3/NOV/2016 - invoke sort dialog so that application is 508 compliant
		sortListenerVPAT = new Listener() 
        {
        	public void handleEvent(Event event) 
        	{
	            if (event.keyCode == SWT.F12)
	            {
	            	VPATSortDialog VPATdialog = new VPATSortDialog(getShell(), tableViewer);
	            	VPATdialog.create();
	            	if (VPATdialog.open() == Window.OK)
	            	{
	            		tableViewer.refresh();
	            	}
	            }
	        }
	    };
	    
	    getShell().getDisplay().addFilter(SWT.KeyDown, sortListenerVPAT);      				
	}
	
	public void dispose()
	{
		getShell().getDisplay().removeFilter(SWT.KeyDown, sortListenerVPAT);  //grake02 26/OCT/2016
		super.dispose();
	}		
}