/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;

import com.ca.fmp.ims.common.FileMasterDataset;
import com.ca.fmp.ims.common.FileMasterMember;
import com.ca.fmp.ims.common.FileMasterSegment;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.model.UnmarshalGUIResponse;
import com.ca.fmp.ims.model.ViewLayoutRequestType;
import com.ca.fmp.ims.model.generated.FieldListType;
import com.ca.fmp.ims.model.generated.FieldType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.YorNType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.wizardpages.CRLClass.LayoutField;
import com.ca.fmp.ims.view.wizards.FileMasterWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;

@SuppressWarnings("restriction")
public class GenericUpdatePage extends FileMasterWizard implements SelectionListener{
	static final String cacopyright = "Copyright  2016 CA";
	private final String CONTEXT_HELP_ID = "com.ca.fmp.ims.help.viewLayoutPage"; //$NON-NLS-1$
	private Composite container;
	private Composite layCompsite;
	private Label RecordLayoutLabel;
	private Text RecordLayoutData;
	private Combo datasetComboPage1;
	private Combo memberComboPage1;
	private String datasetView;
	private String memberview;
	private TableViewer tableViewer;
	protected String fieldName;
	private FileMasterDataset dataset;
	private FileMasterMember member;
	private TreeViewer treeViewer;
	private Tree tree;
	private String pageName;
	private ArrayList<Object> fmLayoutList = new ArrayList<Object>();
	private boolean occursField = true;
	LayoutField selectedLayoutField;
	private static final int FieldName = 0;
	private static final int Position = 1;
	private static final int Type = 2;
	private static final int Format = 3;
	private static final int Length = 4;
	private static final int Message = 4;

	public GenericUpdatePage(String pageName, FileMasterServer server, String datasetComboPage1,
			String memberComboPage1, String topLayoutName) {					
		super(pageName);
		this.pageName = pageName;
		setTitle("Field Name Selection");
		this.datasetView = datasetComboPage1;
		this.memberview = memberComboPage1;
		this.server = server;
		this.selectedLayoutField = null;
	}
	
	public GenericUpdatePage(String pageName, FileMasterServer server, String datasetComboPage1,
			String memberComboPage1, String topLayoutName, boolean occursField) {					
		super(pageName);
		this.pageName = pageName;
		setTitle("Field Name Selection");
		this.datasetView = datasetComboPage1;
		this.memberview = memberComboPage1;
		this.server = server;
		this.occursField = occursField;
		this.selectedLayoutField = null;
	}
	
	public GenericUpdatePage(String pageName, FileMasterServer server, String datasetComboPage1,
			String memberComboPage1, String topLayoutName, boolean occursField, LayoutField selectedLayoutField) {					
		super(pageName);
		this.pageName = pageName;
		setTitle(pageName);
		this.datasetView = datasetComboPage1;
		this.memberview = memberComboPage1;
		this.server = server;
		this.occursField = occursField;
		this.selectedLayoutField = selectedLayoutField;
	}
	
	public GenericUpdatePage(String pageName, FileMasterServer server, String datasetComboPage1,
			String memberComboPage1, String topLayoutName, LayoutField selectedLayoutField) {					
		super(pageName);
		this.pageName = pageName;
		setTitle("Field Name Selection");
		this.datasetView = datasetComboPage1;
		this.memberview = memberComboPage1;
		this.server = server;
		this.selectedLayoutField = selectedLayoutField;
	}	

	@Override
	public void createControl(Composite parent) {
		container = new Composite(parent, SWT.NULL);
		container.setLayout(new GridLayout(1, false));

		PlatformUI.getWorkbench().getHelpSystem()
				.setHelp(parent, CONTEXT_HELP_ID);

		layCompsite = new Composite(container, SWT.NULL);
		layCompsite.setLayout(new GridLayout(2, false));

		RecordLayoutLabel = new Label(layCompsite, SWT.NONE);
		RecordLayoutLabel.setText("&Record layout:");
		GridData gd_RecordLayoutLabel = new GridData(SWT.LEFT, SWT.CENTER,
				false, false, 1, 1);
		RecordLayoutLabel.setLayoutData(gd_RecordLayoutLabel);

		RecordLayoutData = new Text(layCompsite, SWT.READ_ONLY);
		if (datasetView != null)
			RecordLayoutData.setText(datasetView + "(" + memberview + ")");
		else
			RecordLayoutData.setText(datasetComboPage1.getText() + "("
					+ memberComboPage1.getText() + ")");
		GridData gd_RecordLayoutData = new GridData(SWT.LEFT, SWT.CENTER,
				false, false, 1, 1);
		RecordLayoutData.setLayoutData(gd_RecordLayoutData);
		createViewer(container);
	
		treeViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				setPageComplete(isPageComplete());
			}
		});
		
		if (this.pageName.endsWith("Select Field Name")){
			process("");
		}
		
		if (!this.pageName.equalsIgnoreCase("View Layout")){
			getShell().getDefaultButton().setText("OK");
		}
		
		setControl(container);
	
		Point size = getShell().computeSize(SWT.DEFAULT, SWT.DEFAULT);
		getShell().setSize(size);
	}

	private void createViewer(Composite parent) {
		treeViewer = new TreeViewer(parent, SWT.BORDER
				| SWT.FULL_SELECTION);
	    tree = treeViewer.getTree();
		tree.setHeaderVisible(true);
		tree.setLinesVisible(true);
		tree.addSelectionListener(this);
		GridData gd = new GridData(SWT.FILL, SWT.FILL, true, true);
        tree.setLayoutData(gd);
		treeViewer.setContentProvider(new FieldNameContentProvider());
		createColumns(parent, treeViewer);
	}


	public TableViewer getViewer() {
		return tableViewer;
	}

	private void createColumns(Composite parent, TreeViewer viewer) {
		String[] titles = { "Field","Position", "Type", "Format" ,"Message"};
		int[] bounds = { 225, 95,90, 50, 150 };
		for (int i = 0; i < titles.length; i++) {
			TreeViewerColumn treeViewerColumn = new TreeViewerColumn(viewer,SWT.NONE);
			TreeColumn treeColumn = treeViewerColumn.getColumn();

			treeColumn.setText(titles[i]);
			treeColumn.setWidth(bounds[i]);
			treeColumn.setResizable(true);
			switch (i) {
			case FieldName:
				treeViewerColumn
						.setLabelProvider(new FieldNameLabelProvider());
				break;
			case Position:
				treeViewerColumn
						.setLabelProvider(new PosLabelProvider());
				break;	
			case Type:
				treeViewerColumn.setLabelProvider(new TypeLabelProvider());
				break;
			case Format:
				treeViewerColumn.setLabelProvider(new FormatLabelProvider());
				treeViewerColumn.getColumn().setAlignment(SWT.RIGHT);
				break;
/*			case Length:
				treeViewerColumn.setLabelProvider(new LengthLabelProvider());
				treeViewerColumn.getColumn().setAlignment(SWT.RIGHT);
				break;*/
			case Message:
				treeViewerColumn.setLabelProvider(new MessageLabelProvider());
				break;
			}
		}
		treeViewer.setAutoExpandLevel(AbstractTreeViewer.ALL_LEVELS);
	}

	@Override
	public boolean isPageComplete() {
		if(getShell().getParent().getData() instanceof WorkbenchWindow) {
			return true;
		}
				
		if(tree.getSelectionCount() > 0) {											
			for (int i=0; i<tree.getSelectionCount(); i++){														
				if ( (tree.getSelection()[i].getData()) instanceof FileMasterLayout){
					setErrorMessage("01 level selected");
					return false;
				} else {
					fieldName = (((FileMasterLayoutField) (tree.getSelection()[i].getData())).getText());
																				
					String error = "";
					String compareFieldName = selectedLayoutField.getField();
					
					FileMasterLayoutField fmlf = (FileMasterLayoutField) (tree.getSelection()[i].getData());
					String formatLength;
					
					if(!fmlf.getFractionLength().equalsIgnoreCase("0")){
						formatLength = fmlf.getIntegerLength()+"."+fmlf.getFractionLength();
					}
					else if(!fmlf.getIntegerLength().equalsIgnoreCase("0")){
						formatLength = fmlf.getIntegerLength();
					} else {
						formatLength = fmlf.getLength();	
					}
					formatLength = fmlf.getLength();
					//@parra12: removed to fix defect 3222
					/*if (!formatLength.equalsIgnoreCase(String.valueOf(selectedLayoutField.getLength()))) 															
						error = error + "Length of " + fieldName  + " field name does not match length of " + compareFieldName + " field name\n ";*/
					
//					if ( !((((FileMasterLayoutField) (tree.getSelection()[i].getData())).getLength()).equalsIgnoreCase(selectedLayoutField.getFormatLength()))) 															
//						error = error + "Length of " + fieldName  + " field name does not match length of " + compareFieldName + " field name\n ";
														
					String signed="";
					String formatChar=selectedLayoutField.getFormatType().substring(0, 1);
					
					if (selectedLayoutField.getFormatType().length()==2){
						if (selectedLayoutField.getFormatType().substring(1, 2).equalsIgnoreCase("S"))
							signed="Y";
					} else {
						signed = "N";
					}
					//@parra12: removed to fix defect 3222
					/*if ( !( (((FileMasterLayoutField) (tree.getSelection()[i].getData())).getFormatChar()).equalsIgnoreCase(formatChar)))											
						error = error + "Type of " + fieldName + "  field name does not match type of " + compareFieldName + " field name\n";	*/						
							
					if (!error.equalsIgnoreCase("")){						
						setErrorMessage(error);
						return false;					
				    }										
				}							
			}
					
			setErrorMessage(null);
			return true;						
		} else {
			return false;
		}
	}
	
	public void doGetFieldName(boolean isSelectionPage) {

	}

	@Override
	public boolean canFlipToNextPage() {
		return false;
	}

	public boolean process(String layoutParm) {
 if(fmLayoutList.isEmpty()){
		dataset = new FileMasterDataset(null);
		member = new FileMasterMember();
		
		if (datasetView != null) {
			dataset.setName(datasetView);
			member.setName(memberview);
		} else {
			dataset.setName(datasetComboPage1.getText().trim());
			member.setName(memberComboPage1.getText().trim());
		}
		//Make a view layout request
		/*final RunGetViewLayout runner;
		if(topLayoutName.isEmpty()){
			runner = new RunGetViewLayout(dataset.getText(), member.getText(), server, occursField);
		}else{
			runner = new RunGetViewLayout(dataset.getText(), member.getText(), server, occursField, topLayoutName);
		}
		BusyIndicator.showWhile(PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getShell().getDisplay(), runner);
		xml = runner.getXml();*/
		final GUIResponseType xml;
		XMLDocument xmlDocument;
		try {
			xmlDocument = new XMLDocument(new ViewLayoutRequestType(server,
					dataset.getName(),member.getName()).createXml());
			int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
    		if(uuid.equalsIgnoreCase("\""))
    			throw new TTException();
		} catch (TTException exception) {
			// TODO Auto-generated catch block
			exception.printStackTrace();
			return false;
		}
		SendRequestToMainframe req = new SendRequestToMainframe(server, new HashMap<String, Object>(), "opendb", true, xmlDocument);
		if(req.getResult() == Status.CANCEL_STATUS){
			return false;
		}
		// ParseResponse
		xml = req.getGuiResponseType();
		if (xml != null) {
			/*Element element = xml.getRoot();
			if(element.getAttribute("errorlevel").equalsIgnoreCase("32")){
				TT_ErrorDialog.openError(null,"Error","Return Code:"+" "+element.getAttribute("errorlevel"),new Throwable(element.getAttribute("msg").replace("+", " ") +". "+ element.getAttribute("reason").replace("+", " ")));
			}
			else{
			NodeList nodes = element
					.getElementsByTagName(FMXMLProfile.FIELD);
			NodeList messages = element.getElementsByTagName("Message");
			NodeList retCode = element.getElementsByTagName("ReturnCode");
			String message = "";
			if (nodes.getLength() == 0) {
				for (int i = 0; i < messages.getLength(); i++) {
					Node msgNode = (Node) messages.item(i);
					Element msgElement = (Element) msgNode;
					message += getTagValue("Message", msgElement);					
				}
				Node rcNode = (Node) retCode.item(0);
				Element rcElement = (Element) rcNode;
				String returnCode= getTagValue("ReturnCode", rcElement);						
				TT_ErrorDialog.openError(null,"Error","Return Code:"+" "+returnCode,new Throwable(message));
				return false;
			} else {*/
				
				//Object lastObject = null;
				CRLClass crl = new CRLClass();
				CRLClass.Layout layouttoAdd;
				layouttoAdd = crl.addLayout(dataset.getName(), member.getName());
				boolean has01Level= false;
				FieldListType flt = xml.getViewLayoutResponse().getFieldList();
				for (int i = 0; i < flt.getField().size(); i++) {
					FieldType ft= flt.getField().get(i);
					/*Element layoutElement = (Element) nodes.item(i);
					Element NameElement = (Element)(layoutElement.getElementsByTagName("Name").item(0));
					Element levelElement = (Element)(layoutElement.getElementsByTagName("Level").item(0));
					Element signedElement = (Element)(layoutElement.getElementsByTagName("Signed").item(0));
					Element integerLenElement = (Element)(layoutElement.getElementsByTagName("IntegerLength").item(0));
					Element fractionLenElement = (Element)(layoutElement.getElementsByTagName("FractionLength").item(0));
					Element occursElement = (Element)(layoutElement.getElementsByTagName("Occurs").item(0));
					Element lengthElement = (Element)(layoutElement.getElementsByTagName("Length").item(0));
					Element positionElement = (Element)(layoutElement.getElementsByTagName("Position").item(0));
					Element redefineInfoElement = (Element)(layoutElement.getElementsByTagName("RedefineInfo").item(0));*/
					
					
					if (ft.getLevel() == 01) {
						FileMasterLayout layout = new FileMasterLayout(null);
						layout.setName(ft.getName());
						layout.setLevel(String.valueOf(ft.getLevel()));
						layout.setIntegerLength("0");
						layout.setFractionLength("0");
						if(!occursField) 
							layout.setOccurs(String.valueOf(ft.getOccurs()));
						
						layout.setLength(String.valueOf(ft.getLength()));
						layout.setPosition(String.valueOf(ft.getPosition()));
						if(ft.getRedefineInfo()!=null){
							layout.setRedefineInfo(ft.getRedefineInfo().value());
						}
						else{
							layout.setRedefineInfo("");
						}
						
						fmLayoutList.add(layout);
					} else {
						//Element formatCharElement = (Element)(layoutElement.getElementsByTagName("FormatChar").item(0));
						
						FileMasterLayoutField layout = new FileMasterLayoutField(null);
						layout.setName(ft.getName());
						layout.setLevel(String.valueOf(ft.getLevel()));
						if(ft.getFormatChar()!=null)
							layout.setFormatChar(ft.getSigned() ==YorNType.Y ? ft
									.getFormatChar() +"S" : ft.getFormatChar());
						layout.setSigned(ft.getSigned() == YorNType.Y.Y ? "Y" : "N");
						layout.setIntegerLength(ft.getIntegerLength() == null ? "0" : String.valueOf(ft.getIntegerLength()));
						layout.setFractionLength(ft.getFractionLength() == null ? "0" : String.valueOf(ft.getFractionLength()));
						if(!occursField)
							layout.setOccurs(String.valueOf(ft.getOccurs()));
						
						layout.setLength(String.valueOf(ft.getLength()));
						layout.setPosition(String.valueOf(ft.getPosition()));
						if(ft.getRedefineInfo()!=null){
							layout.setRedefineInfo(ft.getRedefineInfo().value());
						}
						else{
							layout.setRedefineInfo("");
						}
						
							for(int j = fmLayoutList.size()-1; j >=0; j--){
								if(fmLayoutList.get(j) instanceof FileMasterLayout){
									if(Integer.parseInt(((FileMasterLayout)fmLayoutList.get(j)).getLevel()) < Integer.parseInt(layout.getLevel())){
										((FileMasterLayout)fmLayoutList.get(j)).addChildFields(layout);
										break;
									}
								}
								if(fmLayoutList.get(j) instanceof FileMasterLayoutField){
									if(Integer.parseInt(((FileMasterLayoutField)fmLayoutList.get(j)).getLevel()) < Integer.parseInt(layout.getLevel())){
										((FileMasterLayoutField)fmLayoutList.get(j)).addChildFields(layout);
										break;
									}
								}
							}
					
						fmLayoutList.add(layout);
				
					}

				}
				/*for (int i = 0; i < flt.getField().size(); i++) {
					FieldType ft= flt.getField().get(i);

					if(ft.getLevel() == 01){
						if(has01Level){
							crl.setMultiple01Levels(true);
						}
						else{
							has01Level = true;
						}
					}
					layouttoAdd.addField(ft.getName(),
							ft.getLevel(),
							ft.getLevel()==01,
							true,
							ft.getPosition() == null ? 0 : ft.getPosition().intValue(),
							ft.getFormatChar(),
							ft.getLength() == null ? 0 : ft.getLength().intValue(),
							CRLClass.NONE,
							CRLClass.NONE,
							"");
				}*/
				if(treeViewer!=null){
					treeViewer.setInput(fmLayoutList
							.toArray(new Object[fmLayoutList.size()]));
					
					treeViewer.refresh();
					return true;
				} else{
					return false;
				}
			//}
		}
		}
		return false;
 }

	public boolean doviewFinish() {
		// TODO Auto-generated method stub
		return true;
	}
	
	public void setServer(FileMasterServer server)
	{
		this.server = server;
	}

	@Override
	public void widgetSelected(SelectionEvent e) {
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}
	 @Override
		public void setVisible(boolean visible) {
			// TODO Auto-generated method stub

			super.setVisible(visible);
			RecordLayoutData.setFocus();
		}

	/**
	 * @return the fmLayoutList
	 */
	public ArrayList<Object> getFmLayoutList() {
		return fmLayoutList;
	}

	/**
	 * @param fmLayoutList the fmLayoutList to set
	 */
	public void setFmLayoutList(ArrayList<Object> fmLayoutList) {
		this.fmLayoutList = fmLayoutList;
	}
}
