/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.ca.fmp.ims.common.FMHistory;
import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.fmp.ims.common.FileMasterSegment;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.model.ValidateDSNRequestType;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.wizards.FormattedSelCritWizard;
import com.ca.fmp.ims.view.wizards.GenericImportWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class GenericSelectionBox implements SelectionListener {
	private Group segmentSelectionCriteriaGrp;
	public Label selectionCreteriaLabel;
	public Text selConditionText;
	public Composite laySelBtns;
	private Button layoutBtn;
	private Button importBtn;
	private Object wizard;
	private Shell parentShell;
	private FileMasterServer server;
	private Combo layoutDataSetCombo;
	private String envName;
	private String dbdName;
	//@parra12@: Variables for showError method. Should eventually go to a common class.
	ArrayList<String> shortText = new ArrayList<String>();
	ArrayList<String> messageID = new ArrayList<String>();
	List<String> messageText = new ArrayList<String>();
	String messageIDFinal="";
	String messageTextFinal= "";
	String title = "";
	private String selCritBoxContent = "";
	
	public GenericSelectionBox(String server,Object wizard) {
		this.wizard = wizard;
		this.server = FMServerTreeModel.getInstance().getServer(server);
		if (wizard instanceof WizardPage) {
			this.parentShell = ((WizardPage) wizard).getShell();
		} 
		}

	
	public void createConditionBoxContent(Composite parent) {
		createConditionBoxContent(parent, "La&yout...", "Impo&rt...","","", null);

	}
	public void createConditionBoxContent(Composite parent, String layoutBtnLbl, String importBtnLbl, final Combo layoutDataSetCombo) {
			createConditionBoxContent(parent, "La&yout...","Impo&rt...","","", layoutDataSetCombo);
	}

	public void createConditionBoxContent(Composite parent, String layoutBtnLbl,
			String importBtnLbl, final String envName, final String dbdName, final Combo layoutDataSetCombo) {
			this.layoutDataSetCombo = layoutDataSetCombo;
			this.envName = envName;
			this.dbdName = dbdName;
		 segmentSelectionCriteriaGrp = new Group(parent, SWT.NULL);
		 segmentSelectionCriteriaGrp.setLayoutData(new GridData(SWT.FILL, SWT.FILL,
				true, true, 1, 1));
		 segmentSelectionCriteriaGrp.setLayout(new GridLayout(2, false));
		 segmentSelectionCriteriaGrp.setText("Seg&ment selection criteria");
		
		selConditionText = new Text(segmentSelectionCriteriaGrp, SWT.V_SCROLL | SWT.MULTI | SWT.WRAP);
		selConditionText.setEditable(true);
		// selConditionText.setTextLimit(74);
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		selConditionText.setLayoutData(data);
		setWidth(selConditionText, 35, 65);
		
		// Create a composite to hold all the buttons
				laySelBtns = new Composite(segmentSelectionCriteriaGrp, SWT.NONE);
				GridLayout laySelBtns_layout = new GridLayout(1, false);
				laySelBtns_layout.marginHeight = 0;
				laySelBtns_layout.marginWidth = 0;
				laySelBtns.setLayout(laySelBtns_layout);
				laySelBtns.setLayoutData(new GridData(SWT.FILL, SWT.TOP, false, false, 1, 1));
				
				layoutBtn = new Button(laySelBtns, SWT.NONE);
				layoutBtn.setText(layoutBtnLbl);
				layoutBtn.addSelectionListener(new SelectionListener() {
					
					@Override
					public void widgetSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						//@parra12: Send validation for layoutDsn and CRL Dsn before opening the page.
						XMLDocument xmlDocument = null;
						GUIResponseType response;
						try {
							xmlDocument = new XMLDocument(new ValidateDSNRequestType(server,
									GenericSelectionBox.this.layoutDataSetCombo.getText()).createXml());
							int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
				    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
				    		if(uuid.equalsIgnoreCase("\""))
				    			throw new TTException();
						} catch (TTException exception) {
							// TODO Auto-generated catch block
							exception.printStackTrace();
							return;
						}
						SendRequestToMainframe req = new SendRequestToMainframe(server, new HashMap<String, Object>(), "opendb", true, xmlDocument);
						if(req.getResult() == Status.CANCEL_STATUS){
							return;
						}
						// ParseResponse
						response = req.getGuiResponseType();
						if (response == null) {
							return;
						}

						if(response.getFunctionRC()!=0 || response.getReturnCode()!=0){
							showError(req);
						}
							
						if (response.getValidateDSNResponse().getDataSetInfo() == null) {
							return;
						}		
						
						/*
						 * Gather Selection conditions and store in an array 1 condition
						 * per index
						 */
						
						//selConditionText.getText().trim().split("IFSEG")[1].split("\\(*\\)") - This will give the name of the segment
						//in first index with a ( as first character
						//selConditionText.getText().trim().split("IFSEG") - this will give all the conditions for one ifseg statement
						//per index
						selCritBoxContent = "";
						String[] selCondsTotestForSingleCondPerLine = selConditionText.getText().trim().split("\\r\\n");
						for(int i = 0; i < selCondsTotestForSingleCondPerLine.length ; i++){
							if(selCondsTotestForSingleCondPerLine[i].toUpperCase().contains("STARTKEY") || selCondsTotestForSingleCondPerLine[i].toUpperCase().contains("INLIM") || selCondsTotestForSingleCondPerLine[i].toUpperCase().contains("SELLIM"))
							{
								selCritBoxContent += selCondsTotestForSingleCondPerLine[i] + "\r\n";	
								selCondsTotestForSingleCondPerLine[i] = "";
							}
						}
						for(int i = 0; i < selCondsTotestForSingleCondPerLine.length ; i++){
							if(selCondsTotestForSingleCondPerLine[i].toUpperCase().contains("IFREC") || selCondsTotestForSingleCondPerLine[i].toUpperCase().contains("IFSEG"))
								break;
							selCritBoxContent += selCondsTotestForSingleCondPerLine[i];
						}
						String selConditionString = selConditionText.getText().trim().replaceAll("IFREC", "IFSEGR");
						selConditionString = selConditionString.replaceAll("STARTKEY(.*)", "");
						selConditionString = selConditionString.replaceAll("SELLIM(.*)", "");
						selConditionString = selConditionString.replaceAll("INLIM(.*)", "");
						String[] selCondsIfSeg = selConditionString.split("(?i)IFSEG");
						String[] selConds;
						String tempString = "";
						String tempStringUC = "";
						ArrayList<FileMasterSegment> fmpSegments = new ArrayList<FileMasterSegment>();
						HashMap<String, FileMasterSegment> fmpSegmentsMap = new HashMap<String, FileMasterSegment>();
						if(selConditionText.getText().toUpperCase().contains("IFREC") || selConditionText.getText().toUpperCase().contains("IFSEG")){
						for(String s : selCondsIfSeg){
							selConds = s.split("\\([a-zA-Z]*\\)");
							if(selConds.length > 0){
							Pattern pattern = Pattern.compile("\\(.*\\)");
							Matcher matcher = pattern.matcher(s);
							while(matcher.find()){
								tempString = matcher.group().substring(1, matcher.group().length()-1);
								tempStringUC = tempString.toUpperCase();
								if(fmpSegmentsMap.containsKey(tempStringUC))
										continue;
								else{
								FileMasterSegment fmpSegment = new FileMasterSegment();
								fmpSegment.setName(tempString);
								fmpSegment.setSelectionConditions(selConds[1]);
								if(s.substring(0, 1).equals("R"))
									fmpSegment.setIfSeg(false);
								fmpSegments.add(fmpSegment);
								fmpSegmentsMap.put(fmpSegment.getName().toUpperCase(), fmpSegment);
								
								}
							}
								//break;
							}
						}
						}
						else{
							
						}
						FMHistory.insertHistory(layoutDataSetCombo, "layoutDataSetComboGenericOptions");
						FormattedSelCritWizard Wiz = new FormattedSelCritWizard(parentShell,"Selection Criteria - Segments",server,GenericSelectionBox.this.envName,GenericSelectionBox.this.dbdName,GenericSelectionBox.this.layoutDataSetCombo.getText().trim(),fmpSegments);
						TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(parentShell, Wiz);
						dialog.create();
						FormattedSelCritWizardPage1.saveSelCrit.addSelectionListener(new SelectionListener() {

							@Override
							public void widgetSelected(SelectionEvent e) {
								// TODO Auto-generated method stub
								AddLayoutSelCondition(FormattedSelCritWizardPage1.getNewCondition());
								/*if (ImportSelCritWizardPage.getLayDsname() != null) {
									AddLayoutDatasetMember(ImportSelCritWizardPage.getLayDsname(), ImportSelCritWizardPage.getLayMem());
								}*/
							}

							@Override
							public void widgetDefaultSelected(SelectionEvent e) {
								// TODO Auto-generated method stub

							}
						});
						if(canTheDialogBeDisplayed(selCondsTotestForSingleCondPerLine))
							dialog.open();
					}
					
					@Override
					public void widgetDefaultSelected(SelectionEvent e) {
						// TODO Auto-generated method stub
						
					}
				});
				
				importBtn = new Button(laySelBtns, SWT.NONE);
				importBtn.setText(importBtnLbl);
				importBtn.setEnabled(true);
				importBtn.addSelectionListener(new SelectionListener() {

					@Override
					public void widgetSelected(SelectionEvent e) {

						String[] selConds = selConditionText.getText().trim().split("\\r\\n");
						GenericImportWizard Wiz = new GenericImportWizard("Import Selection Criteria", server, selConds, true);
						TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(parentShell, Wiz);
						dialog.create();
						ImportSelCritWizardPage.saveSelCrit.addSelectionListener(new SelectionListener() {

							@Override
							public void widgetSelected(SelectionEvent e) {
								// TODO Auto-generated method stub
								selCritBoxContent = "";
								AddLayoutSelCondition(ImportSelCritWizardPage.getNewCondition());
								if(layoutDataSetCombo!=null&& ImportSelCritWizardPage.layoutDsn!=null)
								layoutDataSetCombo.setText(ImportSelCritWizardPage.layoutDsn);
							}

							@Override
							public void widgetDefaultSelected(SelectionEvent e) {
								// TODO Auto-generated method stub

							}
						});
						dialog.open();
					}

					@Override
					public void widgetDefaultSelected(SelectionEvent e) {
					}
				});
				
	}
	
	/**
	 * 
	 * <p>
	 * This routine calculates widthHint to be the larger of <b>minimum</b> and
	 * text width but ensures it is never larger than <b>maximum</b>. The
	 * character 'W' is used to calculate character width in pixels for minimum
	 * and maximum
	 * </p>
	 * <p>
	 * If maximim is less than 1 (0 || -1) then maximum is ignored
	 * </p>
	 * 
	 * @param text
	 *            - The Text widget being set
	 * @param minimum
	 *            - mimumum widthHint in characters
	 * @param maximum
	 *            - maximum widthHint in characters
	 */
	private void setWidth(Text text, int minimum, int maximum) {
		GridData data = (GridData) text.getLayoutData();
		if (data == null) {
			data = new GridData();
			text.setLayoutData(data);
		}
		GC gc = new GC(text);
		try {
			Point extent = gc.textExtent("W");//$NON-NLS-1$
			if (maximum < 1)
				maximum = Text.LIMIT; // as big as it gets
			int maxwidth = Math.min(extent.x * maximum, gc.textExtent(text.getText()).x);
			int minwidth = (extent.x * minimum) + 10;
			data.minimumWidth = minwidth;
			data.widthHint = Math.max(minwidth, maxwidth);
		} finally {
			gc.dispose();
		}
	}
	public String getText() {
		return selConditionText.getText();
	}

	public void setText(String conditions) {
		selConditionText.setText(conditions);
	}
	public void setFocus() {
		selConditionText.setFocus();
	}

	public void AddLayoutSelCondition(String layoutSelCondition) {
		if(selCritBoxContent.length()>4){
		if(!selCritBoxContent.substring(selCritBoxContent.length()-4).equals("\r\n")){
			selCritBoxContent+="\r\n";
		}
		}
		selCritBoxContent+=layoutSelCondition;
		selConditionText.setText(selCritBoxContent);
		selConditionText.setText(selConditionText.getText().replaceAll("\\r\\n\\r\\n", "\r\n"));
		// layoutDataset.set(layoutDataset2);
	}
	
	@Override
	public void widgetSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}
	
	public void setEnableLayoutBtn(boolean val){
		if(layoutBtn!=null)
		layoutBtn.setEnabled(val);
	}
	public void setDBDName(String dbdName){
		this.dbdName = dbdName;
	}
	public void setIMSEnvName(String envName){
		this.envName = envName;
	}
	private void showError(SendRequestToMainframe req) {
		// TODO Auto-generated method stub
		shortText = new ArrayList<String>();
		messageID = new ArrayList<String>();
		messageTextFinal = "";
		messageIDFinal ="";
	//check for error condition upon clicking finish- navri01
	if(req.getGuiResponseType().getReturnCode()!=0|| req.getGuiResponseType().getFunctionRC()!=0){
		for(int i=0;i<req.getGuiResponseType().getMessages().getMessage().size();i++){
			shortText.add(req.getGuiResponseType().getMessages().getMessage().get(i).getShortText());
			messageID.add(req.getGuiResponseType().getMessages().getMessage().get(i).getMessageId());
			if(req.getGuiResponseType().getMessages().getMessage().get(i).getMessageText()!=null)
			messageText.add(req.getGuiResponseType().getMessages().getMessage().get(i).getMessageText()+ "\n");
			else 
				messageText.add("");
		}
		for(int i=0;i<messageID.size();i++){
			messageIDFinal+= messageID.get(i)+" : " + shortText.get(i) + "\n" ;
			if(messageIDFinal.contains("CAWL101E")){
				title = "Information";
			}
			else 
				title = "Error";
			messageTextFinal+= messageText.get(i).substring(1, messageText.get(i).length()-2) + "\n";
			
		}
		TT_ErrorDialog.openError(null, title, messageIDFinal, new Throwable(messageTextFinal));
	}	
	}
	// This method checks if selConds items contain multiple statements on one line
		private boolean canTheDialogBeDisplayed(String[] selConds){
			String[] sC = selConds.clone();
			boolean error = false;
			
			for (int i=0;i<sC.length;i++)
				sC[i] = sC[i].trim(); 
					
			String modifyedCondition; 				
			for (int i=0; i<sC.length; i++){					
				modifyedCondition = "";
											
				// Removing values inside the single or double quotes. Needed since they can contain AND, OR, |, & and damage the evaluation.
				for (int j=0;j<sC[i].length();j++){						
					if (sC[i].charAt(j) =='\"'){
						modifyedCondition += sC[i].charAt(j);
						
						if (j+1<sC[i].length()){ 							
							j = sC[i].indexOf("\"",j+1);
							modifyedCondition += sC[i].charAt(j);
							continue;				
						}
						else
							break;
					}												
					if (sC[i].charAt(j) =='\''){					
						modifyedCondition += sC[i].charAt(j);
						if (j+1<sC[i].length()){ 						
							j = sC[i].indexOf("'",j+1);
							modifyedCondition += sC[i].charAt(j);
							continue;							
						}
						else
							break;						
					}																	
					modifyedCondition += sC[i].charAt(j); 						
				}
				
				// If line contains characters after the operand set error to true
				int pOR  = modifyedCondition.indexOf(" OR");
				if (pOR!=-1)
					if (modifyedCondition.length() > (pOR + 3))
						error = true;
					
			    int pAND  = modifyedCondition.indexOf(" AND");
			    if (pAND!=-1)
					if (modifyedCondition.length()> (pAND + 4))
						error = true;				    

			    pOR  = modifyedCondition.indexOf(" |");
				if (pOR!=-1)
					if (modifyedCondition.length() > (pOR + 2))
						error = true;
					
			    pAND  = modifyedCondition.indexOf(" &");
			    if (pAND!=-1)				    
					if (modifyedCondition.length() > (pAND + 2))
						error = true;						
					
				if (error){		
					TT_ErrorDialog.openError(null,"Error","Layout dialog cannot be displayed",
							new Throwable("Only one command per line is allowed. You must break compound statements into separate lines in order for them to display in the Layout dialog."));				
					return false;	
				}																																								        					         					    
			}
			return true;	   						
		}
}
