/***********************************************************************

Copyright (c) 2016 CA.  All rights reserved.

This software and all information contained therein is confidential and
proprietary and shall not be duplicated, used, disclosed or disseminated
in any way except as authorized by the applicable license agreement,
without the express written permission of CA ("CA"). All authorized
reproductions must be marked with this language.

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT
PERMITTED BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY
OF ANY KIND, INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL
CA BE LIABLE TO THE END USER OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE,
DIRECT OR INDIRECT, FROM THE USE OF THIS SOFTWARE, INCLUDING WITHOUT
LIMITATION, LOST PROFITS, BUSINESS INTERRUPTION, GOODWILL, OR LOST DATA,
EVEN IF CA IS EXPRESSLY ADVISED OF SUCH LOSS OR DAMAGE.

***********************************************************************/

package com.ca.fmp.ims.view.serverwizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import com.ca.fmp.ims.common.FileMasterServer;

/**
 * TODO: EC - add more documentation
 * explain why there are two constructor classes.
 * document all public methods
 * 
 *
 * @author godch01 // 
 */
public class AddServerWizard extends Wizard implements INewWizard{
	static String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	private AddServerWizardPage page;
	private FileMasterServer server;
	private boolean newItem = true;

	/**
	 *
	 */
	public AddServerWizard() {
		super();
		setForcePreviousAndNextButtons(false);
		setNeedsProgressMonitor(false);
		
	}

	public AddServerWizard(FileMasterServer server) {
		this();
		this.server = server;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish() {
		return page.performUpdate();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages() {
		String title;
		if (newItem){
			title = "New Server";
		setWindowTitle("New Server Definition ");//$NON-NLS-1$
		}
		else {
			title = String.format("Update %s", server.toString()); //$NON-NLS-1$ //$NON-NLS-1$
			setWindowTitle("Update Server Definition");
		}
		page = new AddServerWizardPage("", title, null); //$NON-NLS-1$
		page.SetServer(server);
		addPage(page);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWizard#init(org.eclipse.ui.IWorkbench, org.eclipse.jface.viewers.IStructuredSelection)
	 */
	public void init(IWorkbench workbench, IStructuredSelection selection) {
	}

	/**
	 * TODO: EC - can't you just remove this method since you are not doing 
	 * anything different from the parent class.
	 */
	@Override
    public Image getDefaultPageImage () {
        return super.getDefaultPageImage();
    }

	public void setNewItem(boolean newItem) {
		this.newItem = newItem;
		if (newItem){
			server = null;
			setWindowTitle("New Server Definition"); //$NON-NLS-1$
		} else {
			setWindowTitle("Update Server Definition"); //$NON-NLS-1$
		}
	}

	/**
	 * TODO: can we remove this code, nobody is using it.
	 */
	public boolean isNewItem() {
		return newItem;
	}

	/**
	 * TODO: EC - this is your call but I have a distrust of ternery operators
	 * b/c it is confusing for me.  Can we make this simpler.  
	 * TODO: EC - nobody is calling this method, can we remove it.
	 */
    public FileMasterServer getServer() {
        return page == null?server:page.getServer();
    }
}
