/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/
package com.ca.fmp.ims.view.databaselist;
/**
 * @author navri01
 *
 */
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

import com.ca.testingtools.core.TT_TreeItem;

public class DatabaseListViewLabelProvider implements ILabelProvider, IFontProvider {

	static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	private FilteredTree filterTree;
	private PatternFilter filterForBoldElements = new PatternFilter();	
	
	public DatabaseListViewLabelProvider(FilteredTree filterTree) {
		super();
		this.filterTree = filterTree;
	}	
	
	@Override
	public Image getImage(Object element) {
		return ((TT_TreeItem)element).getImage();
	}
	
	@Override
	public String getText(Object element) {
		return ((TT_TreeItem)element).getText();
	}
	
	@Override
	public void addListener(ILabelProviderListener listener) {
	}
	
	@Override
	public void dispose() {
	}
	
	@Override
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}
	
	@Override
	public void removeListener(ILabelProviderListener listener) {
	}
	 
	public Font getFont(Object element) {
		return FilteredTree.getBoldFont(element, filterTree, filterForBoldElements);
	}		
}
