/**
 * Copyright (c) 2016 CA, All rights reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.filemaster.dsnlists.wizards;

/**
 * @author polra04
 *
 */
import java.util.ArrayList;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.ui.wizards.FilesDatasetWizardPage;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;

public class InsertDataSetWizardPage extends FilesDatasetWizardPage {
	static final String cacopyright = "Copyright (c) 2016 CA"; //$NON-NLS-1$
	private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.insertdatasetDSNList"; //$NON-NLS-1$

	private ArrayList<String> dsnList;
	private int index;
	private FileMasterServer server;

	/**
	 * 
	 * @param dataset
	 * @param server
	 * @param newItem
	 * @param title
	 */
	public InsertDataSetWizardPage(FileMasterDataset dataset, FileMasterServer server,
			boolean newItem, String title, ArrayList<String> dsnList, int index) {
		super(dataset, server, newItem, title);

		this.dsnList = dsnList;
		this.index = index;
		this.server = server;
	}

	public void createControl(Composite parent) {
		super.createControl(parent);
		PlatformUI.getWorkbench().getHelpSystem().setHelp(parent, CONTEXT_HELP_ID);
	}

	@Override
	public boolean isPageComplete() {
		String error = new String();
		changeServer();
		String datasetNameTrimmed = datasetname.getText().replace("\"", " ");
		datasetNameTrimmed = datasetNameTrimmed.trim().toUpperCase();

		if (!(datasetname == null || volumename == null)){
			switch (Validator.dataset(datasetNameTrimmed, true)) {
			case Validator.DS_WILDCARD:
				error = error + Validator.errorMsg[Validator.DS_WILDCARD]
				                                   + "\n";
				if (viewer.getCheckedElements().length > 0) {
					error = new String();
				}
				select.setEnabled(true);
				break;
			case Validator.DS_INVALID:
			case Validator.DS_LONG:
			case Validator.DS_MISSING:
				error = error
				+ Validator.errorMsg[Validator.dataset(
						datasetNameTrimmed, true)] + "\n ";
				select.setEnabled(false);
				break;
			case Validator.NO_ERROR:
				select.setEnabled(false);
				break;
			}

			switch (Validator.volume(volumename.getText(), false)) {
			case Validator.VOL_INVALID:
				error = error
				+ Validator.errorMsg[Validator.volume(
						volumename.getText(), false)] + "\n ";
				break;
			}
		}

		if (error.length() > 0) {
			setErrorMessage(error);
			return false;
		}

		setErrorMessage(null);
		return changed;
	}

	@Override
	public boolean doFinish() {
		FMHistory.insertHistory(datasetname, "DatasetListFilesDatasetWizard");
		FMHistory.insertHistory(volumename, "VolumeListFilesDatasetWizard");

		if(index == -1){ //no item selected in DSNList table
			index = 0;
		}

		if (!tableItemsChecked()) {
			FileMasterDataset FMDataSet = CommonMFCalls.getFQDSN(
					datasetname.getText(),
					volumename.getText(),
					server);

			if(CommonMFCalls.RETURN_CODE.equals("0")){
				dsnList.add(index, FMDataSet.getName());
			} else {
				TT_ErrorDialog.openError(null,
						"Error",
						"Return Code: " + CommonMFCalls.RETURN_CODE,
						new Throwable(CommonMFCalls.MESSAGE));
				return false;
			}
			
		} else {
			for (int i = viewer.getTable().getItems().length -1 ; i >= 0; i--) {
				if (viewer.getTable().getItem(i).getChecked()) {
					dsnList.add(index, viewer.getTable().getItem(i).getText());
				}
			}
		}
		return true;
	}
}
