/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizards;

/**
 * @author parra12
 *
 */

import java.util.ArrayList;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

import com.ca.fmp.ims.common.FileMasterSegment;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.view.wizardpages.FormattedSelCritWizardPage1;

public class FormattedSelCritWizard extends Wizard implements INewWizard {

	private FormattedSelCritWizardPage1 formattedSelCritWizardpage;
	private FileMasterServer server;
	private String title;
	private String envName;
	private String dbdName;
	private String layoutName;
	private Shell shell;
	private boolean canFinish;
	private ArrayList<FileMasterSegment> fmpSegments;
	public FormattedSelCritWizard(Shell shell,String title, FileMasterServer server,String envName, String dbdName, String layoutName, ArrayList<FileMasterSegment> fmpSegments) {
		this.server = server;
		this.title = title;
		this.envName = envName;
		this.dbdName = dbdName;
		this.layoutName = layoutName;
		this.shell = shell;
		this.fmpSegments = fmpSegments;
		setWindowTitle("Selection Criteria - Segments");
		setForcePreviousAndNextButtons(false);
	}

	@Override
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		// TODO Auto-generated method stub

	}

	@Override
	public boolean performFinish() {
		formattedSelCritWizardpage.doFinish();
		return true;
	}

	public void addPages() {
		TrayDialog.setDialogHelpAvailable(true);

		formattedSelCritWizardpage = new FormattedSelCritWizardPage1(shell,title,server,envName, dbdName, layoutName, fmpSegments);

		addPage(formattedSelCritWizardpage);
	}

}
