/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;


import org.eclipse.jface.viewers.ColumnLabelProvider;

public class TypeLabelProvider  extends ColumnLabelProvider {
	
	@Override
	public String getText(Object element) {
		String signed = "";
		String type = "";
		if (element instanceof FileMasterLayout) {
			return "";
		} else {						
			if (((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("P") || ((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("PS"))
				type = "Packed";
			if (((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("N") ||((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("NS"))
				type =  "Numeric";
			if (((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("B")||((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("Binary") || ((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("BS"))
				type =  "Binary";
			if (((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("C")||((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("A"))
				type =  "Character";
				//type =  "A";
			if (((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("V"))
				type = "Varying";
			if (((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("X"))
				type = "Pointer";
			if (((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("1")
					|| ((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("2")
					|| ((FileMasterLayoutField) element).getFormatChar().equalsIgnoreCase("F"))
				type = "Floating point";
			if(type.length() == 0)
				type = ((FileMasterLayoutField) element).getFormatChar();
			
			if(((FileMasterLayoutField) element).getSigned().equalsIgnoreCase("Y") && type.length()!=0)
				signed = " Signed";			
										
			return type + signed;						
		}
	}
}
