/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/

package com.ca.fmp.ims.view.wizardpages;

/**
 * @author navri01
 *
 */

import java.util.ArrayList;

import com.ca.fmp.ims.common.FMNodeChild;
import com.ca.fmp.ims.common.FileMasterHeaderMap;
import com.ca.testingtools.core.TT_TreeItem;
/**
 * File Master Layout Field object represents all sub levels of the 01 level.
 * @author parra12
 *
 */
public class FileMasterLayoutField extends FMNodeChild {
	
	public static final String FORMAT_CHAR_N = "N";
	public static final String FORMAT_CHAR_C = "C";
	public static final String FORMAT_CHAR_P = "P";
	
	private String id = "";
	private String level = "";
	private String formatChar = "";
	private String signed = "";
	private String integerLength = "";
	private String fractionLength = "";
	private String occurs = "";
	private String length = "";
	private String operand = "";
	private String condition = "";
	private ArrayList<FileMasterLayoutField> childFields;
	
	public String getRedefineInfo() {
		return redefineInfo;
	}


	public void setRedefineInfo(String redefineInfo) {
		this.redefineInfo = redefineInfo;
	}


	private String position = "";
	private String redefineInfo = "";
	public FileMasterLayoutField(TT_TreeItem parent,String level, String formatChar,
			String signed, String integerLength, String fractionLength,
			String occurs, String length, String position, String redefineInfo) {
		super();
		setParent(parent);
		this.level = level;
		this.formatChar = formatChar;
		this.signed = signed;
		this.integerLength = integerLength;
		this.fractionLength = fractionLength;
		this.occurs = occurs;
		this.length = length;
		this.position = position;
		this.redefineInfo = redefineInfo;
	}


	public String getFormatChar() {
		return formatChar;
	}


	public void setFormatChar(String formatChar) {
		this.formatChar = formatChar;
	}


	public String getSigned() {
		return signed;
	}


	public void setSigned(String signed) {
		this.signed = signed;
	}


	public String getIntegerLength() {
		return integerLength;
	}


	public void setIntegerLength(String integerLength) {
		this.integerLength = integerLength;
	}


	public String getFractionLength() {
		return fractionLength;
	}


	public void setFractionLength(String fractionLength) {
		this.fractionLength = fractionLength;
	}


	public String getOccurs() {
		return occurs;
	}


	public void setOccurs(String occurs) {
		this.occurs = occurs;
	}


	public String getLength() {
		return length;
	}


	public void setLength(String length) {
		this.length = length;
	}


	public String getPosition() {
		return position;
	}


	public void setPosition(String position) {
		this.position = position;
	}


	public FileMasterLayoutField(TT_TreeItem parent) {
		super();
		setParent(parent);
	}


	public FileMasterLayoutField(TT_TreeItem parent, String level) {
		super();
		setParent(parent);
		this.level = level;

	}


	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}
	
	public String getLevel() {
		return level.length()  == 1 ? "0"+level : level;
	}
	
	
	public void setLevel(String level) {
		this.level = level;
	}


	protected ArrayList <FileMasterHeaderMap> headerMap = new ArrayList <FileMasterHeaderMap>();

	

	public ArrayList<FileMasterHeaderMap> getHeaderMap() {
		return headerMap;
	}
	public void setHeaderMap(ArrayList<FileMasterHeaderMap> headerMap) {
		this.headerMap = headerMap;
	}
	
	public void setHeaderMap(String header) {
		setHeaderMap(header, new String[0]);
	}

	public void setHeaderMap(String header, String[] overides) { //Assumes the prefix 'H ' exists
		int index = 2;
		int length = header.length();
		if (overides.length > 0){
			for(int ix = 0; ix < overides.length; ix++){
				String override = overides[ix].replace(' ', (char) 255);
				header = header.replaceAll(overides[ix], override);
			}
		}
		FileMasterHeaderMap prior = null;
		FileMasterHeaderMap current;
		for (;index < length;){
			// skip forward to next non blank
			for (; index < length && header.charAt(index) == ' ';index++);
			current = new FileMasterHeaderMap();
			current.beginIndex = index;					
			if (prior != null){
				 prior.endIndex = index;
				 prior.columnName = header.substring(prior.beginIndex, prior.endIndex).trim();
			}
			headerMap.add(current);
			prior = current;
			for (; index < length && header.charAt(index) != ' ';index++);
		}
		if (prior != null){
			 prior.endIndex = Integer.MAX_VALUE;
			 prior.columnName = header.substring(prior.beginIndex).trim();
		}
		if (overides.length > 0){
			for (int ix = 0;ix < headerMap.size();ix++){
				FileMasterHeaderMap item = headerMap.get(ix);
				item.columnName = item.columnName.replace((char) 255, ' ');
				headerMap.set(ix, item);
			}
		}
		return;
	}
	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof FileMasterLayoutField))
			return false;
		if (obj == this)
			return true;
		FileMasterLayoutField other = (FileMasterLayoutField) obj;
		String dsn = getName();
		String dsnother = other.getName();
		
		if (dsn == null || dsnother == null)
			return false;
		boolean result = dsn.equals(dsnother);
		if (result && dsn.isEmpty()){
			return getParent() == other.getParent(); 
		}
		return result;
	}

	private boolean fileNotfound = false;


	@Override
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public Object getAdapter(Class adapter) {
		if (adapter.isAssignableFrom(getClass()))
			return this;
		return null;
	}

	public boolean isFileNotfound() {
		return fileNotfound;
	}

	public void setFileNotfound(boolean fileNotfound) {
		this.fileNotfound = fileNotfound;
	}

	@Override
	public String getText() {
		String text = getName();
		if (text.isEmpty())
			return "Default Layout Field";
		if (isFileNotfound())
			text = text + " Not found";
		return text;
	}
	
	public void addChildFields(FileMasterLayoutField fmlField){
		if(childFields == null)
		{
			childFields = new ArrayList<FileMasterLayoutField>();
		}
		childFields.add(fmlField);
	}
	public ArrayList<FileMasterLayoutField> getChildFields(){
		return childFields;
	}
	public boolean hasChildFields(){
		return !(childFields == null);
	}


	public void setOperand(String operand) {
		this.operand = operand;
	}


	public String getOperand() {
		return operand;
	}


	public void setCondition(String condition) {
		this.condition = condition;
	}


	public String getCondition() {
		return condition;
	}

}

