/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/
package com.ca.fmp.ims.view.wizardpages;
/**
 * @author parra12
 *
 */
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

import com.ca.fmp.ims.common.DBDInfo;

public class DBDDSNWizardPageSorter extends ViewerSorter {
	static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
	/*
	 * These fields are used to set up logging
	 */
	private static final String sourceClass = DBDDSNWizardPageSorter.class.getName();
	Logger log = Logger.getLogger(sourceClass);
	Level baseLevel = log.getLevel();
	/* end of logging setup */
	@Override
	public int compare(Viewer viewer, Object e1, Object e2) {
		// date descending
		// time descending
		// job ascending
		TableViewer tableViewer = (TableViewer) viewer;
		Table table = tableViewer.getTable();
		TableColumn column = table.getSortColumn();
		Integer index = null;

		if (column != null)
		{
			if(column.getText() == "DBD Name")
				index = 0;
			if(column.getText() == "DD Name")
				index = 1;
			if(column.getText() == "Data Set Name (editable)")
				index = 2;
		}
			//index = (Integer) column.getData();
		if (index == null)
			index = 0;
		ColumnLabelProvider provider = (ColumnLabelProvider) tableViewer.getLabelProvider(index);
		String value1 = provider.getText(e1);
		String value2 = provider.getText(e2);
		int direction = table.getSortDirection();
		int rc = 0;
		switch(index){
			case 0:
				value1 = (provider.getText(((DBDInfo)e1).getDBDName()));
				value2 = (provider.getText(((DBDInfo)e2).getDBDName()));
				try {
					rc = (new String(value1.getBytes("Cp1047"))).compareTo(new String(value2.getBytes("Cp1047")));
				} catch (UnsupportedEncodingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				break;
			case 1:
				value1 = (provider.getText(((DBDInfo)e1).getDDName()));
				value2 = (provider.getText(((DBDInfo)e2).getDDName()));
				try {
					rc = (new String(value1.getBytes("Cp1047"))).compareTo(new String(value2.getBytes("Cp1047")));
				} catch (UnsupportedEncodingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				break;
			case 2:	
				value1 = (provider.getText(((DBDInfo)e1).getFmdataset().getName()));
				value2 = (provider.getText(((DBDInfo)e2).getFmdataset().getName()));
				try {
					rc = (new String(value1.getBytes("Cp1047"))).compareTo(new String(value2.getBytes("Cp1047")));
				} catch (UnsupportedEncodingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				break;
			default:
				
				break;
		}
		if (rc != 0)
			return direction == SWT.DOWN?-rc:rc;
		
		return direction == SWT.DOWN?-rc:rc;
	}
}
