/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/

package com.ca.fmp.ims.view.wizardpages;

/**
 * @author polra04
 *
 */
import java.util.ArrayList;

public class CRLClass {
	public static final int NONE = 0;
	public static final int EQ = 1;
	public static final int NE = 2;
	public static final int GT = 3;
	public static final int LT = 4;
	public static final int GE = 5;
	public static final int LE = 6;
	public static final int CO = 7;
	
	public static final String[] operators = {
		"(none)",
		"Equal",
		"Not Equal",		
		"Greater Than",
		"Less Than",				
		"Greater Than or Equal",
		"Less Than or Equal",
		"Contains"
	};
	
	public static final int OR = 1;
	public static final int AND = 2;
	public static final String[] logOperators = {"(none)", "OR", "AND"};

	private String datasetName;
	private String memberName;

	private String procParmVersion;
	private String description;
	private int offset;

	private ArrayList<Layout> layouts = new ArrayList<Layout>();
	
	private boolean multiple01Levels =false;
	
	public CRLClass() {
	}

	public CRLClass(String datasetName, String memberName, String description,
			int offset) {
		this.datasetName = datasetName;
		this.memberName = memberName;
		this.description = description;
		this.offset = offset;
	}

	public CRLClass(String datasetName) {
		this.datasetName = datasetName;
	}

	public Layout addLayout(String datasetName, String memberName) {
		Layout layout = new Layout(datasetName, memberName);
		this.layouts.add(layout);
		return layout;
	}
	
	public void addLayout(Layout layout) {
		this.layouts.add(layout);
	}

	public void removeLayout(int index) {
		this.layouts.remove(index);
	}

	public String getMemberName() {
		return memberName;
	}

	public String getDatasetName() {
		return datasetName;
	}
	
	public String getProcParmVersion(){
		return procParmVersion;
	}

	public String getDescription() {
		return description;
	}

	public int getOffset() {
		return offset;
	}

	public Layout getLayout(int index) {
		return this.layouts.get(index);
	}

	public ArrayList<Layout> getLayouts() {
		return this.layouts;
	}

	public void setMemberName(String memberName) {
		this.memberName = memberName;
	}

	public void setDatasetName(String datasetName) {
		this.datasetName = datasetName;
	}
	
	public void setProcParmVersion(String procParmVersion){
		this.procParmVersion = procParmVersion;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setOffset(int offset) {
		this.offset = offset;
	}
	
	public void setLayout(int index, Layout layout){
		this.layouts.set(index, layout);
	}

	public void setMultiple01Levels(boolean multiple01Levels) {
		this.multiple01Levels = multiple01Levels;
	}

	public boolean hasMultiple01Levels() {
		return multiple01Levels;
	}

	public class Layout {
		private String datasetName;
		private String memberName;
		private boolean isDefault = false;
		private String entryVersion;

		private ArrayList<LayoutField> layoutFields = new ArrayList<LayoutField>();

		public Layout() {

		};

		public Layout(String datasetName, String memberName) {
			this.datasetName = datasetName;
			this.memberName = memberName;
		}
		
		public Layout(String datasetName, String memberName, boolean isDefault) {
			this.datasetName = datasetName;
			this.memberName = memberName;
			this.isDefault = isDefault;
		}
		
		public Layout(String datasetName, String memberName, boolean isDefault, String entryVersion) {
			this.datasetName = datasetName;
			this.memberName = memberName;
			this.isDefault = isDefault;
			this.entryVersion = entryVersion;
		}

		public void addField(String fieldName, boolean isTop) {
			layoutFields.add(new LayoutField(fieldName, isTop));
		}

		public void addField(String fieldName, int level, boolean isTop, boolean selected,
				int position, String formatType, int formatNum, int formatDec, int length,
				int logOperator, int operator, String value) {
			layoutFields.add(new LayoutField(fieldName, level, isTop, selected,	position,
					formatType, formatNum, formatDec, length, logOperator, operator, value));
		}
		
		public LayoutField getLayoutField(int index) {
			return this.layoutFields.get(index);
		}

		public ArrayList<LayoutField> getLayoutFields() {
			return this.layoutFields;
		}

		public String getLayoutDataset() {
			return this.datasetName;
		}

		public String getLayoutMember() {
			return this.memberName;
		}

		public String getTopLayoutField() {
			for (int i = 0; i < layoutFields.size(); i++) {
				if (layoutFields.get(i).isTop()) {
					return layoutFields.get(i).getField();
				}
			}
			return "";
		}
		
		public String getTopLayoutLevelString() {
			for (int i = 0; i < layoutFields.size(); i++) {
				if (layoutFields.get(i).isTop()) {
					return layoutFields.get(i).getLevelString();
				}
			}
			return "";
		}
		
		public boolean isDefault() {
			return this.isDefault;
		}
		
		public Layout getCopy(){
			Layout l = new Layout();
			l.datasetName = this.datasetName;
			l.memberName = this.memberName;
			l.isDefault = this.isDefault;
			for(int i = 0; i < layoutFields.size(); i++){
				l.addField(
					layoutFields.get(i).getField(),
					layoutFields.get(i).getLevel(),
					layoutFields.get(i).isTop(),
					layoutFields.get(i).isSelected(),
					layoutFields.get(i).getPosition(),
					layoutFields.get(i).getFormatType(),
					layoutFields.get(i).getFormatNum(),
					layoutFields.get(i).getFormatDec(),
					layoutFields.get(i).getLength(),
					layoutFields.get(i).getLogOperator(),
					layoutFields.get(i).getOperator(),
					layoutFields.get(i).getValue());	
			}
			return l;
		}
		
		public void setDefault(boolean isDefault){
			this.isDefault = isDefault;
		}
		
		public String getEntryVersion(){
			return this.entryVersion;
		}
		
		public void setEntryVersion(String entryVersion){
			this.entryVersion = entryVersion;
		}
	}

	public class LayoutField {
		
		private String fieldName;
		private int level;
		private boolean isTop;
		private boolean selected;
		private int position;
		
		private int indent;
		
		private String formatType = "";
		private int formatNum;
		private int formatDec = -1;
		
		private int length = 0;
		
		private int logOperator;
		
		private int operator;
		private String value;

		protected LayoutField(String fieldName, boolean isTop) {
			this.fieldName = fieldName;
			this.isTop = isTop;
			this.indent = -1;
		}

		protected LayoutField(String fieldName, int level, boolean isTop, boolean selected,
				int position, String formatType, int formatNum, int formatDec, int length,
				int logOperator, int operator, String value) {
			this.fieldName = fieldName;
			this.level = level;
			this.isTop = isTop;
			
			this.selected = selected;
			this.position = position;
			this.indent = -1;
			this.formatType = formatType;
			this.formatNum = formatNum;
			this.formatDec = formatDec;
			this.length = length;
			this.logOperator = logOperator;
			this.operator = operator;
			this.value = value;
		}

		public LayoutField x(){
			return this;
		}

		public String getField() {
			return this.fieldName;
		}

		public void setField(String fieldName) {
			this.fieldName = fieldName;
		}		
		
		public String getLevelField(){						
			String spaceIndent = "";

			for (int j=0;j<indent;j++)
				spaceIndent += "   ";		
							
			return spaceIndent + getLevelString() + " " + this.fieldName;
		}
		
		public int getLevel(){
			return this.level;
		}
		
		public String getLevelString(){
			if(this.level < 10){
				return "0" + this.level;
			} else {
				return String.valueOf(level);
			}
		}

		public boolean isTop() {
			return this.isTop;
		}
		
		public boolean isSelected(){
			return this.selected;
		}
		
		public int getPosition() {
			return this.position;
		}
		
		public int getIndent(){
			return indent;
		}
		
		public void setIndent(int indent){
			this.indent = indent;
		}
		
		public String getFormatType(){
			return this.formatType;
		}
		
		public int getFormatNum(){
			return this.formatNum;
		}
		
		public int getFormatDec(){
			if(this.formatDec > -1){
				return this.formatDec;
			} else {
				return 0;
			}
		}
		
		public String getFormatLength(){
			String s;
			if(this.formatNum == 0 && this.formatDec == 0){
				s = String.valueOf(this.length);
			} else if(this.formatDec == 0){
				s = String.valueOf(this.formatNum);
			} else {
				s = this.formatNum + "." + this.formatDec;	
			}
			return s;			
		}
		
		public int getLength(){
			return this.length;
		}
		
		public String getFormatString(){
			if (formatType.equalsIgnoreCase("P"))
				return "Packed";
			if (formatType.equalsIgnoreCase("PS"))
				return "Packed Signed";
			if (formatType.equalsIgnoreCase("N"))
				return "Numeric";
			if (formatType.equalsIgnoreCase("NS"))
				return "Numeric Signed";
			if (formatType.equalsIgnoreCase("B"))
				return "Binary";
			if (formatType.equalsIgnoreCase("BS"))
				return "Binary Signed";
			if (formatType.equalsIgnoreCase("C"))
				return "Character";
			
			if (formatType.equalsIgnoreCase("V"))
				return "Varying";
			if (formatType.equalsIgnoreCase("X"))
				return "Pointer";
			if (formatType.equalsIgnoreCase("1"))
				return "Floating point";
			if (formatType.equalsIgnoreCase("2"))
				return "Floating point";
			if (formatType.equalsIgnoreCase("F"))
				return "Floating point";
			
			return formatType;
		}				
		
		public int getLogOperator(){
			return this.logOperator;
		}
		
		public int getOperator() {
			return this.operator;
		}
		
		public String getValue() {
			return this.value;
		}
		
		public void setSelected(boolean selected){
			this.selected = selected;
		}
		
		public void setLogOperator(int logOperator){
			this.logOperator = logOperator;
		}
		
		public void setOperator(int operator){
			this.operator = operator;
		}
		
		public void setValue(String value){
			this.value = value;
		}
	}
}