/**
* Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/
package com.ca.fmp.ims.view.handlers;
/**
*  author navri01
*/
import java.util.Map;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.testingtools.core.ServerStatusJob;
import com.ca.testingtools.core.TT_TreeItem;

public class RefreshServerHandler extends AbstractHandler implements IElementUpdater {
      static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$
      static private final FMServerTreeModel model = FMServerTreeModel.getInstance();
      
      public Object execute(ExecutionEvent event) throws ExecutionException {
            for (TT_TreeItem item : model.getServers()){
                  ServerStatusJob job = new ServerStatusJob(item);
                  job.schedule();
            }
            return null;
      }

      @SuppressWarnings("rawtypes")
      
      public void updateElement(UIElement element, Map parameters) {
      }

      
      public boolean isEnabled() {
            return model.getServers().length > 0;
      }

}



