/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

 ***********************************************************************/
package com.ca.fmp.ims.view.handlers;

import java.util.HashMap;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.w3c.dom.Element;

import com.ca.fmp.ims.common.FMServerTreeModel;
import com.ca.fmp.ims.common.FileMasterServer;
import com.ca.fmp.ims.model.ManagePrefsRequest;
import com.ca.fmp.ims.model.generated.GUIResponseType;
import com.ca.fmp.ims.model.generated.ManagePrefsResponseType;
import com.ca.fmp.ims.model.generated.ManagePrefsType;
import com.ca.fmp.ims.model.generated.PrefsActionType;
import com.ca.fmp.ims.model.generated.PrefsParmFilesType;
import com.ca.fmp.ims.operation.SendRequestToMainframe;
import com.ca.fmp.ims.view.databaselist.DatabaseListView;
import com.ca.fmp.ims.view.wizards.OpenDatabaseWizard;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;

public class OpenDatabase extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IWorkbenchWindow window=HandlerUtil.getActiveWorkbenchWindowChecked(event);
		Shell shell = window.getShell();
		
		IViewReference[] viewReferences = window.getActivePage().getViewReferences();
		for(int i = 0; i < viewReferences.length; i++){
			if(viewReferences[i].getId().startsWith("com.ca.fmp.ims.view.editor.EditorView")){
				MessageDialog.openError(shell, "Database is already open", "You cannot open more than one database at a time.");
				return null;
			}
		}
		
		IWorkbench workbench=window.getWorkbench();
		IViewPart dbList = window.getActivePage().findView("com.ca.fmp.ims.view.databaselist");
		ISelection selection = null;
		if(dbList != null && dbList instanceof DatabaseListView){
			selection = dbList.getViewSite().getSelectionProvider().getSelection();
		}
		if (!(selection instanceof IStructuredSelection))
			selection = null;
		
		FileMasterServer fileMasterServer = null;
		FMServerTreeModel model = FMServerTreeModel.getInstance();
		
		if(((IStructuredSelection)selection).getFirstElement()!=null){
			TT_TreeItem treeItem= ((TT_TreeItem)(((IStructuredSelection)selection).getFirstElement()));
			if (treeItem.getParent() == null) {
				fileMasterServer = (FileMasterServer) treeItem.getValue();
			}
		}
		
		// Load mainframe preferences if they are not loaded
		boolean preferenceIsSet = 
		((TT_TreeItem)(((IStructuredSelection)selection).getFirstElement())).getElement().getAttribute("PreferenceIsSet").equalsIgnoreCase("N") ? false : true;
				
		// Send the preferences to the MF			
		if (fileMasterServer.getStatusText().equalsIgnoreCase("active") && preferenceIsSet){											
			ManagePrefsType managePrefsType= new ManagePrefsType();		
			managePrefsType.setAction(PrefsActionType.S);
										
			PrefsParmFilesType prefsParmFilesType = new PrefsParmFilesType();
			prefsParmFilesType.setCustRecLay(fileMasterServer.getFmpPreferences().getCustRecLay());
			prefsParmFilesType.setDsnLists(fileMasterServer.getFmpPreferences().getDSNLists());
			prefsParmFilesType.setEnvirons(fileMasterServer.getFmpPreferences().getEnvirons());
			prefsParmFilesType.setSegmentXref(fileMasterServer.getFmpPreferences().getSegmentXref());
			prefsParmFilesType.setSelCriteria(fileMasterServer.getFmpPreferences().getSelCriteria());
										
			managePrefsType.setPrefsParmFiles(prefsParmFilesType);
		
			XMLDocument xmlDocument = null;
			try {
				xmlDocument = new XMLDocument(new ManagePrefsRequest(fileMasterServer, managePrefsType).createXml());
				int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
	    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
	    		if(uuid.equalsIgnoreCase("\""))
	    			throw new TTException();
			} catch (TTException e) {
				e.printStackTrace();
				return null;
			}				
												
			HashMap<String, Object> hashMap = new HashMap<String, Object>();
			SendRequestToMainframe req = new SendRequestToMainframe(fileMasterServer, hashMap, "opendb", true, xmlDocument);
			
			if(req.getResult() == Status.CANCEL_STATUS){
				return null;
			}
			
			// Extract needed element
			GUIResponseType response = req.getGuiResponseType();
			if (response == null) {
				return null;
			}
			
			ManagePrefsResponseType  managePrefsResponse = response.getManagePrefsResponse();				
			if (managePrefsResponse == null) {
				return null;
			}																						
		}					
		else if (fileMasterServer.getStatusText().equalsIgnoreCase("active") && !preferenceIsSet){								
			ManagePrefsType managePrefsType= new ManagePrefsType();		
			managePrefsType.setAction(PrefsActionType.G);
		
			XMLDocument xmlDocument = null;
			try {
				xmlDocument = new XMLDocument(new ManagePrefsRequest(fileMasterServer, managePrefsType).createXml());
				int begOfGUISession = xmlDocument.toString().indexOf("GUIsession=\"")+12;
	    		String uuid = xmlDocument.toString().substring(begOfGUISession,begOfGUISession+1);
	    		if(uuid.equalsIgnoreCase("\""))
	    			throw new TTException();
			} catch (TTException e) {
				e.printStackTrace();
				return null;
			}				
												
			HashMap<String, Object> map = new HashMap<String, Object>();
			SendRequestToMainframe req = new SendRequestToMainframe(fileMasterServer, map, "opendb", true, xmlDocument);
			
			if(req.getResult() == Status.CANCEL_STATUS){
				return null;
			}
			
			// Extract needed element
			GUIResponseType response = req.getGuiResponseType();
			if (response == null) {
				return null;
			}
			
			ManagePrefsResponseType  managePrefsResponse = response.getManagePrefsResponse();				
			if (managePrefsResponse == null) {
				return null;
			}				
							 				
			Element serverElement = model.updatePrefs(fileMasterServer.getElement(),
					managePrefsResponse.getPrefsParmFiles().getDsnLists(),
					managePrefsResponse.getPrefsParmFiles().getSelCriteria(),
					managePrefsResponse.getPrefsParmFiles().getCustRecLay(),
					managePrefsResponse.getPrefsParmFiles().getSegmentXref(),
					managePrefsResponse.getPrefsParmFiles().getEnvirons());
					
			model.updateModelPrefs(serverElement, (FileMasterServer) fileMasterServer);													
			model.updateserver(fileMasterServer.getElement(), fileMasterServer, "Y");
			model.save();				
		} 		
		
		OpenDatabaseWizard openDatabaseWizard = new OpenDatabaseWizard();
		openDatabaseWizard.init(workbench, (IStructuredSelection) selection);
		TestingToolsWizardDialog dialog = new TestingToolsWizardDialog(shell, openDatabaseWizard);
		dialog.create();
		dialog.open();
		return null;
	}

}
