/**
 * Copyright (c) 2016 CA, All rights Reserved.

This software and all information contained therein is confidential and 
proprietary and shall not be duplicated, used, disclosed or disseminated in any 
way except as authorized by the applicable license agreement, without the 
express written permission of CA. All authorized reproductions must be marked 
with this language.  

EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE EXTENT PERMITTED 
BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE WITHOUT WARRANTY OF ANY KIND, 
INCLUDING WITHOUT LIMITATION, ANY IMPLIED WARRANTIES OF MERCHANTABILITY OR 
FITNESS FOR A PARTICULAR PURPOSE.  IN NO EVENT WILL CA BE LIABLE TO THE END USER 
OR ANY THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE USE OF 
THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS, BUSINESS 
INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY ADVISED OF SUCH 
LOSS OR DAMAGE.

***********************************************************************/
package com.ca.fmp.ims.view.databaselist;
/**
 * @author navri01
 *
 */
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.part.ViewPart;

import com.ca.testingtools.core.TT_TreeItem;

public class DatabaseListViewContentProvider implements ITreeContentProvider {
	static final String cacopyright = "Copyright  2016 CA"; //$NON-NLS-1$	
	ViewPart viewPart;
	
	/**
	 * 
	 * @param viewPart
	 */
	public DatabaseListViewContentProvider(ViewPart viewPart) {
		super();
		this.viewPart = viewPart;
	}

	/**
	 * This figures out where to place it in the tree
	 * @param element
	 */

	
	@Override
	public void dispose() {

	}

	/**
	 * @param viewer
	 * @param oldInput
	 * @param newInput
	 */
	@Override
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		if (viewPart instanceof IPropertyChangeListener){
			if (oldInput instanceof TT_TreeItem[] ){
				TT_TreeItem[] servers = (TT_TreeItem[]) oldInput;
				for (TT_TreeItem server : servers){
					server.removeListener((IPropertyChangeListener) viewPart);
				}
			}
			if (newInput instanceof TT_TreeItem[] ){
				TT_TreeItem[] servers = (TT_TreeItem[]) newInput;
				for (TT_TreeItem server : servers){
					server.addListener((IPropertyChangeListener) viewPart);
				}
			}
		}
//		if (newInput != null)
//			TTServer.checkStatus();
		return;
	}

	/**
	 * @param inputElement
	 */
	@Override
	public Object[] getElements(Object inputElement) {
		if (inputElement instanceof TT_TreeItem[]){
			return (Object[]) inputElement;
		}
		return new Object[0];
	}

	/**
	 * @param parentElement
	 */
	@Override
	public Object[] getChildren(Object parentElement) {
		TT_TreeItem item = (TT_TreeItem) parentElement;
		if (item.hasChildren())
			return item.getChildren();
		return new Object[0];
	}

	/**
	 * @param element
	 */
	@Override
	public Object getParent(Object element) {
		TT_TreeItem item = (TT_TreeItem) element;
		return item.getParent();
	}

	/**
	 * @param element
	 */
	@Override
	public boolean hasChildren(Object element) {
		TT_TreeItem item = (TT_TreeItem) element;
		return item.hasChildren();
	}

}
