/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.MoreMessage;
import com.ca.testingtools.common.PacketMessage;
import com.ca.testingtools.common.StatusMessage;
import com.ca.testingtools.common.TTException;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class DSECT {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected ArrayList<PacketMessage> packetmessages = new ArrayList();
    protected static final int slackbytes = 8;
    private static final byte[] slack = new byte[8];
    private int errorLevel = 0;
    private String errorMessage = "OK";
    protected int errorCount = 0;

    public DSECT() {
    }

    public DSECT(ByteBuffer buffer) {
        try {
            this.setArray(buffer);
        }
        catch (Exception exception) {}
    }

    public void addMessage(PacketMessage message) {
        if (message != null) {
            Iterator<PacketMessage> it = this.packetmessages.iterator();
            while (it.hasNext()) {
                if (it.next() != message) continue;
                return;
            }
            this.packetmessages.add(message);
        }
    }

    public void addMessages(PacketMessage[] messages) {
        PacketMessage[] packetMessageArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            PacketMessage message = packetMessageArray[n2];
            this.addMessage(message);
            ++n2;
        }
    }

    public void setMessages(PacketMessage[] messages) {
        this.packetmessages.clear();
        this.addMessages(messages);
    }

    protected void reSequence(boolean force) {
        int seq = 1;
        for (PacketMessage item : this.packetmessages) {
            item.setSequencenumber(seq++, force);
        }
    }

    protected byte[] getArray() throws Exception {
        int messagecnt = 0;
        int packetlen = 8;
        byte[] buf = new byte[packetlen];
        for (PacketMessage item : this.packetmessages) {
            packetlen += item.getSize();
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream(packetlen += (this.packetmessages.size() - 1) * 8);
        stream.write(buf);
        for (PacketMessage item : this.packetmessages) {
            if (messagecnt++ > 0) {
                stream.write(slack);
            }
            stream.write(item.getBuffer().array());
        }
        buf = new byte[stream.size()];
        buf = stream.toByteArray();
        ByteBuffer buffer = ByteBuffer.wrap(buf);
        buffer.position(0);
        buffer.putInt(stream.size());
        buffer.putInt(this.packetmessages.size());
        return buf;
    }

    public int size() {
        return this.packetmessages.size();
    }

    protected abstract PacketMessage buildMessage(ByteBuffer var1) throws TTException, Exception;

    public void setArray(ByteBuffer buffer) throws Exception {
        this.setArray(buffer, true);
    }

    public void setArray(ByteBuffer buffer, boolean reload) {
        if (reload) {
            this.packetmessages.clear();
        } else {
            PacketMessage last = this.getLastMessage();
            if (last instanceof MoreMessage) {
                this.packetmessages.remove(last);
            }
        }
        buffer.position(0);
        if (buffer.remaining() < 8) {
            return;
        }
        if (buffer.getInt() > buffer.limit()) {
            return;
        }
        int messagecnt = buffer.getInt();
        int i = 0;
        while (i < messagecnt) {
            if (i > 0) {
                buffer.position(buffer.position() + 8);
            }
            int msglen = buffer.getInt(buffer.position());
            byte[] msg = new byte[msglen];
            buffer.get(msg);
            try {
                this.addMessage(this.buildMessage(ByteBuffer.wrap(msg)));
            }
            catch (Exception e) {
                this.addMessage(new StatusMessage(e));
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder string = new StringBuilder(String.format(" Messages:%d ", this.packetmessages.size()));
        for (PacketMessage element : this.packetmessages) {
            string.append("[" + element.toString() + "]");
        }
        return string.toString();
    }

    public PacketMessage[] getMessages() {
        if (this.packetmessages == null) {
            return null;
        }
        return this.packetmessages.toArray(new PacketMessage[this.packetmessages.size()]);
    }

    public PacketMessage getMessage(int messagenumber) {
        if (this.packetmessages == null) {
            return null;
        }
        int index = messagenumber - 1;
        if (index < 0 || index >= this.packetmessages.size()) {
            return null;
        }
        return this.packetmessages.get(index);
    }

    public PacketMessage getLastMessage() {
        if (this.packetmessages == null) {
            return null;
        }
        return this.getMessage(this.packetmessages.size());
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public void setErrorLevel(int errorLevel) {
        this.errorLevel = errorLevel;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        if (errorMessage != null) {
            int index = errorMessage.indexOf("<<-- STACK_TRACE -->>");
            this.errorMessage = index != -1 ? errorMessage.substring(0, index) : errorMessage;
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }
}

