/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.views.comm;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class ViewCommUtil {
    static final String cacopyright = "Copyright \u00a9 2016 CA";

    private EventAdmin getEventAdmin(Class viewClass) {
        BundleContext bundleContext = FrameworkUtil.getBundle((Class)viewClass).getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(EventAdmin.class.getName());
        EventAdmin eventAdmin = (EventAdmin)bundleContext.getService(ref);
        return eventAdmin;
    }

    public EventAdmin publishEventsOfView(Class viewClass, String topic, Map<String, Object> eventProps, EventType eventType) {
        EventAdmin eventAdmin = this.getEventAdmin(viewClass);
        if (eventType.equals((Object)EventType.SYNC)) {
            Event event = new Event(topic, eventProps);
            eventAdmin.sendEvent(event);
        } else if (eventType.equals((Object)EventType.ASYNC)) {
            Event event = new Event(topic, eventProps);
            eventAdmin.postEvent(event);
        } else {
            Event event1 = new Event(topic, eventProps);
            eventAdmin.sendEvent(event1);
            Event event2 = new Event(topic, eventProps);
            eventAdmin.sendEvent(event2);
        }
        return eventAdmin;
    }

    public boolean registerSubscriberService(Class viewClass, EventHandler eventHandler, String topic, Dictionary<String, String> eventProps) {
        BundleContext bundleContext = FrameworkUtil.getBundle((Class)viewClass).getBundleContext();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("event.topics", topic);
        bundleContext.registerService(EventHandler.class.getName(), (Object)eventHandler, props);
        return true;
    }

    public static enum EventType {
        SYNC,
        ASYNC,
        BOTH;

    }
}

