/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.views;

import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.actions.DSEFindAction;
import com.ca.db2.editor.ui.widgets.DSEMenuBar;
import com.ca.db2.editor.ui.widgets.DSEToolBar;
import com.ca.db2.editor.ui.widgets.DataSourceExplorer;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class DSEView
extends ViewPart {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    public static final String ID = "com.ca.db2.editor.views.DSEView";
    private static final Logger logger = Logger.getLogger(DSEView.class);
    private DataSourceExplorer explorer;
    private DSEMenuBar menuBar;
    private DSEToolBar toolBar;
    private Label statusBar;
    private Composite top;
    private int TEXT_STYLE = 12;

    public void createPartControl(Composite parent) {
        this.top = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        this.top.setLayout((Layout)gridLayout);
        this.createDSE(this.top);
        this.createActions();
        this.createToolbar(this.explorer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.top, "com.ca.db2.editor.datasourceexplorer");
        this.getSite().setSelectionProvider((ISelectionProvider)this.explorer.getTree().getViewer());
        this.enableComponents(false);
    }

    private void createToolbar(DataSourceExplorer explorer) {
        this.toolBar = new DSEToolBar(this);
    }

    private void createMenuBar(DataSourceExplorer explorer) {
        this.menuBar = new DSEMenuBar(this);
    }

    private void createDSE(Composite parent) {
        this.explorer = new DataSourceExplorer(this);
    }

    private void createStatusBar(Composite parent) {
        this.setStatusBar(new Label(parent, this.TEXT_STYLE));
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        this.getStatusBar().setLayoutData((Object)layoutData);
        this.getStatusBar().setText("Status bar");
    }

    public void setFocus() {
        if (this.top != null) {
            this.top.setFocus();
        } else {
            this.explorer.getTree().setFocus();
        }
    }

    public void setStatusBar(Label statusBar) {
        this.statusBar = statusBar;
    }

    public Label getStatusBar() {
        return this.statusBar;
    }

    public DSEMenuBar getMenuBar() {
        return this.menuBar;
    }

    public DSEToolBar getToolBar() {
        return this.toolBar;
    }

    public DataSourceExplorer getExplorer() {
        return this.explorer;
    }

    public void setParent(Composite parent) {
        this.top = parent;
    }

    public Composite getParent() {
        return this.top;
    }

    public void releaseResources() {
        try {
            this.explorer.releaseResources();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void dispose() {
        this.releaseResources();
        this.explorer.dispose();
        super.dispose();
    }

    public void enableComponents(boolean state) {
        this.explorer.getTree().getFilterControl().setEditable(state);
        BaseAction[] baseActionArray = this.getToolBar().getActions();
        int n = baseActionArray.length;
        int n2 = 0;
        while (n2 < n) {
            BaseAction action = baseActionArray[n2];
            action.updateUI();
            ++n2;
        }
    }

    public void onLogin() {
        List subsystemNodes = (List)Context.get(Context.Keys.SELECTED_SUBSYSTEMS);
        if (subsystemNodes == null) {
            this.explorer.loadData();
        } else {
            this.explorer.loadData(subsystemNodes);
        }
        this.enableComponents(true);
    }

    public void onLogout() {
        if (this.explorer != null) {
            this.explorer.setRoot(null);
            this.explorer.getViewer().setInput(null);
            this.explorer.getViewer().refresh();
            this.enableComponents(false);
        }
    }

    private void createActions() {
        new DSEFindAction(this);
    }
}

